/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class AverageSpeedDetails
extends AbstractPathDetailsBuilder {
    private final Weighting weighting;
    private final double precision;
    private Double decimalValue;
    private int prevEdgeId = -1;

    public AverageSpeedDetails(Weighting weighting) {
        this(weighting, 0.1);
    }

    public AverageSpeedDetails(Weighting weighting, double precision) {
        super("average_speed");
        this.weighting = weighting;
        this.precision = precision;
    }

    @Override
    protected Object getCurrentValue() {
        return this.decimalValue;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        double distance = edge.getDistance();
        if (distance < 0.1) {
            if (this.decimalValue != null) {
                return false;
            }
            this.decimalValue = null;
            return true;
        }
        double tmpVal = distance / (double)GHUtility.calcMillisWithTurnMillis(this.weighting, edge, false, this.prevEdgeId) * 3600.0;
        this.prevEdgeId = edge.getEdge();
        if (this.decimalValue == null || Math.abs(tmpVal - this.decimalValue) >= this.precision) {
            this.decimalValue = (double)Math.round(tmpVal / this.precision) * this.precision;
            return true;
        }
        return false;
    }
}

