/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.search.StringIndex;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.EdgeAccess;
import com.graphhopper.storage.GHNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.Collections;
import java.util.Locale;

class BaseGraph
implements Graph {
    private static final double INT_DIST_FACTOR = 1000.0;
    static double MAX_DIST = 2147483.647;
    final DataAccess edges;
    final DataAccess nodes;
    final BBox bounds;
    final NodeAccess nodeAccess;
    private static final String STRING_IDX_NAME_KEY = "name";
    final StringIndex stringIndex;
    final TurnCostStorage turnCostStorage;
    final BitUtil bitUtil;
    final EncodingManager encodingManager;
    final EdgeAccess edgeAccess;
    private final int intsForFlags;
    private final DataAccess wayGeometry;
    private final Directory dir;
    private final InternalGraphEventListener listener;
    protected int edgeCount;
    protected int N_EDGE_REF;
    protected int N_LAT;
    protected int N_LON;
    protected int N_ELE;
    protected int N_TC;
    int E_DIST;
    int E_GEO;
    int E_NAME;
    int edgeEntryBytes;
    int nodeEntryBytes;
    private boolean initialized = false;
    private int nodeCount;
    private int edgeEntryIndex;
    private int nodeEntryIndex;
    private long maxGeoRef;
    private boolean frozen = false;

    public BaseGraph(Directory dir, EncodingManager encodingManager, boolean withElevation, InternalGraphEventListener listener, boolean withTurnCosts, int segmentSize) {
        this.dir = dir;
        this.encodingManager = encodingManager;
        this.intsForFlags = encodingManager.getIntsForFlags();
        this.bitUtil = BitUtil.get(dir.getByteOrder());
        this.wayGeometry = dir.find("geometry");
        this.stringIndex = new StringIndex(dir);
        this.nodes = dir.find("nodes", DAType.getPreferredInt(dir.getDefaultType()));
        this.edges = dir.find("edges", DAType.getPreferredInt(dir.getDefaultType()));
        this.listener = listener;
        this.edgeAccess = new EdgeAccess(this.edges){

            @Override
            final int getEdgeRef(int nodeId) {
                return BaseGraph.this.nodes.getInt((long)nodeId * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF);
            }

            @Override
            final void setEdgeRef(int nodeId, int edgeId) {
                BaseGraph.this.nodes.setInt((long)nodeId * (long)BaseGraph.this.nodeEntryBytes + (long)BaseGraph.this.N_EDGE_REF, edgeId);
            }

            @Override
            final int getEntryBytes() {
                return BaseGraph.this.edgeEntryBytes;
            }

            @Override
            final long toPointer(int edgeId) {
                assert (this.isInBounds(edgeId)) : "edgeId " + edgeId + " not in bounds [0," + BaseGraph.this.edgeCount + ")";
                return (long)edgeId * (long)BaseGraph.this.edgeEntryBytes;
            }

            @Override
            final boolean isInBounds(int edgeId) {
                return edgeId < BaseGraph.this.edgeCount && edgeId >= 0;
            }

            public String toString() {
                return "base edge access";
            }
        };
        this.bounds = BBox.createInverse(withElevation);
        this.nodeAccess = new GHNodeAccess(this, withElevation);
        this.turnCostStorage = withTurnCosts ? new TurnCostStorage(this, dir.find("turn_costs")) : null;
        if (segmentSize >= 0) {
            this.setSegmentSize(segmentSize);
        }
    }

    private static boolean isTestingEnabled() {
        boolean enableIfAssert = false;
        if (!$assertionsDisabled) {
            enableIfAssert = true;
            if (!true) {
                throw new AssertionError(true);
            }
        }
        return enableIfAssert;
    }

    @Override
    public Graph getBaseGraph() {
        return this;
    }

    void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("You cannot configure this GraphStorage after calling create or loadExisting. Calling one of the methods twice is also not allowed.");
        }
    }

    void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("The graph has not yet been initialized.");
        }
    }

    protected int loadNodesHeader() {
        this.nodeEntryBytes = this.nodes.getHeader(4);
        this.nodeCount = this.nodes.getHeader(8);
        this.bounds.minLon = Helper.intToDegree((int)this.nodes.getHeader(12));
        this.bounds.maxLon = Helper.intToDegree((int)this.nodes.getHeader(16));
        this.bounds.minLat = Helper.intToDegree((int)this.nodes.getHeader(20));
        this.bounds.maxLat = Helper.intToDegree((int)this.nodes.getHeader(24));
        if (this.bounds.hasElevation()) {
            this.bounds.minEle = Helper.intToEle((int)this.nodes.getHeader(28));
            this.bounds.maxEle = Helper.intToEle((int)this.nodes.getHeader(32));
        }
        this.frozen = this.nodes.getHeader(36) == 1;
        return 10;
    }

    protected int setNodesHeader() {
        this.nodes.setHeader(4, this.nodeEntryBytes);
        this.nodes.setHeader(8, this.nodeCount);
        this.nodes.setHeader(12, Helper.degreeToInt((double)this.bounds.minLon));
        this.nodes.setHeader(16, Helper.degreeToInt((double)this.bounds.maxLon));
        this.nodes.setHeader(20, Helper.degreeToInt((double)this.bounds.minLat));
        this.nodes.setHeader(24, Helper.degreeToInt((double)this.bounds.maxLat));
        if (this.bounds.hasElevation()) {
            this.nodes.setHeader(28, Helper.eleToInt((double)this.bounds.minEle));
            this.nodes.setHeader(32, Helper.eleToInt((double)this.bounds.maxEle));
        }
        this.nodes.setHeader(36, this.isFrozen() ? 1 : 0);
        return 10;
    }

    protected int loadEdgesHeader() {
        this.edgeEntryBytes = this.edges.getHeader(0);
        this.edgeCount = this.edges.getHeader(4);
        return 5;
    }

    protected int setEdgesHeader() {
        this.edges.setHeader(0, this.edgeEntryBytes);
        this.edges.setHeader(4, this.edgeCount);
        this.edges.setHeader(8, this.encodingManager.hashCode());
        this.edges.setHeader(12, this.supportsTurnCosts() ? this.turnCostStorage.hashCode() : -1);
        return 5;
    }

    protected int loadWayGeometryHeader() {
        this.maxGeoRef = this.bitUtil.combineIntsToLong(this.wayGeometry.getHeader(0), this.wayGeometry.getHeader(4));
        return 1;
    }

    protected int setWayGeometryHeader() {
        this.wayGeometry.setHeader(0, this.bitUtil.getIntLow(this.maxGeoRef));
        this.wayGeometry.setHeader(4, this.bitUtil.getIntHigh(this.maxGeoRef));
        return 1;
    }

    void initStorage() {
        this.edgeEntryIndex = 0;
        this.nodeEntryIndex = 0;
        this.edgeAccess.init(this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(4), this.nextEdgeEntryIndex(this.encodingManager.getIntsForFlags() * 4));
        this.E_DIST = this.nextEdgeEntryIndex(4);
        this.E_GEO = this.nextEdgeEntryIndex(4);
        this.E_NAME = this.nextEdgeEntryIndex(4);
        this.N_EDGE_REF = this.nextNodeEntryIndex(4);
        this.N_LAT = this.nextNodeEntryIndex(4);
        this.N_LON = this.nextNodeEntryIndex(4);
        this.N_ELE = this.nodeAccess.is3D() ? this.nextNodeEntryIndex(4) : -1;
        this.N_TC = this.supportsTurnCosts() ? this.nextNodeEntryIndex(4) : -1;
        this.initNodeAndEdgeEntrySize();
        this.listener.initStorage();
        this.initialized = true;
    }

    boolean supportsTurnCosts() {
        return this.turnCostStorage != null;
    }

    void initNodeRefs(long oldCapacity, long newCapacity) {
        long pointer;
        for (pointer = oldCapacity + (long)this.N_EDGE_REF; pointer < newCapacity; pointer += (long)this.nodeEntryBytes) {
            this.nodes.setInt(pointer, -1);
        }
        if (this.supportsTurnCosts()) {
            for (pointer = oldCapacity + (long)this.N_TC; pointer < newCapacity; pointer += (long)this.nodeEntryBytes) {
                this.nodes.setInt(pointer, -1);
            }
        }
    }

    protected final int nextEdgeEntryIndex(int sizeInBytes) {
        int tmp = this.edgeEntryIndex;
        this.edgeEntryIndex += sizeInBytes;
        return tmp;
    }

    protected final int nextNodeEntryIndex(int sizeInBytes) {
        int tmp = this.nodeEntryIndex;
        this.nodeEntryIndex += sizeInBytes;
        return tmp;
    }

    protected final void initNodeAndEdgeEntrySize() {
        this.nodeEntryBytes = this.nodeEntryIndex;
        this.edgeEntryBytes = this.edgeEntryIndex;
    }

    final void ensureNodeIndex(int nodeIndex) {
        this.checkInitialized();
        if (nodeIndex < this.nodeCount) {
            return;
        }
        long oldNodes = this.nodeCount;
        this.nodeCount = nodeIndex + 1;
        boolean capacityIncreased = this.nodes.ensureCapacity((long)this.nodeCount * (long)this.nodeEntryBytes);
        if (capacityIncreased) {
            long newBytesCapacity = this.nodes.getCapacity();
            this.initNodeRefs(oldNodes * (long)this.nodeEntryBytes, newBytesCapacity);
        }
    }

    @Override
    public int getNodes() {
        return this.nodeCount;
    }

    @Override
    public int getEdges() {
        return this.edgeCount;
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public BBox getBounds() {
        return this.bounds;
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirection) {
        return this.edge(a, b).setDistance(distance).setFlags(this.encodingManager.flagsDefault(true, bothDirection));
    }

    private void setSegmentSize(int bytes) {
        this.checkNotInitialized();
        this.nodes.setSegmentSize(bytes);
        this.edges.setSegmentSize(bytes);
        this.wayGeometry.setSegmentSize(bytes);
        this.stringIndex.setSegmentSize(bytes);
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.setSegmentSize(bytes);
        }
    }

    synchronized void freeze() {
        if (this.isFrozen()) {
            throw new IllegalStateException("base graph already frozen");
        }
        this.frozen = true;
        this.listener.freeze();
    }

    synchronized boolean isFrozen() {
        return this.frozen;
    }

    public void checkFreeze() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot add edge or node after baseGraph.freeze was called");
        }
    }

    void create(long initSize) {
        this.nodes.create(initSize);
        this.edges.create(initSize);
        initSize = Math.min(initSize, 2000L);
        this.wayGeometry.create(initSize);
        this.stringIndex.create(initSize);
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.create(initSize);
        }
        this.initStorage();
        this.maxGeoRef = 4L;
        this.initNodeRefs(0L, this.nodes.getCapacity());
    }

    String toDetailsString() {
        return "edges:" + Helper.nf((long)this.edgeCount) + "(" + this.edges.getCapacity() / 0x100000L + "MB), nodes:" + Helper.nf((long)this.getNodes()) + "(" + this.nodes.getCapacity() / 0x100000L + "MB), name:(" + this.stringIndex.getCapacity() / 0x100000L + "MB), geo:" + Helper.nf((long)this.maxGeoRef) + "(" + this.wayGeometry.getCapacity() / 0x100000L + "MB), bounds:" + this.bounds;
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodes:");
        String formatNodes = "%12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_EDGE_REF", "N_LAT", "N_LON");
        NodeAccess nodeAccess = this.getNodeAccess();
        for (int i = 0; i < Math.min(this.nodeCount, 100); ++i) {
            System.out.format(Locale.ROOT, formatNodes, i, this.edgeAccess.getEdgeRef(i), nodeAccess.getLat(i), nodeAccess.getLon(i));
        }
        if (this.nodeCount > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes\n", this.nodeCount - 100);
        }
        System.out.println("edges:");
        String formatEdges = "%12s | %12s | %12s | %12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatEdges, "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_FLAGS", "E_DIST");
        IntsRef intsRef = new IntsRef(this.intsForFlags);
        for (int i = 0; i < Math.min(this.edgeCount, 100); ++i) {
            long edgePointer = this.edgeAccess.toPointer(i);
            this.edgeAccess.readFlags(edgePointer, intsRef);
            System.out.format(Locale.ROOT, formatEdges, i, this.edgeAccess.getNodeA(edgePointer), this.edgeAccess.getNodeB(edgePointer), this.edgeAccess.getLinkA(edgePointer), this.edgeAccess.getLinkB(edgePointer), intsRef, this.getDist(edgePointer));
        }
        if (this.edgeCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more edges", this.edgeCount - 100);
        }
    }

    void flushAndCloseGeometryAndNameStorage() {
        this.setWayGeometryHeader();
        this.wayGeometry.flush();
        this.wayGeometry.close();
        this.stringIndex.flush();
        this.stringIndex.close();
    }

    public void flush() {
        if (!this.wayGeometry.isClosed()) {
            this.setWayGeometryHeader();
            this.wayGeometry.flush();
        }
        if (!this.stringIndex.isClosed()) {
            this.stringIndex.flush();
        }
        this.setNodesHeader();
        this.setEdgesHeader();
        this.edges.flush();
        this.nodes.flush();
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.flush();
        }
    }

    public void close() {
        if (!this.wayGeometry.isClosed()) {
            this.wayGeometry.close();
        }
        if (!this.stringIndex.isClosed()) {
            this.stringIndex.close();
        }
        this.edges.close();
        this.nodes.close();
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.close();
        }
    }

    long getCapacity() {
        return this.edges.getCapacity() + this.nodes.getCapacity() + this.stringIndex.getCapacity() + this.wayGeometry.getCapacity() + (this.supportsTurnCosts() ? this.turnCostStorage.getCapacity() : 0L);
    }

    long getMaxGeoRef() {
        return this.maxGeoRef;
    }

    void loadExisting(String dim) {
        if (!this.nodes.loadExisting()) {
            throw new IllegalStateException("Cannot load nodes. corrupt file or directory? " + this.dir);
        }
        if (!dim.equalsIgnoreCase("" + this.nodeAccess.getDimension())) {
            throw new IllegalStateException("Configured dimension (" + this.nodeAccess.getDimension() + ") is not equal to dimension of loaded graph (" + dim + ")");
        }
        if (!this.edges.loadExisting()) {
            throw new IllegalStateException("Cannot load edges. corrupt file or directory? " + this.dir);
        }
        if (!this.wayGeometry.loadExisting()) {
            throw new IllegalStateException("Cannot load geometry. corrupt file or directory? " + this.dir);
        }
        if (!this.stringIndex.loadExisting()) {
            throw new IllegalStateException("Cannot load name index. corrupt file or directory? " + this.dir);
        }
        if (this.supportsTurnCosts() && !this.turnCostStorage.loadExisting()) {
            throw new IllegalStateException("Cannot load turn cost storage. corrupt file or directory? " + this.dir);
        }
        this.initStorage();
        this.loadNodesHeader();
        this.loadEdgesHeader();
        this.loadWayGeometryHeader();
    }

    EdgeIteratorState copyProperties(EdgeIteratorState from, EdgeIteratorStateImpl to) {
        long edgePointer = this.edgeAccess.toPointer(to.getEdge());
        this.edgeAccess.writeFlags(edgePointer, from.getFlags());
        to.setDistance(from.getDistance()).setName(from.getName()).setWayGeometry(from.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        return to;
    }

    @Override
    public EdgeIteratorState edge(int nodeA, int nodeB) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot create edge if graph is already frozen");
        }
        this.ensureNodeIndex(Math.max(nodeA, nodeB));
        int edgeId = this.edgeAccess.internalEdgeAdd(this.nextEdgeId(), nodeA, nodeB, true);
        EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this.edgeAccess, this);
        boolean valid = edge.init(edgeId, nodeB);
        assert (valid);
        return edge;
    }

    void setEdgeCount(int cnt) {
        this.edgeCount = cnt;
    }

    protected int nextEdgeId() {
        int nextEdge = this.edgeCount++;
        if (this.edgeCount < 0) {
            throw new IllegalStateException("too many edges. new edge id would be negative. " + this.toString());
        }
        this.edges.ensureCapacity(((long)this.edgeCount + 1L) * (long)this.edgeEntryBytes);
        return nextEdge;
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        if (!this.edgeAccess.isInBounds(edgeId)) {
            throw new IllegalStateException("edgeId " + edgeId + " out of bounds");
        }
        this.checkAdjNodeBounds(adjNode);
        EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this.edgeAccess, this);
        if (edge.init(edgeId, adjNode)) {
            return edge;
        }
        return null;
    }

    final void checkAdjNodeBounds(int adjNode) {
        if (adjNode < 0 && adjNode != Integer.MIN_VALUE || adjNode >= this.nodeCount) {
            throw new IllegalStateException("adjNode " + adjNode + " out of bounds [0," + Helper.nf((long)this.nodeCount) + ")");
        }
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new EdgeIteratorImpl(this, this.edgeAccess, filter);
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return new AllEdgeIterator(this, this.edgeAccess);
    }

    @Override
    public Graph copyTo(Graph g) {
        this.initialized = true;
        if (g.getClass().equals(this.getClass())) {
            this._copyTo((BaseGraph)g);
            return g;
        }
        return GHUtility.copyTo(this, g);
    }

    void _copyTo(BaseGraph clonedG) {
        if (clonedG.edgeEntryBytes != this.edgeEntryBytes) {
            throw new IllegalStateException("edgeEntryBytes cannot be different for cloned graph. Cloned: " + clonedG.edgeEntryBytes + " vs " + this.edgeEntryBytes);
        }
        if (clonedG.nodeEntryBytes != this.nodeEntryBytes) {
            throw new IllegalStateException("nodeEntryBytes cannot be different for cloned graph. Cloned: " + clonedG.nodeEntryBytes + " vs " + this.nodeEntryBytes);
        }
        if (clonedG.nodeAccess.getDimension() != this.nodeAccess.getDimension()) {
            throw new IllegalStateException("dimension cannot be different for cloned graph. Cloned: " + clonedG.nodeAccess.getDimension() + " vs " + this.nodeAccess.getDimension());
        }
        this.setNodesHeader();
        this.nodes.copyTo(clonedG.nodes);
        clonedG.loadNodesHeader();
        this.setEdgesHeader();
        this.edges.copyTo(clonedG.edges);
        clonedG.loadEdgesHeader();
        this.stringIndex.copyTo(clonedG.stringIndex);
        this.setWayGeometryHeader();
        this.wayGeometry.copyTo(clonedG.wayGeometry);
        clonedG.loadWayGeometryHeader();
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.copyTo(clonedG.turnCostStorage);
        }
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.turnCostStorage;
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return weighting;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        long edgePointer = this.edgeAccess.toPointer(edge);
        return this.edgeAccess.getOtherNode(node, edgePointer);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        long edgePointer = this.edgeAccess.toPointer(edge);
        return this.edgeAccess.isAdjacentToNode(node, edgePointer);
    }

    private void setDist(long edgePointer, double distance) {
        this.edges.setInt(edgePointer + (long)this.E_DIST, this.distToInt(distance));
    }

    private int distToInt(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative: " + distance);
        }
        if (distance > MAX_DIST) {
            distance = MAX_DIST;
        }
        int integ = (int)Math.round(distance * 1000.0);
        assert (integ >= 0) : "distance out of range";
        return integ;
    }

    private double getDist(long pointer) {
        int val = this.edges.getInt(pointer + (long)this.E_DIST);
        return (double)val / 1000.0;
    }

    private void setWayGeometry_(PointList pillarNodes, long edgePointer, boolean reverse) {
        if (pillarNodes != null && !pillarNodes.isEmpty()) {
            int count;
            if (pillarNodes.getDimension() != this.nodeAccess.getDimension()) {
                throw new IllegalArgumentException("Cannot use pointlist which is " + pillarNodes.getDimension() + "D for graph which is " + this.nodeAccess.getDimension() + "D");
            }
            long existingGeoRef = Helper.toUnsignedLong((int)this.edges.getInt(edgePointer + (long)this.E_GEO));
            int len = pillarNodes.getSize();
            int dim = this.nodeAccess.getDimension();
            if (existingGeoRef > 0L && len <= (count = this.wayGeometry.getInt(existingGeoRef * 4L))) {
                this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, existingGeoRef);
                return;
            }
            long nextGeoRef = this.nextGeoRef(len * dim);
            this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, nextGeoRef);
        } else {
            this.edges.setInt(edgePointer + (long)this.E_GEO, 0);
        }
    }

    private void setWayGeometryAtGeoRef(PointList pillarNodes, long edgePointer, boolean reverse, long geoRef) {
        int len = pillarNodes.getSize();
        int dim = this.nodeAccess.getDimension();
        long geoRefPosition = geoRef * 4L;
        int totalLen = len * dim * 4 + 4;
        this.ensureGeometry(geoRefPosition, totalLen);
        byte[] wayGeometryBytes = this.createWayGeometryBytes(pillarNodes, reverse);
        this.wayGeometry.setBytes(geoRefPosition, wayGeometryBytes, wayGeometryBytes.length);
        this.edges.setInt(edgePointer + (long)this.E_GEO, Helper.toSignedInt((long)geoRef));
    }

    private byte[] createWayGeometryBytes(PointList pillarNodes, boolean reverse) {
        int len = pillarNodes.getSize();
        int dim = this.nodeAccess.getDimension();
        int totalLen = len * dim * 4 + 4;
        byte[] bytes = new byte[totalLen];
        this.bitUtil.fromInt(bytes, len, 0);
        if (reverse) {
            pillarNodes.reverse();
        }
        int tmpOffset = 4;
        boolean is3D = this.nodeAccess.is3D();
        for (int i = 0; i < len; ++i) {
            double lat = pillarNodes.getLatitude(i);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)lat), tmpOffset);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)pillarNodes.getLongitude(i)), tmpOffset += 4);
            tmpOffset += 4;
            if (!is3D) continue;
            this.bitUtil.fromInt(bytes, Helper.eleToInt((double)pillarNodes.getElevation(i)), tmpOffset);
            tmpOffset += 4;
        }
        return bytes;
    }

    private PointList fetchWayGeometry_(long edgePointer, boolean reverse, FetchMode mode, int baseNode, int adjNode) {
        if (mode == FetchMode.TOWER_ONLY) {
            PointList pillarNodes = new PointList(2, this.nodeAccess.is3D());
            pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
            pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
            return pillarNodes;
        }
        long geoRef = Helper.toUnsignedLong((int)this.edges.getInt(edgePointer + (long)this.E_GEO));
        int count = 0;
        byte[] bytes = null;
        if (geoRef > 0L) {
            count = this.wayGeometry.getInt(geoRef *= 4L);
            bytes = new byte[count * this.nodeAccess.getDimension() * 4];
            this.wayGeometry.getBytes(geoRef += 4L, bytes, bytes.length);
        } else if (mode == FetchMode.PILLAR_ONLY) {
            return PointList.EMPTY;
        }
        PointList pillarNodes = new PointList(BaseGraph.getPointListLength(count, mode), this.nodeAccess.is3D());
        if (reverse) {
            if (mode == FetchMode.ALL || mode == FetchMode.PILLAR_AND_ADJ) {
                pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
            }
        } else if (mode == FetchMode.ALL || mode == FetchMode.BASE_AND_PILLAR) {
            pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
        }
        int index = 0;
        for (int i = 0; i < count; ++i) {
            double lat = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index));
            double lon = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index += 4));
            index += 4;
            if (this.nodeAccess.is3D()) {
                pillarNodes.add(lat, lon, Helper.intToEle((int)this.bitUtil.toInt(bytes, index)));
                index += 4;
                continue;
            }
            pillarNodes.add(lat, lon);
        }
        if (reverse) {
            if (mode == FetchMode.ALL || mode == FetchMode.BASE_AND_PILLAR) {
                pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
            }
            pillarNodes.reverse();
        } else if (mode == FetchMode.ALL || mode == FetchMode.PILLAR_AND_ADJ) {
            pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
        }
        return pillarNodes;
    }

    static int getPointListLength(int pillarNodes, FetchMode mode) {
        switch (mode) {
            case TOWER_ONLY: {
                return 2;
            }
            case PILLAR_ONLY: {
                return pillarNodes;
            }
            case BASE_AND_PILLAR: 
            case PILLAR_AND_ADJ: {
                return pillarNodes + 1;
            }
            case ALL: {
                return pillarNodes + 2;
            }
        }
        throw new IllegalArgumentException("Mode isn't handled " + (Object)((Object)mode));
    }

    private void setName(long edgePointer, String name) {
        int stringIndexRef = (int)this.stringIndex.add(Collections.singletonMap(STRING_IDX_NAME_KEY, name));
        if (stringIndexRef < 0) {
            throw new IllegalStateException("Too many names are stored, currently limited to int pointer");
        }
        this.edges.setInt(edgePointer + (long)this.E_NAME, stringIndexRef);
    }

    private void ensureGeometry(long bytePos, int byteLength) {
        this.wayGeometry.ensureCapacity(bytePos + (long)byteLength);
    }

    private long nextGeoRef(int arrayLength) {
        long tmp = this.maxGeoRef;
        this.maxGeoRef += (long)arrayLength + 1L;
        if (this.maxGeoRef >= 0xFFFFFFFFL) {
            throw new IllegalStateException("Geometry too large, does not fit in 32 bits " + this.maxGeoRef);
        }
        return tmp;
    }

    static class EdgeIteratorStateImpl
    implements EdgeIteratorState {
        final BaseGraph baseGraph;
        long edgePointer = -1L;
        int baseNode;
        int adjNode;
        EdgeAccess edgeAccess;
        boolean reverse = false;
        boolean freshFlags;
        int edgeId = -1;
        private final IntsRef edgeFlags;

        public EdgeIteratorStateImpl(EdgeAccess edgeAccess, BaseGraph baseGraph) {
            this.edgeAccess = edgeAccess;
            this.baseGraph = baseGraph;
            this.edgeFlags = new IntsRef(baseGraph.intsForFlags);
        }

        final boolean init(int edgeId, int expectedAdjNode) {
            if (!EdgeIterator.Edge.isValid(edgeId)) {
                throw new IllegalArgumentException("fetching the edge requires a valid edgeId but was " + edgeId);
            }
            this.edgeId = edgeId;
            this.edgePointer = this.edgeAccess.toPointer(edgeId);
            this.baseNode = this.edgeAccess.getNodeA(this.edgePointer);
            this.adjNode = this.edgeAccess.getNodeB(this.edgePointer);
            this.freshFlags = false;
            if (expectedAdjNode == this.adjNode || expectedAdjNode == Integer.MIN_VALUE) {
                this.reverse = false;
                return true;
            }
            if (expectedAdjNode == this.baseNode) {
                this.reverse = true;
                this.baseNode = this.adjNode;
                this.adjNode = expectedAdjNode;
                return true;
            }
            return false;
        }

        @Override
        public final int getBaseNode() {
            return this.baseNode;
        }

        @Override
        public final int getAdjNode() {
            return this.adjNode;
        }

        @Override
        public double getDistance() {
            return this.baseGraph.getDist(this.edgePointer);
        }

        @Override
        public EdgeIteratorState setDistance(double dist) {
            this.baseGraph.setDist(this.edgePointer, dist);
            return this;
        }

        @Override
        public IntsRef getFlags() {
            if (!this.freshFlags) {
                this.edgeAccess.readFlags(this.edgePointer, this.edgeFlags);
                this.freshFlags = true;
            }
            return this.edgeFlags;
        }

        @Override
        public final EdgeIteratorState setFlags(IntsRef edgeFlags) {
            assert (this.edgeId < this.baseGraph.edgeCount) : "must be edge but was shortcut: " + this.edgeId + " >= " + this.baseGraph.edgeCount + ". Use setFlagsAndWeight";
            this.edgeAccess.writeFlags(this.edgePointer, edgeFlags);
            for (int i = 0; i < edgeFlags.ints.length; ++i) {
                this.edgeFlags.ints[i] = edgeFlags.ints[i];
            }
            this.freshFlags = true;
            return this;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            return property.getBool(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            property.setBool(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            return property.getBool(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            property.setBool(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public int get(IntEncodedValue property) {
            return property.getInt(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            property.setInt(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            return property.getInt(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            property.setInt(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public double get(DecimalEncodedValue property) {
            return property.getDecimal(this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            property.setDecimal(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            return property.getDecimal(!this.reverse, this.getFlags());
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            property.setDecimal(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public <T extends Enum> T get(EnumEncodedValue<T> property) {
            return property.getEnum(this.reverse, this.getFlags());
        }

        @Override
        public <T extends Enum> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            property.setEnum(this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public <T extends Enum> T getReverse(EnumEncodedValue<T> property) {
            return property.getEnum(!this.reverse, this.getFlags());
        }

        @Override
        public <T extends Enum> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            property.setEnum(!this.reverse, this.getFlags(), value);
            this.edgeAccess.writeFlags(this.edgePointer, this.getFlags());
            return this;
        }

        @Override
        public final EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
            return this.baseGraph.copyProperties(edge, this);
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList pillarNodes) {
            this.baseGraph.setWayGeometry_(pillarNodes, this.edgePointer, this.reverse);
            return this;
        }

        @Override
        public PointList fetchWayGeometry(FetchMode mode) {
            return this.baseGraph.fetchWayGeometry_(this.edgePointer, this.reverse, mode, this.getBaseNode(), this.getAdjNode());
        }

        @Override
        public int getEdge() {
            return this.edgeId;
        }

        @Override
        public int getOrigEdgeFirst() {
            return this.getEdge();
        }

        @Override
        public int getOrigEdgeLast() {
            return this.getEdge();
        }

        @Override
        public String getName() {
            int stringIndexRef = this.baseGraph.edges.getInt(this.edgePointer + (long)this.baseGraph.E_NAME);
            String name = this.baseGraph.stringIndex.get(stringIndexRef, BaseGraph.STRING_IDX_NAME_KEY);
            return name == null ? "" : name;
        }

        @Override
        public EdgeIteratorState setName(String name) {
            this.baseGraph.setName(this.edgePointer, name);
            return this;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            if (!EdgeIterator.Edge.isValid(this.edgeId)) {
                throw new IllegalStateException("call setEdgeId before detaching (edgeId:" + this.edgeId + ")");
            }
            EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this.edgeAccess, this.baseGraph);
            boolean valid = edge.init(this.edgeId, reverseArg ? this.baseNode : this.adjNode);
            assert (valid);
            if (reverseArg) {
                edge.reverse = !this.reverse;
            }
            return edge;
        }

        public final String toString() {
            return this.getEdge() + " " + this.getBaseNode() + "-" + this.getAdjNode();
        }
    }

    protected static class AllEdgeIterator
    extends EdgeIteratorStateImpl
    implements AllEdgesIterator {
        public AllEdgeIterator(BaseGraph baseGraph) {
            this(baseGraph, baseGraph.edgeAccess);
        }

        private AllEdgeIterator(BaseGraph baseGraph, EdgeAccess edgeAccess) {
            super(edgeAccess, baseGraph);
        }

        @Override
        public int length() {
            return this.baseGraph.edgeCount;
        }

        @Override
        public boolean next() {
            ++this.edgeId;
            if (this.edgeId >= this.baseGraph.edgeCount) {
                return false;
            }
            this.edgePointer = this.edgeAccess.toPointer(this.edgeId);
            this.adjNode = this.edgeAccess.getNodeB(this.edgePointer);
            this.baseNode = this.edgeAccess.getNodeA(this.edgePointer);
            this.freshFlags = false;
            this.reverse = false;
            return true;
        }

        @Override
        public final EdgeIteratorState detach(boolean reverseArg) {
            if (this.edgePointer < 0L) {
                throw new IllegalStateException("call next before detaching");
            }
            AllEdgeIterator iter = new AllEdgeIterator(this.baseGraph, this.edgeAccess);
            iter.edgeId = this.edgeId;
            iter.edgePointer = this.edgePointer;
            if (reverseArg) {
                iter.reverse = !this.reverse;
                iter.baseNode = this.adjNode;
                iter.adjNode = this.baseNode;
            } else {
                iter.reverse = this.reverse;
                iter.baseNode = this.baseNode;
                iter.adjNode = this.adjNode;
            }
            return iter;
        }
    }

    protected static class EdgeIteratorImpl
    extends EdgeIteratorStateImpl
    implements EdgeExplorer,
    EdgeIterator {
        final EdgeFilter filter;
        int nextEdgeId;

        public EdgeIteratorImpl(BaseGraph baseGraph, EdgeAccess edgeAccess, EdgeFilter filter) {
            super(edgeAccess, baseGraph);
            if (filter == null) {
                throw new IllegalArgumentException("Instead null filter use EdgeFilter.ALL_EDGES");
            }
            this.filter = filter;
        }

        final void setEdgeId(int edgeId) {
            this.nextEdgeId = this.edgeId = edgeId;
        }

        final void _setBaseNode(int baseNode) {
            this.baseNode = baseNode;
        }

        @Override
        public EdgeIterator setBaseNode(int baseNode) {
            this.setEdgeId(this.baseGraph.edgeAccess.getEdgeRef(baseNode));
            this._setBaseNode(baseNode);
            return this;
        }

        @Override
        public final boolean next() {
            do {
                if (!EdgeIterator.Edge.isValid(this.nextEdgeId)) {
                    return false;
                }
                this.goToNext();
            } while (!this.filter.accept(this));
            return true;
        }

        void goToNext() {
            this.edgePointer = this.edgeAccess.toPointer(this.nextEdgeId);
            this.edgeId = this.nextEdgeId;
            int nodeA = this.edgeAccess.getNodeA(this.edgePointer);
            boolean baseNodeIsNodeA = this.baseNode == nodeA;
            this.adjNode = baseNodeIsNodeA ? this.edgeAccess.getNodeB(this.edgePointer) : nodeA;
            this.reverse = !baseNodeIsNodeA;
            this.freshFlags = false;
            int n = this.nextEdgeId = baseNodeIsNodeA ? this.edgeAccess.getLinkA(this.edgePointer) : this.edgeAccess.getLinkB(this.edgePointer);
            assert (this.nextEdgeId != this.edgeId) : "endless loop detected for base node: " + this.baseNode + ", adj node: " + this.adjNode + ", edge pointer: " + this.edgePointer + ", edge: " + this.edgeId;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            if (this.edgeId == this.nextEdgeId) {
                throw new IllegalStateException("call next before detaching (edgeId:" + this.edgeId + " vs. next " + this.nextEdgeId + ")");
            }
            return super.detach(reverseArg);
        }
    }
}

