/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class FastestWeighting
extends AbstractWeighting {
    protected static final double SPEED_CONV = 3.6;
    private final double headingPenalty;
    private final long headingPenaltyMillis;
    private final double maxSpeed;
    private final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final double destinationPenalty;
    private final double privatePenalty;

    public FastestWeighting(FlagEncoder encoder) {
        this(encoder, new PMap(0));
    }

    public FastestWeighting(FlagEncoder encoder, TurnCostProvider turnCostProvider) {
        this(encoder, new PMap(0), turnCostProvider);
    }

    public FastestWeighting(FlagEncoder encoder, PMap map) {
        this(encoder, map, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    public FastestWeighting(FlagEncoder encoder, PMap map, TurnCostProvider turnCostProvider) {
        super(encoder, turnCostProvider);
        this.headingPenalty = map.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(this.headingPenalty * 1000.0);
        this.maxSpeed = encoder.getMaxSpeed() / 3.6;
        if (!encoder.hasEncodedValue("road_access")) {
            throw new IllegalArgumentException("road_access is not available but expected for FastestWeighting");
        }
        double defaultDestinationFactor = encoder.getTransportationMode() == TransportationMode.MOTOR_VEHICLE ? 10.0 : 1.0;
        this.destinationPenalty = FastestWeighting.checkBounds("road_access_destination_factor", map.getDouble("road_access_destination_factor", defaultDestinationFactor), 1.0, 10.0);
        double defaultPrivateFactor = encoder.getTransportationMode() == TransportationMode.MOTOR_VEHICLE ? 10.0 : 1.2;
        this.privatePenalty = FastestWeighting.checkBounds("road_access_private_factor", map.getDouble("road_access_private_factor", defaultPrivateFactor), 1.0, 10.0);
        this.roadAccessEnc = this.destinationPenalty > 1.0 || this.privatePenalty > 1.0 ? encoder.getEnumEncodedValue("road_access", RoadAccess.class) : null;
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        boolean unfavoredEdge;
        double speed;
        double d = speed = reverse ? edgeState.getReverse(this.avSpeedEnc) : edgeState.get(this.avSpeedEnc);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double time = edgeState.getDistance() / speed * 3.6;
        if (this.roadAccessEnc != null) {
            RoadAccess access = edgeState.get(this.roadAccessEnc);
            if (access == RoadAccess.DESTINATION) {
                time *= this.destinationPenalty;
            } else if (access == RoadAccess.PRIVATE) {
                time *= this.privatePenalty;
            }
        }
        if (unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE)) {
            time += this.headingPenalty;
        }
        return time;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        long time = 0L;
        boolean unfavoredEdge = edgeState.get(EdgeIteratorState.UNFAVORED_EDGE);
        if (unfavoredEdge) {
            time += this.headingPenaltyMillis;
        }
        return time + super.calcEdgeMillis(edgeState, reverse);
    }

    static double checkBounds(String key, double val, double from, double to) {
        if (val < from || val > to) {
            throw new IllegalArgumentException(key + " has invalid range should be within [" + from + ", " + to + "]");
        }
        return val;
    }

    @Override
    public String getName() {
        return "fastest";
    }
}

