/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.weighting.AbstractAdjustedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;

public class AvoidEdgesWeighting
extends AbstractAdjustedWeighting {
    protected IntSet avoidedEdges = new GHIntHashSet();
    private double edgePenaltyFactor = 5.0;

    public AvoidEdgesWeighting(Weighting superWeighting) {
        super(superWeighting);
    }

    public AvoidEdgesWeighting setEdgePenaltyFactor(double edgePenaltyFactor) {
        this.edgePenaltyFactor = edgePenaltyFactor;
        return this;
    }

    public void setAvoidedEdges(IntSet avoidedEdges) {
        this.avoidedEdges = avoidedEdges;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double weight = this.superWeighting.calcEdgeWeight(edgeState, reverse);
        if (this.avoidedEdges.contains(edgeState.getEdge())) {
            return weight * this.edgePenaltyFactor;
        }
        return weight;
    }

    @Override
    public String getName() {
        return "avoid_edges";
    }
}

