/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.MaxWidth;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMMaxWidthParser
implements TagParser {
    private final DecimalEncodedValue widthEncoder;

    public OSMMaxWidthParser() {
        this(MaxWidth.create());
    }

    public OSMMaxWidthParser(DecimalEncodedValue widthEncoder) {
        this.widthEncoder = widthEncoder;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.widthEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        List<String> widthTags = Arrays.asList("maxwidth", "maxwidth:physical", "width");
        OSMValueExtractor.extractMeter(edgeFlags, way, this.widthEncoder, widthTags);
        return edgeFlags;
    }
}

