/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.MaxHeight;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMMaxHeightParser
implements TagParser {
    private final DecimalEncodedValue heightEncoder;

    public OSMMaxHeightParser() {
        this(MaxHeight.create());
    }

    public OSMMaxHeightParser(DecimalEncodedValue heightEncoder) {
        this.heightEncoder = heightEncoder;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.heightEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        List<String> heightTags = Arrays.asList("maxheight", "maxheight:physical");
        OSMValueExtractor.extractMeter(edgeFlags, way, this.heightEncoder, heightTags);
        return edgeFlags;
    }
}

