/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.json.geo.JsonFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CustomModel {
    public static final String KEY = "custom_model";
    static double DEFAULT_D_I = 70.0;
    private Double maxSpeedFallback;
    private Double headingPenalty = 300.0;
    private double distanceInfluence = DEFAULT_D_I;
    private Map<String, Object> speedFactorMap = new HashMap<String, Object>();
    private Map<String, Object> maxSpeedMap = new HashMap<String, Object>();
    private Map<String, Object> priorityMap = new HashMap<String, Object>();
    private Map<String, JsonFeature> areas = new HashMap<String, JsonFeature>();

    public CustomModel() {
    }

    public CustomModel(CustomModel toCopy) {
        this.maxSpeedFallback = toCopy.maxSpeedFallback;
        this.headingPenalty = toCopy.headingPenalty;
        this.distanceInfluence = toCopy.distanceInfluence;
        this.speedFactorMap = this.deepCopy(toCopy.getSpeedFactor());
        this.maxSpeedMap = this.deepCopy(toCopy.getMaxSpeed());
        this.priorityMap = this.deepCopy(toCopy.getPriority());
        this.areas.putAll(toCopy.getAreas());
    }

    private <T> T deepCopy(T originalObject) {
        if (originalObject instanceof List) {
            ArrayList newList = new ArrayList(((List)originalObject).size());
            for (Object item : (List)originalObject) {
                newList.add(this.deepCopy(item));
            }
            return (T)newList;
        }
        if (originalObject instanceof Map) {
            HashMap copy = new HashMap(((Map)originalObject).size());
            Iterator iterator = ((Map)originalObject).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                copy.put(entry.getKey(), this.deepCopy(entry.getValue()));
            }
            return (T)copy;
        }
        return originalObject;
    }

    public Map<String, Object> getSpeedFactor() {
        return this.speedFactorMap;
    }

    public Map<String, Object> getMaxSpeed() {
        return this.maxSpeedMap;
    }

    public CustomModel setMaxSpeedFallback(Double maxSpeedFallback) {
        this.maxSpeedFallback = maxSpeedFallback;
        return this;
    }

    public Double getMaxSpeedFallback() {
        return this.maxSpeedFallback;
    }

    public Map<String, Object> getPriority() {
        return this.priorityMap;
    }

    public CustomModel setAreas(Map<String, JsonFeature> areas) {
        this.areas = areas;
        return this;
    }

    public Map<String, JsonFeature> getAreas() {
        return this.areas;
    }

    public CustomModel setDistanceInfluence(double distanceFactor) {
        this.distanceInfluence = distanceFactor;
        return this;
    }

    public double getDistanceInfluence() {
        return this.distanceInfluence;
    }

    public void setHeadingPenalty(double headingPenalty) {
        this.headingPenalty = headingPenalty;
    }

    public double getHeadingPenalty() {
        return this.headingPenalty;
    }

    public String toString() {
        return this.createContentString();
    }

    private String createContentString() {
        return "distanceInfluence=" + this.distanceInfluence + "|speedFactor=" + this.speedFactorMap + "|maxSpeed=" + this.maxSpeedMap + "|maxSpeedFallback=" + this.maxSpeedFallback + "|priorityMap=" + this.priorityMap + "|areas=" + this.areas;
    }

    public static CustomModel merge(CustomModel baseModel, CustomModel queryModel) {
        Object value;
        CustomModel mergedCM = new CustomModel(baseModel);
        if (queryModel.maxSpeedFallback != null) {
            if (mergedCM.maxSpeedFallback != null && mergedCM.maxSpeedFallback > queryModel.maxSpeedFallback) {
                throw new IllegalArgumentException("CustomModel in query can only use max_speed_fallback bigger or equal to " + mergedCM.maxSpeedFallback);
            }
            mergedCM.maxSpeedFallback = queryModel.maxSpeedFallback;
        }
        if (Math.abs(queryModel.distanceInfluence - DEFAULT_D_I) > 0.01) {
            if (mergedCM.distanceInfluence > queryModel.distanceInfluence) {
                throw new IllegalArgumentException("CustomModel in query can only use distance_influence bigger or equal to " + mergedCM.distanceInfluence);
            }
            mergedCM.distanceInfluence = queryModel.distanceInfluence;
        }
        for (Map.Entry<String, Object> entry : queryModel.getMaxSpeed().entrySet()) {
            value = mergedCM.maxSpeedMap.get(entry.getKey());
            CustomModel.applyChange(mergedCM.maxSpeedMap, value, entry);
        }
        for (Map.Entry<String, Object> entry : queryModel.getSpeedFactor().entrySet()) {
            value = mergedCM.speedFactorMap.get(entry.getKey());
            CustomModel.applyChange(mergedCM.speedFactorMap, value, entry);
        }
        for (Map.Entry<String, Object> entry : queryModel.getPriority().entrySet()) {
            value = mergedCM.priorityMap.get(entry.getKey());
            CustomModel.applyChange(mergedCM.priorityMap, value, entry);
        }
        for (Map.Entry<String, Object> entry : queryModel.getAreas().entrySet()) {
            if (mergedCM.areas.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("area " + entry.getKey() + " already exists");
            }
            mergedCM.areas.put(entry.getKey(), (JsonFeature)entry.getValue());
        }
        return mergedCM;
    }

    private static void applyChange(Map<String, Object> mergedSuperMap, Object mergedObj, Map.Entry<String, Object> querySuperEntry) {
        if (mergedObj == null) {
            mergedSuperMap.put(querySuperEntry.getKey(), querySuperEntry.getValue());
            return;
        }
        if (!(mergedObj instanceof Map)) {
            throw new IllegalArgumentException(querySuperEntry.getKey() + ": entry is not a map: " + mergedObj);
        }
        Object queryObj = querySuperEntry.getValue();
        if (!(queryObj instanceof Map)) {
            throw new IllegalArgumentException(querySuperEntry.getKey() + ": query entry is not a map: " + queryObj);
        }
        Map mergedMap = (Map)mergedObj;
        Map queryMap = (Map)queryObj;
        for (Map.Entry queryEntry : queryMap.entrySet()) {
            if (queryEntry.getKey() == null || queryEntry.getKey().toString().isEmpty()) {
                throw new IllegalArgumentException(querySuperEntry.getKey() + ": key cannot be null or empty");
            }
            String key = queryEntry.getKey().toString();
            if (CustomModel.isComparison(key)) continue;
            Object mergedValue = mergedMap.get(key);
            if (mergedValue == null) {
                mergedMap.put(key, queryEntry.getValue());
                continue;
            }
            if (CustomModel.multiply(queryEntry.getValue(), mergedValue) != null) {
                mergedMap.put(key, CustomModel.multiply(queryEntry.getValue(), mergedValue));
                continue;
            }
            throw new IllegalArgumentException(querySuperEntry.getKey() + ": cannot merge value " + queryEntry.getValue() + " for key " + key + ", merged value: " + mergedValue);
        }
        List<String> queryComparisonKeys = CustomModel.getComparisonKeys(queryMap);
        if (queryComparisonKeys.isEmpty()) {
            return;
        }
        if (queryComparisonKeys.size() > 1) {
            throw new IllegalArgumentException(querySuperEntry.getKey() + ": entry in " + querySuperEntry.getValue() + " must not contain more than one key comparison but contained " + queryComparisonKeys);
        }
        char opChar = queryComparisonKeys.get(0).charAt(0);
        List<String> mergedComparisonKeys = CustomModel.getComparisonKeys(mergedMap);
        if (mergedComparisonKeys.isEmpty()) {
            mergedMap.put(queryComparisonKeys.get(0), queryMap.get(queryComparisonKeys.get(0)));
        } else if (mergedComparisonKeys.get(0).charAt(0) == opChar) {
            if (CustomModel.multiply(queryMap.get(queryComparisonKeys.get(0)), mergedMap.get(mergedComparisonKeys.get(0))) != 0.0) {
                throw new IllegalArgumentException(querySuperEntry.getKey() + ": currently only blocking comparisons are allowed, but query was " + queryMap.get(queryComparisonKeys.get(0)) + " and server side: " + mergedMap.get(mergedComparisonKeys.get(0)));
            }
            try {
                double comparisonMergedValue = Double.parseDouble(mergedComparisonKeys.get(0).substring(1));
                double comparisonQueryValue = Double.parseDouble(queryComparisonKeys.get(0).substring(1));
                if (opChar == '<') {
                    if (comparisonMergedValue > comparisonQueryValue) {
                        throw new IllegalArgumentException(querySuperEntry.getKey() + ": only use a comparison key with a bigger value than " + comparisonMergedValue + " but was " + comparisonQueryValue);
                    }
                } else if (opChar == '>') {
                    if (comparisonMergedValue < comparisonQueryValue) {
                        throw new IllegalArgumentException(querySuperEntry.getKey() + ": only use a comparison key with a smaller value than " + comparisonMergedValue + " but was " + comparisonQueryValue);
                    }
                } else {
                    throw new IllegalArgumentException(querySuperEntry.getKey() + ": only use a comparison key with < or > as operator but was " + opChar);
                }
                mergedMap.remove(mergedComparisonKeys.get(0));
                mergedMap.put(queryComparisonKeys.get(0), queryMap.get(queryComparisonKeys.get(0)));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(querySuperEntry.getKey() + ": number in one of the 'comparison' keys for " + querySuperEntry.getKey() + " wasn't parsable: " + queryComparisonKeys + " (" + mergedComparisonKeys + ")");
            }
        } else {
            throw new IllegalArgumentException(querySuperEntry.getKey() + ": comparison keys must match but did not: " + queryComparisonKeys.get(0) + " vs " + mergedComparisonKeys.get(0));
        }
    }

    static Double multiply(Object queryValue, Object mergedValue) {
        if (queryValue instanceof Number && mergedValue instanceof Number) {
            return ((Number)queryValue).doubleValue() * ((Number)mergedValue).doubleValue();
        }
        return null;
    }

    static boolean isComparison(String key) {
        return key.startsWith("<") || key.startsWith(">");
    }

    private static List<String> getComparisonKeys(Map<Object, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Object, Object> queryEntry : map.entrySet()) {
            String key = queryEntry.getKey().toString();
            if (!CustomModel.isComparison(key)) continue;
            list.add(key);
        }
        return list;
    }
}

