/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import java.util.Arrays;

public class NodeBasedWitnessPathSearcher {
    private static final int NOT_FOUND = -1;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private final IntArrayList changedNodes;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    protected double[] weights;
    private IntFloatBinaryHeap heap;
    private int ignoreNode = -1;
    private int visitedNodes;
    private boolean doClear = true;
    private int currNode;
    private int to;
    private double weightLimit = Double.MAX_VALUE;

    public NodeBasedWitnessPathSearcher(CHPreparationGraph graph) {
        this.outEdgeExplorer = graph.createOutEdgeExplorer();
        this.weights = new double[graph.getNodes()];
        Arrays.fill(this.weights, Double.MAX_VALUE);
        this.heap = new IntFloatBinaryHeap(1000);
        this.changedNodes = new IntArrayList();
    }

    public NodeBasedWitnessPathSearcher clear() {
        this.doClear = true;
        return this;
    }

    public double getWeight(int endNode) {
        return this.weights[endNode];
    }

    public int findEndNode(int from, int to) {
        if (this.weights.length < 2) {
            return -1;
        }
        this.to = to;
        if (this.doClear) {
            this.doClear = false;
            int vn = this.changedNodes.size();
            for (int i = 0; i < vn; ++i) {
                int n = this.changedNodes.get(i);
                this.weights[n] = Double.MAX_VALUE;
            }
            this.heap.clear();
            this.changedNodes.elementsCount = 0;
            this.currNode = from;
            this.weights[this.currNode] = 0.0;
            this.changedNodes.add(this.currNode);
        } else {
            if (this.weights[to] != Double.MAX_VALUE && this.weights[to] <= this.weights[this.currNode]) {
                return to;
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded()) {
                return -1;
            }
            this.currNode = this.heap.poll();
        }
        this.visitedNodes = 0;
        if (this.finished()) {
            if (this.heap.isEmpty()) {
                this.doClear = true;
            }
            return this.currNode;
        }
        while (true) {
            ++this.visitedNodes;
            PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(this.currNode);
            while (iter.next()) {
                double tmpWeight;
                int adjNode = iter.getAdjNode();
                if (!this.accept(iter) || Double.isInfinite(tmpWeight = iter.getWeight() + this.weights[this.currNode])) continue;
                double w = this.weights[adjNode];
                if (w == Double.MAX_VALUE) {
                    this.weights[adjNode] = tmpWeight;
                    this.heap.insert(tmpWeight, adjNode);
                    this.changedNodes.add(adjNode);
                    continue;
                }
                if (!(w > tmpWeight)) continue;
                this.weights[adjNode] = tmpWeight;
                this.heap.update(tmpWeight, adjNode);
                this.changedNodes.add(adjNode);
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded() || this.isWeightLimitExceeded()) {
                return -1;
            }
            this.currNode = this.heap.peekElement();
            if (this.finished()) {
                return this.currNode;
            }
            this.heap.poll();
        }
    }

    public boolean finished() {
        return this.currNode == this.to;
    }

    public void setWeightLimit(double weightLimit) {
        this.weightLimit = weightLimit;
    }

    protected boolean isWeightLimitExceeded() {
        return this.weights[this.currNode] > this.weightLimit;
    }

    public void close() {
        this.outEdgeExplorer = null;
        this.changedNodes.release();
        this.weights = null;
        this.heap = null;
    }

    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public String getMemoryUsageAsString() {
        long len = this.weights.length;
        return (16L * len + (long)this.changedNodes.buffer.length * 4L + this.heap.getCapacity() * 8L) / 0x100000L + "MB";
    }

    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    public void ignoreNode(int node) {
        this.ignoreNode = node;
    }

    private boolean accept(PrepareGraphEdgeIterator iter) {
        return this.ignoreNode < 0 || iter.getAdjNode() != this.ignoreNode;
    }

    private boolean isMaxVisitedNodesExceeded() {
        return this.maxVisitedNodes < this.getVisitedNodes();
    }
}

