/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProfileResolver {
    private final EncodingManager encodingManager;
    private final List<Profile> profiles;
    private final List<Profile> chProfiles;
    private final List<Profile> lmProfiles;

    public ProfileResolver(EncodingManager encodingManager, List<Profile> profiles, List<CHProfile> chProfiles, List<LMProfile> lmProfiles) {
        Profile profile;
        this.encodingManager = encodingManager;
        this.profiles = profiles;
        HashMap<String, Profile> profilesByName = new HashMap<String, Profile>(profiles.size());
        for (Profile profile2 : profiles) {
            profilesByName.put(profile2.getName(), profile2);
        }
        if (profilesByName.size() != profiles.size()) {
            throw new IllegalStateException("Profiles must have distinct names");
        }
        this.chProfiles = new ArrayList<Profile>();
        for (CHProfile cHProfile : chProfiles) {
            profile = (Profile)profilesByName.get(cHProfile.getProfile());
            if (profile == null) {
                throw new IllegalStateException("There is no profile for CH preparation '" + cHProfile.getProfile() + "'");
            }
            this.chProfiles.add(profile);
        }
        this.lmProfiles = new ArrayList<Profile>();
        for (LMProfile lMProfile : lmProfiles) {
            profile = (Profile)profilesByName.get(lMProfile.getProfile());
            if (profile == null) {
                throw new IllegalStateException("There is no profile for LM preparation '" + lMProfile.getProfile() + "'");
            }
            this.lmProfiles.add(profile);
        }
    }

    public Profile resolveProfile(PMap hints) {
        boolean disableCH = hints.getBool("ch.disable", false);
        boolean disableLM = hints.getBool("lm.disable", false);
        String vehicle = hints.getString("vehicle", "").toLowerCase();
        if (!vehicle.isEmpty() && !this.encodingManager.hasEncoder(vehicle)) {
            throw new IllegalArgumentException("Vehicle not supported: `" + vehicle + "`. Supported are: `" + this.encodingManager.toString() + "`\nYou should consider using the `profile` parameter instead of specifying a vehicle.\nAvailable profiles: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
        }
        if (!this.chProfiles.isEmpty() && !disableCH) {
            return this.selectProfileCH(hints);
        }
        if (!this.lmProfiles.isEmpty() && !disableLM) {
            return this.selectProfileLM(hints);
        }
        return this.selectProfileUnprepared(hints);
    }

    public Profile selectProfileCH(PMap hintsMap) {
        ArrayList<Profile> matchingProfiles = new ArrayList<Profile>();
        for (Profile p : this.chProfiles) {
            if (!this.chProfileMatchesHints(p, hintsMap)) continue;
            matchingProfiles.add(p);
        }
        Boolean edgeBased = this.getEdgeBased(hintsMap);
        Integer uTurnCosts = this.getUTurnCosts(hintsMap);
        if (matchingProfiles.isEmpty()) {
            throw new IllegalArgumentException("Cannot find matching profile that supports CH for your request. Please check your parameters.\nYou can try disabling CH using ch.disable=true\nrequested:  " + this.getCHRequestAsString(hintsMap, edgeBased, uTurnCosts) + "\navailable: " + this.chProfilesAsString(this.chProfiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
        }
        if (matchingProfiles.size() == 1) {
            return (Profile)matchingProfiles.get(0);
        }
        Profile match1 = (Profile)matchingProfiles.get(0);
        Profile match2 = (Profile)matchingProfiles.get(1);
        if (edgeBased == null && matchingProfiles.size() == 2 && match1.getWeighting().equals(match2.getWeighting()) && match1.getVehicle().equals(match2.getVehicle()) && match1.isTurnCosts() != match2.isTurnCosts()) {
            return match1.isTurnCosts() ? match1 : match2;
        }
        throw new IllegalArgumentException("There are multiple CH profiles matching your request. Use the `weighting`,`vehicle`,`turn_costs` and/or `u_turn_costs` parameters to be more specific.\nYou can also try disabling CH altogether using ch.disable=true\nrequested:  " + this.getCHRequestAsString(hintsMap, edgeBased, uTurnCosts) + "\nmatched:   " + this.chProfilesAsString(matchingProfiles) + "\navailable: " + this.chProfilesAsString(this.chProfiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
    }

    protected boolean chProfileMatchesHints(Profile p, PMap hintsMap) {
        Boolean edgeBased = this.getEdgeBased(hintsMap);
        Integer uTurnCosts = this.getUTurnCosts(hintsMap);
        return !(edgeBased != null && p.isTurnCosts() != edgeBased.booleanValue() || uTurnCosts != null && !uTurnCosts.equals(this.getUTurnCosts(p.getHints())) || hintsMap.has("weighting") && !p.getWeighting().equalsIgnoreCase(hintsMap.getString("weighting", "")) || hintsMap.has("vehicle") && !p.getVehicle().equalsIgnoreCase(hintsMap.getString("vehicle", "")));
    }

    public Profile selectProfileLM(PMap hintsMap) {
        ArrayList<Profile> matchingProfiles = new ArrayList<Profile>();
        for (Profile p : this.lmProfiles) {
            if (!this.lmProfileMatchesHints(p, hintsMap)) continue;
            matchingProfiles.add(p);
        }
        if (matchingProfiles.isEmpty()) {
            throw new IllegalArgumentException("Cannot find matching LM profile for your request. Please check your parameters.\nYou can try disabling LM by setting lm.disable=true\nrequested:  " + this.getRequestAsString(hintsMap) + "\navailable: " + this.profilesAsString(this.lmProfiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
        }
        if (matchingProfiles.size() == 1) {
            return (Profile)matchingProfiles.get(0);
        }
        Profile match1 = (Profile)matchingProfiles.get(0);
        Profile match2 = (Profile)matchingProfiles.get(1);
        Boolean edgeBased = this.getEdgeBased(hintsMap);
        if (edgeBased == null && matchingProfiles.size() == 2 && match1.getWeighting().equals(match2.getWeighting()) && match1.getVehicle().equals(match2.getVehicle()) && match1.isTurnCosts() != match2.isTurnCosts()) {
            return match1.isTurnCosts() ? match1 : match2;
        }
        throw new IllegalArgumentException("There are multiple LM profiles matching your request. Use the `weighting`, `vehicle` and `turn_costs` parameters to be more specific.\nYou can also try disabling LM altogether using lm.disable=true\nrequested:  " + this.getRequestAsString(hintsMap) + "\nmatched:   " + this.profilesAsString(matchingProfiles) + "\navailable: " + this.profilesAsString(this.lmProfiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
    }

    protected boolean lmProfileMatchesHints(Profile p, PMap hints) {
        return this.profileMatchesHints(p, hints);
    }

    private Profile selectProfileUnprepared(PMap hints) {
        ArrayList<Profile> matchingProfiles = new ArrayList<Profile>();
        for (Profile p : this.profiles) {
            if (!this.profileMatchesHints(p, hints)) continue;
            matchingProfiles.add(p);
        }
        if (matchingProfiles.isEmpty()) {
            throw new IllegalArgumentException("Cannot find matching profile for your request. Please check your parameters.\nrequested: " + this.getRequestAsString(hints) + "\navailable: " + this.profilesAsString(this.profiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
        }
        if (matchingProfiles.size() == 1) {
            return (Profile)matchingProfiles.get(0);
        }
        Profile match1 = (Profile)matchingProfiles.get(0);
        Profile match2 = (Profile)matchingProfiles.get(1);
        Boolean edgeBased = this.getEdgeBased(hints);
        if (edgeBased == null && matchingProfiles.size() == 2 && match1.getWeighting().equals(match2.getWeighting()) && match1.getVehicle().equals(match2.getVehicle()) && match1.isTurnCosts() != match2.isTurnCosts()) {
            return match1.isTurnCosts() ? match1 : match2;
        }
        throw new IllegalArgumentException("There are multiple profiles matching your request. Use the `weighting`, `vehicle and `turn_costs` parameters to be more specific.\nrequested:  " + this.getRequestAsString(hints) + "\nmatched:   " + this.profilesAsString(matchingProfiles) + "\navailable: " + this.profilesAsString(this.profiles) + "\nYou should consider using the `profile` parameter. The available profiles are: " + this.getProfileNames() + "\nTo learn more about profiles, see: docs/core/profiles.md");
    }

    protected boolean profileMatchesHints(Profile p, PMap hints) {
        Boolean edgeBased = this.getEdgeBased(hints);
        return !(edgeBased != null && p.isTurnCosts() != edgeBased.booleanValue() || hints.has("weighting") && !p.getWeighting().equalsIgnoreCase(hints.getString("weighting", "")) || hints.has("vehicle") && !p.getVehicle().equalsIgnoreCase(hints.getString("vehicle", "")));
    }

    private String getRequestAsString(PMap map) {
        Boolean edgeBased = this.getEdgeBased(map);
        return (!map.has("weighting") ? "*" : map.getString("weighting", "")) + "|" + (!map.has("vehicle") ? "*" : map.getString("vehicle", "")) + "|turn_costs=" + (edgeBased != null ? edgeBased : "*");
    }

    private String getCHRequestAsString(PMap hintsMap, Boolean edgeBased, Integer uTurnCosts) {
        return (!hintsMap.has("weighting") ? "*" : hintsMap.getString("weighting", "")) + "|" + (!hintsMap.has("vehicle") ? "*" : hintsMap.getString("vehicle", "")) + "|turn_costs=" + (edgeBased != null ? edgeBased : "*") + "|u_turn_costs=" + (uTurnCosts != null ? uTurnCosts : "*");
    }

    private List<String> profilesAsString(List<Profile> profiles) {
        ArrayList<String> result = new ArrayList<String>(profiles.size());
        for (Profile p : profiles) {
            result.add(p.getWeighting() + "|" + p.getVehicle() + "|turn_costs=" + p.isTurnCosts());
        }
        return result;
    }

    private List<String> chProfilesAsString(List<Profile> profiles) {
        ArrayList<String> result = new ArrayList<String>(profiles.size());
        for (Profile p : profiles) {
            String str = p.getWeighting() + "|" + p.getVehicle() + "|turn_costs=" + p.isTurnCosts();
            str = str + (p.isTurnCosts() ? "|u_turn_costs=" + p.getHints().getInt("u_turn_costs", -1) : "");
            result.add(str);
        }
        return result;
    }

    private List<String> getProfileNames() {
        ArrayList<String> result = new ArrayList<String>(this.profiles.size());
        for (Profile p : this.profiles) {
            result.add(p.getName());
        }
        return result;
    }

    private Boolean getEdgeBased(PMap hintsMap) {
        if (hintsMap.has("turn_costs")) {
            return hintsMap.getBool("turn_costs", false);
        }
        if (hintsMap.has("edge_based")) {
            return hintsMap.getBool("edge_based", false);
        }
        return null;
    }

    private Integer getUTurnCosts(PMap hintsMap) {
        return hintsMap.has("u_turn_costs") ? Integer.valueOf(hintsMap.getInt("u_turn_costs", -1)) : null;
    }
}

