/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.BidirPathExtractor;
import com.graphhopper.routing.BidirRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.NodeBasedCHBidirPathExtractor;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.storage.CHEdgeFilter;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import java.util.PriorityQueue;

public abstract class AbstractBidirCHAlgo
extends AbstractBidirAlgo
implements BidirRoutingAlgorithm {
    protected final RoutingCHGraph graph;
    protected final NodeAccess nodeAccess;
    protected RoutingCHEdgeExplorer inEdgeExplorer;
    protected RoutingCHEdgeExplorer outEdgeExplorer;
    protected CHEdgeFilter levelEdgeFilter;

    public AbstractBidirCHAlgo(RoutingCHGraph graph, TraversalMode tMode) {
        super(tMode);
        this.graph = graph;
        if (graph.hasTurnCosts() && !tMode.isEdgeBased()) {
            throw new IllegalStateException("Weightings supporting turn costs cannot be used with node-based traversal mode");
        }
        this.nodeAccess = graph.getBaseGraph().getNodeAccess();
        this.outEdgeExplorer = graph.createOutEdgeExplorer();
        this.inEdgeExplorer = graph.createInEdgeExplorer();
        this.levelEdgeFilter = new CHLevelEdgeFilter(graph);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 150000);
        this.initCollections(size);
    }

    @Override
    protected void initCollections(int size) {
        super.initCollections(Math.min(size, 2000));
    }

    protected abstract SPTEntry createEntry(int var1, int var2, int var3, double var4, SPTEntry var6, boolean var7);

    protected BidirPathExtractor createPathExtractor(RoutingCHGraph graph) {
        return new NodeBasedCHBidirPathExtractor(graph);
    }

    @Override
    protected void postInitFrom() {
        if (this.fromOutEdge == -2) {
            this.fillEdgesFromUsingFilter(this.levelEdgeFilter);
        } else {
            CHEdgeFilter tmpFilter = this.levelEdgeFilter;
            this.fillEdgesFromUsingFilter(edgeState -> (tmpFilter == null || tmpFilter.accept(edgeState)) && edgeState.getOrigEdgeFirst() == this.fromOutEdge);
        }
    }

    @Override
    protected void postInitTo() {
        if (this.toInEdge == -2) {
            this.fillEdgesToUsingFilter(this.levelEdgeFilter);
        } else {
            CHEdgeFilter tmpFilter = this.levelEdgeFilter;
            this.fillEdgesToUsingFilter(edgeState -> (tmpFilter == null || tmpFilter.accept(edgeState)) && edgeState.getOrigEdgeLast() == this.toInEdge);
        }
    }

    protected void fillEdgesFromUsingFilter(CHEdgeFilter edgeFilter) {
        CHEdgeFilter tmpFilter = this.levelEdgeFilter;
        this.levelEdgeFilter = edgeFilter;
        this.finishedFrom = !this.fillEdgesFrom();
        this.levelEdgeFilter = tmpFilter;
    }

    protected void fillEdgesToUsingFilter(CHEdgeFilter edgeFilter) {
        CHEdgeFilter tmpFilter = this.levelEdgeFilter;
        this.levelEdgeFilter = edgeFilter;
        this.finishedTo = !this.fillEdgesTo();
        this.levelEdgeFilter = tmpFilter;
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        return this.currFrom.weight >= this.bestWeight && this.currTo.weight >= this.bestWeight;
    }

    @Override
    boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = (SPTEntry)this.pqOpenSetFrom.poll();
        ++this.visitedCountFrom;
        if (this.fromEntryCanBeSkipped()) {
            return true;
        }
        if (this.fwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, (IntObjectMap<SPTEntry>)this.bestWeightMapFrom, this.outEdgeExplorer, false);
        return true;
    }

    @Override
    boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = (SPTEntry)this.pqOpenSetTo.poll();
        ++this.visitedCountTo;
        if (this.toEntryCanBeSkipped()) {
            return true;
        }
        if (this.bwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, (IntObjectMap<SPTEntry>)this.bestWeightMapTo, this.inEdgeExplorer, true);
        return true;
    }

    private void fillEdges(SPTEntry currEdge, PriorityQueue<SPTEntry> prioQueue, IntObjectMap<SPTEntry> bestWeightMap, RoutingCHEdgeExplorer explorer, boolean reverse) {
        RoutingCHEdgeIterator iter = explorer.setBaseNode(currEdge.adjNode);
        while (iter.next()) {
            double weight;
            if (!this.accept(iter, currEdge, reverse) || Double.isInfinite(weight = this.calcWeight((RoutingCHEdgeIteratorState)iter, currEdge, reverse))) continue;
            int origEdgeId = this.getOrigEdgeId(iter, reverse);
            int traversalId = this.getTraversalId(iter, origEdgeId, reverse);
            SPTEntry entry = (SPTEntry)bestWeightMap.get(traversalId);
            if (entry == null) {
                entry = this.createEntry(iter.getEdge(), iter.getAdjNode(), origEdgeId, weight, currEdge, reverse);
                bestWeightMap.put(traversalId, (Object)entry);
                prioQueue.add(entry);
            } else {
                if (!(entry.getWeightOfVisitedPath() > weight)) continue;
                prioQueue.remove(entry);
                this.updateEntry(entry, iter.getEdge(), iter.getAdjNode(), origEdgeId, weight, currEdge, reverse);
                prioQueue.add(entry);
            }
            if (!this.updateBestPath) continue;
            this.updateBestPath(Double.POSITIVE_INFINITY, entry, origEdgeId, traversalId, reverse);
        }
    }

    protected double calcWeight(RoutingCHEdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double edgeWeight = edgeState.getWeight(reverse);
        int origEdgeId = reverse ? edgeState.getOrigEdgeLast() : edgeState.getOrigEdgeFirst();
        double turnCosts = reverse ? this.graph.getTurnWeight(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : this.graph.getTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        return edgeWeight + turnCosts;
    }

    protected void updateEntry(SPTEntry entry, int edge, int adjNode, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge;
        entry.weight = weight;
        entry.parent = parent;
    }

    protected boolean accept(RoutingCHEdgeIteratorState edge, SPTEntry currEdge, boolean reverse) {
        return this.accept(edge, this.getIncomingEdge(currEdge));
    }

    protected int getOrigEdgeId(RoutingCHEdgeIteratorState edge, boolean reverse) {
        return edge.getEdge();
    }

    protected int getTraversalId(RoutingCHEdgeIteratorState edge, int origEdgeId, boolean reverse) {
        return this.getTraversalId(edge, reverse);
    }

    protected int getTraversalId(RoutingCHEdgeIteratorState edge, boolean reverse) {
        return this.traversalMode.createTraversalId(edge.getBaseNode(), edge.getAdjNode(), edge.getEdge(), reverse);
    }

    @Override
    protected int getOtherNode(int edge, int node) {
        return this.graph.getBaseGraph().getOtherNode(edge, node);
    }

    protected double calcWeight(RoutingCHEdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return this.calcWeight(iter, reverse, this.getIncomingEdge(currEdge)) + currEdge.getWeightOfVisitedPath();
    }

    @Override
    protected double getInEdgeWeight(SPTEntry entry) {
        return this.graph.getEdgeIteratorState(this.getIncomingEdge(entry), entry.adjNode).getWeight(false);
    }

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.createPathExtractor(this.graph).extract(this.bestFwdEntry, this.bestBwdEntry, this.bestWeight);
        }
        return this.createEmptyPath();
    }

    protected boolean accept(RoutingCHEdgeIteratorState iter, int prevOrNextEdgeId) {
        if (!this.traversalMode.isEdgeBased() && iter.getEdge() == prevOrNextEdgeId) {
            return false;
        }
        return this.levelEdgeFilter == null || this.levelEdgeFilter.accept(iter);
    }

    protected Path createEmptyPath() {
        return new Path(this.graph.getBaseGraph());
    }

    public String toString() {
        return this.getName() + "|" + this.graph.getWeighting();
    }

    private static class CHLevelEdgeFilter
    implements CHEdgeFilter {
        private final RoutingCHGraph graph;
        private final int maxNodes;

        public CHLevelEdgeFilter(RoutingCHGraph graph) {
            this.graph = graph;
            this.maxNodes = graph.getBaseGraph().getBaseGraph().getNodes();
        }

        @Override
        public boolean accept(RoutingCHEdgeIteratorState edgeState) {
            int base = edgeState.getBaseNode();
            int adj = edgeState.getAdjNode();
            if (base >= this.maxNodes || adj >= this.maxNodes) {
                return true;
            }
            if (edgeState.isShortcut()) {
                return true;
            }
            return this.graph.getLevel(base) <= this.graph.getLevel(adj);
        }
    }
}

