/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;

public class EdgeSampling {
    private static final double GREAT_CIRCLE_SEGMENT_LENGTH = 27798.73166113968;

    private EdgeSampling() {
    }

    public static PointList sample(long wayOsmId, PointList input, double maxDistance, DistanceCalc distCalc, ElevationProvider elevation) {
        PointList output = new PointList(input.getSize() * 2, input.is3D());
        if (input.isEmpty()) {
            return output;
        }
        int nodes = input.getSize();
        double lastLat = input.getLat(0);
        double lastLon = input.getLon(0);
        double lastEle = input.getEle(0);
        for (int i = 0; i < nodes; ++i) {
            double thisLat = input.getLat(i);
            double thisLon = input.getLon(i);
            double thisEle = input.getEle(i);
            if (i > 0) {
                double segmentLength = distCalc.calcDist3D(lastLat, lastLon, lastEle, thisLat, thisLon, thisEle);
                int segments = (int)Math.round(segmentLength / maxDistance);
                boolean exact = segmentLength > 27798.73166113968 || distCalc.isCrossBoundary(lastLon, thisLon);
                for (int segment = 1; segment < segments; ++segment) {
                    double lon;
                    double lat;
                    double ratio = (double)segment / (double)segments;
                    if (exact) {
                        GHPoint point = distCalc.intermediatePoint(ratio, lastLat, lastLon, thisLat, thisLon);
                        lat = point.getLat();
                        lon = point.getLon();
                    } else {
                        lat = lastLat + (thisLat - lastLat) * ratio;
                        lon = lastLon + (thisLon - lastLon) * ratio;
                    }
                    double ele = elevation.getEle(lat, lon);
                    if (Double.isNaN(ele)) continue;
                    output.add(lat, lon, ele);
                }
            }
            output.add(thisLat, thisLon, thisEle);
            lastLat = thisLat;
            lastLon = thisLon;
            lastEle = thisEle;
        }
        return output;
    }
}

