/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.util.concurrent.atomic.AtomicInteger;

public final class OpaqueGenerater {
    private AtomicInteger counter = new AtomicInteger(0);

    private OpaqueGenerater() {
    }

    public static OpaqueGenerater getInstance() {
        return SingletonHolder.opaqueGenerater;
    }

    public void setValue(int v) {
        this.counter.set(v);
    }

    public int getNextValue() {
        int val = this.counter.incrementAndGet();
        if (val < 0) {
            while (val < 0 && !this.counter.compareAndSet(val, 0)) {
                val = this.counter.get();
            }
            return this.counter.incrementAndGet();
        }
        return val;
    }

    static final class SingletonHolder {
        static final OpaqueGenerater opaqueGenerater = new OpaqueGenerater();

        SingletonHolder() {
        }
    }
}

