/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.runtime.function.ClassMethodFunction;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;

public class Reflector {
    private static final FluentPropertyBeanIntrospector INTROSPECTOR = new FluentPropertyBeanIntrospector();
    public static ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cachedProperties = new ConcurrentHashMap();
    private static final ReferenceQueue<Map<String, PropertyFoundResult>> cachePropertyRq = new ReferenceQueue();
    public static ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cachedMethods = new ConcurrentHashMap();
    private static final ReferenceQueue<Map<String, PropertyFoundResult>> cacheMethodRq = new ReferenceQueue();
    static ConcurrentHashMap<MethodKey, Reference<List<Method>>> instanceMethodsCache = new ConcurrentHashMap();
    static final ReferenceQueue<List<Method>> instanceMethodsRq = new ReferenceQueue();
    private static Set<Class<?>> longClasses = Reflector.asSet(Long.class, Long.TYPE, Integer.class, Integer.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE);
    private static Set<Class<?>> doubleClasses = Reflector.asSet(Double.class, Double.TYPE, Float.class, Float.TYPE);
    private static final ReferenceQueue<BeanUtilsBean> beansRq = new ReferenceQueue();
    private static final ConcurrentHashMap<ClassLoader, Reference<BeanUtilsBean>> beansByClassLoader = new ConcurrentHashMap();

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        Reflector.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    private static String noMethodReport(String methodName, Object target, Object[] args) {
        return "No matching method " + methodName + " found taking " + args.length + " args" + (target == null ? "" : " for " + target.getClass());
    }

    public static boolean subsumes(Class<?>[] c1, Class<?>[] c2) {
        Boolean better = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                better = true;
                continue;
            }
            return false;
        }
        return better;
    }

    private static Throwable getCauseOrElse(Exception e) {
        if (e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    static Object invokeMatchingMethod(String methodName, List methods, Object target, Object[] args) {
        Method m2 = null;
        Object[] boxedArgs = null;
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target, args));
        }
        if (methods.size() == 1) {
            m2 = (Method)methods.get(0);
            boxedArgs = Reflector.boxArgs(m2.getParameterTypes(), args);
        } else {
            Method foundm = null;
            for (Method m2 : methods) {
                Class<?>[] params = m2.getParameterTypes();
                if (!Reflector.isCongruent(params, args) || foundm != null && !Reflector.subsumes(params, foundm.getParameterTypes())) continue;
                foundm = m2;
                boxedArgs = Reflector.boxArgs(params, args);
            }
            m2 = foundm;
        }
        if (m2 == null) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target, args));
        }
        try {
            return m2.invoke(target, boxedArgs);
        }
        catch (Exception e) {
            throw Reflector.sneakyThrow(Reflector.getCauseOrElse(e));
        }
    }

    public static StringBuilder capitalize(StringBuilder sb, String s) {
        if (s == null) {
            return sb;
        }
        sb.append(s.substring(0, 1).toUpperCase());
        sb.append(s.substring(1));
        return sb;
    }

    private static String genGetterName(String prefix, String name) {
        StringBuilder sb = new StringBuilder(prefix);
        Reflector.capitalize(sb, name);
        return sb.toString();
    }

    public static Object fastGetProperty(Object obj, String name, PropertyType type) {
        Class<?> clazz = type.isStaticProperty() ? (Class<?>)obj : obj.getClass();
        Map<String, PropertyFoundResult> results = null;
        results = type == PropertyType.StaticMethod ? Reflector.getClassPropertyResults(cachedMethods, cacheMethodRq, clazz) : Reflector.getClassPropertyResults(cachedProperties, cachePropertyRq, clazz);
        try {
            PropertyFoundResult result = results.get(name);
            if (result == null) {
                switch (type) {
                    case StaticField: {
                        result = Reflector.retrieveStaticFieldHandle(results, clazz, name);
                        break;
                    }
                    case Getter: {
                        result = Reflector.retrieveGetterHandle(results, clazz, name);
                        break;
                    }
                    case StaticMethod: {
                        result = Reflector.retrieveStaticFunction(results, clazz, name);
                    }
                }
            }
            if (type == PropertyType.StaticMethod) {
                return result.func;
            }
            if (result.handle != null) {
                Object ret;
                Object object = ret = type == PropertyType.StaticField ? result.handle.invoke() : result.handle.invoke(obj);
                if (result.isBooleanType && !(ret instanceof Boolean)) {
                    Reflector.putDummyHandle(name, results);
                    return Reflector.getProperty(obj, name);
                }
                return ret;
            }
            if (type == PropertyType.Getter) {
                return Reflector.getProperty(obj, name);
            }
            return null;
        }
        catch (Throwable t) {
            if (!results.containsKey(name)) {
                Reflector.putDummyHandle(name, results);
            }
            throw Reflector.sneakyThrow(t);
        }
    }

    private static PropertyFoundResult retrieveStaticFieldHandle(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException, NoSuchFieldException {
        PropertyFoundResult result;
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field != null && Modifier.isStatic(field.getModifiers())) {
            field.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            result = new PropertyFoundResult(handle, false);
        } else {
            result = new PropertyFoundResult(null, false);
        }
        results.put(name, result);
        return result;
    }

    private static PropertyFoundResult retrieveStaticFunction(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException, NoSuchMethodException {
        PropertyFoundResult result;
        List<Method> methods = Reflector.getStaticMethods(clazz, name);
        if (methods != null && !methods.isEmpty()) {
            ClassMethodFunction func = new ClassMethodFunction(clazz, true, name, name, methods);
            result = new PropertyFoundResult(func);
        } else {
            result = new PropertyFoundResult(null);
        }
        results.put(name, result);
        return result;
    }

    private static PropertyFoundResult retrieveGetterHandle(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException {
        PropertyFoundResult result;
        List<Method> methods = Reflector.getInstanceMethods(clazz, Reflector.genGetterName("get", name));
        boolean isBooleanType = false;
        if (methods == null || methods.isEmpty()) {
            methods = Reflector.getInstanceMethods(clazz, Reflector.genGetterName("is", name));
            isBooleanType = true;
        }
        if (methods != null && !methods.isEmpty()) {
            Method method = methods.get(0);
            for (Method m : methods) {
                if (method.getParameterTypes().length != 0) continue;
                method = m;
                break;
            }
            method.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            result = new PropertyFoundResult(handle, isBooleanType);
        } else {
            result = new PropertyFoundResult(null, isBooleanType);
        }
        results.put(name, result);
        return result;
    }

    private static void putDummyHandle(String name, Map<String, PropertyFoundResult> handles) {
        handles.put(name, new PropertyFoundResult(null, false));
    }

    private static Map<String, PropertyFoundResult> getClassPropertyResults(ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cache, ReferenceQueue<Map<String, PropertyFoundResult>> rq, Class<?> clazz) {
        Reference existsRef = cache.get(clazz);
        Map<String, PropertyFoundResult> results = Collections.emptyMap();
        if (existsRef == null) {
            Reflector.clearCache(rq, cache);
            results = new ConcurrentHashMap<String, PropertyFoundResult>();
            existsRef = cache.putIfAbsent(clazz, new WeakReference<Map<String, PropertyFoundResult>>(results, rq));
        }
        if (existsRef == null) {
            return results;
        }
        results = existsRef.get();
        if (results != null) {
            return results;
        }
        cache.remove(clazz, existsRef);
        return Reflector.getClassPropertyResults(cache, rq, clazz);
    }

    public static List<Method> getStaticMethods(Class<?> c, String methodName) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : c.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !methodName.equals(method.getName())) continue;
            ret.add(method);
        }
        return ret;
    }

    static <K, V> void clearCache(ReferenceQueue<V> rq, ConcurrentHashMap<K, Reference<V>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<K, Reference<V>> e : cache.entrySet()) {
                Reference<V> val = e.getValue();
                if (val == null || val.get() != null) continue;
                cache.remove(e.getKey(), val);
            }
        }
    }

    public static List<Method> getInstanceMethods(Class<?> clazz, String methodName) {
        MethodKey key = new MethodKey(clazz, methodName);
        Reference existingRef = instanceMethodsCache.get(key);
        List<Method> methods = Collections.emptyList();
        if (existingRef == null) {
            Reflector.clearCache(instanceMethodsRq, instanceMethodsCache);
            methods = Reflector.getClassInstanceMethods(clazz, methodName);
            existingRef = instanceMethodsCache.putIfAbsent(key, new SoftReference<List<Method>>(methods, instanceMethodsRq));
        }
        if (existingRef == null) {
            return methods;
        }
        List<Method> existingMethods = existingRef.get();
        if (existingMethods != null) {
            return existingMethods;
        }
        instanceMethodsCache.remove(key, existingRef);
        return Reflector.getInstanceMethods(clazz, methodName);
    }

    private static List<Method> getClassInstanceMethods(Class<?> c, String methodName) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : c.getMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            ret.add(method);
        }
        return ret;
    }

    public static Object invokeStaticMethod(Class<?> c, String methodName, List<Method> methods, Object[] args) {
        return Reflector.invokeMatchingMethod(methodName, methods, null, args);
    }

    public static Object invokeInstanceMethod(Class<?> c, String methodName, Object target, List<Method> methods, Object[] args) {
        return Reflector.invokeMatchingMethod(methodName, methods, target, args);
    }

    public static Object boxArg(Class<?> paramType, Object arg) {
        if (!paramType.isPrimitive()) {
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            if (paramType == Integer.TYPE) {
                return n.intValue();
            }
            if (paramType == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (paramType == Double.TYPE) {
                return n.doubleValue();
            }
            if (paramType == Long.TYPE) {
                return n.longValue();
            }
            if (paramType == Short.TYPE) {
                return n.shortValue();
            }
            if (paramType == Byte.TYPE) {
                return n.byteValue();
            }
        }
        throw new IllegalArgumentException("Unexpected param type, expected: " + paramType + ", given: " + arg.getClass().getName());
    }

    public static Object[] boxArgs(Class<?>[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object arg = args[i];
            Class<?> paramType = params[i];
            ret[i] = Reflector.boxArg(paramType, arg);
        }
        return ret;
    }

    private static Set<Class<?>> asSet(Class<?> ... classes) {
        HashSet ret = new HashSet();
        for (Class<?> clazz : classes) {
            ret.add(clazz);
        }
        return ret;
    }

    public static boolean paramArgTypeMatch(Class<?> paramType, Class<?> argType) {
        boolean ret;
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        boolean bl = ret = longClasses.contains(paramType) && longClasses.contains(argType);
        if (ret) {
            return ret;
        }
        boolean bl2 = ret = doubleClasses.contains(paramType) && doubleClasses.contains(argType);
        if (ret) {
            return ret;
        }
        if (paramType == Character.TYPE) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE) {
            return argType == Boolean.class;
        }
        return false;
    }

    public static boolean isCongruent(Class<?>[] params, Object[] args) {
        boolean ret = false;
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            ret = true;
            for (int i = 0; ret && i < params.length; ++i) {
                Object arg = args[i];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class<?> paramType = params[i];
                ret = Reflector.paramArgTypeMatch(paramType, argType);
            }
        }
        return ret;
    }

    public static BeanUtilsBean getBeanUtilsBean() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BeanUtilsBean instance = null;
        Reference ref = beansByClassLoader.get(classLoader);
        if (ref == null) {
            Reflector.clearCache(beansRq, beansByClassLoader);
            instance = new BeanUtilsBean();
            instance.getPropertyUtils().addBeanIntrospector((BeanIntrospector)INTROSPECTOR);
            ref = beansByClassLoader.putIfAbsent(classLoader, new SoftReference<BeanUtilsBean>(instance, beansRq));
            if (ref == null) {
                return instance;
            }
        }
        if ((instance = ref.get()) != null) {
            return instance;
        }
        beansByClassLoader.remove(classLoader, ref);
        return Reflector.getBeanUtilsBean();
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return Reflector.getBeanUtilsBean().getPropertyUtils().getProperty(bean, name);
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Reflector.getBeanUtilsBean().setProperty(bean, name, value);
    }

    static class MethodKey {
        Class<?> clazz;
        String name;

        public MethodKey(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static enum PropertyType {
        Getter,
        StaticField,
        StaticMethod;


        boolean isStaticProperty() {
            return this == StaticField || this == StaticMethod;
        }
    }

    static class PropertyFoundResult {
        MethodHandle handle;
        boolean isBooleanType;
        ClassMethodFunction func;

        public PropertyFoundResult(ClassMethodFunction func) {
            this.func = func;
        }

        public PropertyFoundResult(MethodHandle handle, boolean isBooleanType) {
            this.isBooleanType = isBooleanType;
            this.handle = handle;
        }

        public String toString() {
            return "MethodHandleResult [handle=" + this.handle + ", isBooleanType=" + this.isBooleanType + ", func=" + this.func + "]";
        }
    }
}

