/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.Map;

public class SeqNewArrayFunction
extends AbstractFunction {
    private static final long serialVersionUID = -6837670921285947159L;

    @Override
    public String getName() {
        return "seq.array_of";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        AviatorObject clazzVar = arg1;
        Number len = FunctionUtils.getNumberValue(arg2, env);
        if (clazzVar == null || clazzVar.getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Invalid class:" + (clazzVar == null ? "null" : clazzVar.desc(env)));
        }
        try {
            String name = ((AviatorJavaType)clazzVar).getName();
            Class<?> clazz = null;
            if (TypeUtils.PRIMITIVE_TYPES.containsKey(name)) {
                clazz = TypeUtils.PRIMITIVE_TYPES.get(name);
            } else {
                assert (env instanceof Env);
                clazz = ((Env)env).resolveClassSymbol(name);
            }
            return AviatorRuntimeJavaType.valueOf(Array.newInstance(clazz, len.intValue()));
        }
        catch (Throwable t) {
            throw Reflector.sneakyThrow(t);
        }
    }
}

