/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import java.util.List;

public class LambdaFunctionBootstrap {
    private final String name;
    private final Expression expression;
    private final List<FunctionParam> params;
    private final boolean inheritEnv;
    private final ThreadLocal<LambdaFunction> fnLocal = new ThreadLocal();

    public String getName() {
        return this.name;
    }

    public LambdaFunctionBootstrap(String name, Expression expression, List<FunctionParam> arguments, boolean inheritEnv) {
        this.name = name;
        this.expression = expression;
        this.params = arguments;
        this.inheritEnv = inheritEnv;
    }

    public LambdaFunction newInstance(Env env) {
        LambdaFunction fn = null;
        if (this.inheritEnv && (fn = this.fnLocal.get()) != null) {
            fn.setContext(env);
            return fn;
        }
        fn = new LambdaFunction(this.name, this.params, this.expression, env);
        fn.setInheritEnv(this.inheritEnv);
        if (this.inheritEnv) {
            this.fnLocal.set(fn);
        }
        return fn;
    }
}

