/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.asm;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.ClassExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.asm.ClassWriter;
import com.googlecode.aviator.asm.Label;
import com.googlecode.aviator.asm.MethodVisitor;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.LambdaGenerator;
import com.googlecode.aviator.code.asm.ClassDefiner;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.runtime.FunctionArgument;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.op.OperationRuntime;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.TypeUtils;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;

public class ASMCodeGenerator
implements CodeGenerator {
    private static final String RUNTIME_UTILS = "com/googlecode/aviator/runtime/RuntimeUtils";
    private static final String OBJECT_DESC = "Lcom/googlecode/aviator/runtime/type/AviatorObject;";
    private static final String JAVA_TYPE_OWNER = "com/googlecode/aviator/runtime/type/AviatorJavaType";
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final String OBJECT_OWNER = "com/googlecode/aviator/runtime/type/AviatorObject";
    public static final String FUNC_ARGS_INNER_VAR = "__fas__";
    private static final String FIELD_PREFIX = "f";
    private final AviatorEvaluatorInstance instance;
    private SymbolTable symbolTable;
    private final Env compileEnv;
    private final ClassWriter classWriter;
    private MethodVisitor mv;
    private final String className;
    private final AviatorClassLoader classLoader;
    private LambdaGenerator lambdaGenerator;
    private Parser parser;
    private static final AtomicLong CLASS_COUNTER = new AtomicLong();
    private int operandsCount = 0;
    private int maxStacks = 0;
    private int maxLocals = 2;
    private int fieldCounter = 0;
    private Map<String, String> innerVars = Collections.emptyMap();
    private Map<String, String> innerMethodMap = Collections.emptyMap();
    private Map<Token<?>, String> constantPool = Collections.emptyMap();
    private Map<String, Integer> varTokens = Collections.emptyMap();
    private Map<String, Integer> methodTokens = Collections.emptyMap();
    private final Map<Label, Map<String, Integer>> labelNameIndexMap = new IdentityHashMap<Label, Map<String, Integer>>();
    private Map<Integer, List<FunctionArgument>> funcsArgs;
    private int funcInvocationId = 0;
    private Map<String, LambdaFunctionBootstrap> lambdaBootstraps;
    private static final Label START_LABEL = new Label();
    private Label currentLabel = START_LABEL;
    private CodeGenerator parentCodeGenerator;
    private final String sourceFile;
    private final Stack<Label> l0stack = new Stack();
    private final Stack<Label> l1stack = new Stack();
    private final ArrayDeque<MethodMetaData> methodMetaDataStack = new ArrayDeque();

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
        this.symbolTable = parser.getSymbolTable();
    }

    private void setMaxStacks(int newMaxStacks) {
        if (newMaxStacks > this.maxStacks) {
            this.maxStacks = newMaxStacks;
        }
    }

    private Map<Integer, List<FunctionArgument>> getFuncsArgs() {
        if (this.funcsArgs == null) {
            this.funcsArgs = new HashMap<Integer, List<FunctionArgument>>();
        }
        return this.funcsArgs;
    }

    private int getNextFuncInvocationId() {
        return this.funcInvocationId++;
    }

    public ASMCodeGenerator(AviatorEvaluatorInstance instance, String sourceFile, AviatorClassLoader classLoader, OutputStream traceOut) {
        this.classLoader = classLoader;
        this.instance = instance;
        this.compileEnv = new Env();
        this.sourceFile = sourceFile;
        this.compileEnv.setInstance(this.instance);
        this.className = "Script_" + System.currentTimeMillis() + "_" + CLASS_COUNTER.getAndIncrement();
        this.classWriter = new ClassWriter(2);
        this.visitClass();
    }

    public AviatorClassLoader getClassLoader() {
        return this.classLoader;
    }

    LambdaGenerator getLambdaGenerator() {
        return this.lambdaGenerator;
    }

    public void start() {
        this.makeConstructor();
        this.startVisitMethodCode();
    }

    private void startVisitMethodCode() {
        this.mv = this.classWriter.visitMethod(17, "execute0", "(Lcom/googlecode/aviator/utils/Env;)Ljava/lang/Object;", "(Lcom/googlecode/aviator/utils/Env;)Ljava/lang/Object;", null);
        this.mv.visitCode();
    }

    private void endVisitMethodCode(boolean unboxObject) {
        if (this.operandsCount > 0) {
            this.loadEnv();
            if (unboxObject) {
                this.mv.visitMethodInsn(182, OBJECT_OWNER, "getValue", "(Ljava/util/Map;)Ljava/lang/Object;");
            } else {
                this.mv.visitMethodInsn(182, OBJECT_OWNER, "deref", "(Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            }
            this.mv.visitInsn(176);
            this.popOperand();
            this.popOperand();
        } else {
            this.mv.visitInsn(1);
            this.mv.visitInsn(176);
            this.pushOperand();
            this.popOperand();
        }
        if (this.operandsCount > 0) {
            throw new CompileExpressionErrorException("operand stack is not empty,count=" + this.operandsCount);
        }
        this.mv.visitMaxs(this.maxStacks, this.maxLocals);
        this.mv.visitEnd();
    }

    private void endVisitClass() {
        this.classWriter.visitEnd();
    }

    private void makeConstructor() {
        String innerName;
        String outterName;
        this.mv = this.classWriter.visitMethod(1, CONSTRUCTOR_METHOD_NAME, "(Lcom/googlecode/aviator/AviatorEvaluatorInstance;Ljava/util/List;Lcom/googlecode/aviator/lexer/SymbolTable;)V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitVarInsn(25, 3);
        this.mv.visitMethodInsn(183, "com/googlecode/aviator/ClassExpression", CONSTRUCTOR_METHOD_NAME, "(Lcom/googlecode/aviator/AviatorEvaluatorInstance;Ljava/util/List;Lcom/googlecode/aviator/lexer/SymbolTable;)V");
        if (!this.innerVars.isEmpty()) {
            for (Map.Entry<String, String> entry : this.innerVars.entrySet()) {
                outterName = entry.getKey();
                innerName = entry.getValue();
                this.mv.visitVarInsn(25, 0);
                this.mv.visitTypeInsn(187, JAVA_TYPE_OWNER);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(outterName);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitMethodInsn(183, JAVA_TYPE_OWNER, CONSTRUCTOR_METHOD_NAME, "(Ljava/lang/String;Lcom/googlecode/aviator/lexer/SymbolTable;)V");
                this.mv.visitFieldInsn(181, this.className, innerName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;");
            }
        }
        if (!this.innerMethodMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.innerMethodMap.entrySet()) {
                outterName = entry.getKey();
                innerName = entry.getValue();
                this.mv.visitVarInsn(25, 0);
                this.mv.visitVarInsn(25, 1);
                this.mv.visitLdcInsn(outterName);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitMethodInsn(182, "com/googlecode/aviator/AviatorEvaluatorInstance", "getFunction", "(Ljava/lang/String;Lcom/googlecode/aviator/lexer/SymbolTable;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
                this.mv.visitFieldInsn(181, this.className, innerName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
            }
        }
        if (!this.constantPool.isEmpty()) {
            for (Map.Entry<Object, String> entry : this.constantPool.entrySet()) {
                Token token = (Token)entry.getKey();
                String fieldName = entry.getValue();
                this.mv.visitVarInsn(25, 0);
                this.onConstant0(token, true);
                this.popOperand();
                this.mv.visitFieldInsn(181, this.className, fieldName, OBJECT_DESC);
            }
        }
        this.mv.visitInsn(177);
        this.mv.visitMaxs(4, 1);
        this.mv.visitEnd();
    }

    private void visitClass() {
        this.classWriter.visit(this.instance.getBytecodeVersion(), 33, this.className, null, "com/googlecode/aviator/ClassExpression", null);
        this.classWriter.visitSource(this.sourceFile == null ? this.className : this.sourceFile, null);
    }

    private Label makeLabel() {
        return new Label();
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.ADD, "add");
    }

    private void loadOpType(OperatorType opType) {
        this.pushOperand();
        this.mv.visitFieldInsn(178, "com/googlecode/aviator/lexer/token/OperatorType", opType.name(), "Lcom/googlecode/aviator/lexer/token/OperatorType;");
    }

    private void popOperand() {
        --this.operandsCount;
    }

    private void popOperand(int n) {
        this.operandsCount -= n;
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.SUB, "sub");
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.MULT, "mult");
    }

    @Override
    public void onExponent(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.Exponent, "exponent");
    }

    @Override
    public void onAssignment(Token<?> lookhead) {
        this.visitLineNumber(lookhead);
        OperatorType opType = lookhead.getMeta("define", false) != false ? OperatorType.DEFINE : OperatorType.ASSIGNMENT;
        this.loadEnv();
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            String methodName = opType == OperatorType.DEFINE ? "defineValue" : "setValue";
            this.mv.visitMethodInsn(182, OBJECT_OWNER, methodName, "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand(3);
        this.pushOperand();
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.DIV, "div");
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.MOD, "mod");
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.loadEnv();
        this.visitLeftBranch(lookhead, 153, OperatorType.AND);
    }

    private void visitBoolean() {
        this.mv.visitMethodInsn(182, OBJECT_OWNER, "booleanValue", "(Ljava/util/Map;)Z");
    }

    private void pushLabel0(Label l0) {
        this.l0stack.push(l0);
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.visitRightBranch(lookhead, 153, OperatorType.AND);
        this.popOperand(2);
        this.pushOperand();
    }

    private void visitRightBranch(Token<?> lookhead, int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            this.loadEnv();
            String first = "TRUE";
            String second = "FALSE";
            if (opType == OperatorType.OR) {
                first = "FALSE";
                second = "TRUE";
            }
            this.visitBoolean();
            this.mv.visitJumpInsn(ints, this.peekLabel0());
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", first, "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            Label l1 = this.makeLabel();
            this.visitLineNumber(lookhead);
            this.mv.visitJumpInsn(167, l1);
            this.visitLabel(this.popLabel0());
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", second, "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.visitLabel(l1);
        } else {
            this.loadOpType(opType);
            this.visitLineNumber(lookhead);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.loadEnv();
        this.visitLineNumber(lookhead);
        this.visitBoolean();
        Label l0 = this.makeLabel();
        Label l1 = this.makeLabel();
        this.pushLabel0(l0);
        this.pushLabel1(l1);
        this.mv.visitJumpInsn(153, l0);
        this.popOperand();
        this.popOperand();
        this.pushOperand(2);
        this.popOperand();
    }

    private void pushLabel1(Label l1) {
        this.l1stack.push(l1);
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.mv.visitJumpInsn(167, this.peekLabel1());
        this.visitLabel(this.popLabel0());
        this.visitLineNumber(lookhead);
        this.popOperand();
    }

    private Label peekLabel1() {
        return this.l1stack.peek();
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.visitLabel(this.popLabel1());
        this.visitLineNumber(lookhead);
        this.popOperand();
    }

    @Override
    public void onTernaryEnd(Token<?> lookhead) {
        this.visitLineNumber(lookhead);
        if (this.operandsCount == 0) {
            return;
        }
        while (--this.operandsCount > 0) {
            this.mv.visitInsn(87);
        }
    }

    private Label popLabel1() {
        return this.l1stack.pop();
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.visitRightBranch(lookhead, 154, OperatorType.OR);
        this.popOperand(2);
        this.pushOperand();
    }

    private void visitLabel(Label label) {
        this.mv.visitLabel(label);
        this.currentLabel = label;
    }

    private Label peekLabel0() {
        return this.l0stack.peek();
    }

    private Label popLabel0() {
        return this.l0stack.pop();
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.loadEnv();
        this.visitLeftBranch(lookhead, 154, OperatorType.OR);
    }

    private void visitLeftBranch(Token<?> lookhead, int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            this.visitBoolean();
            Label l0 = this.makeLabel();
            this.pushLabel0(l0);
            this.visitLineNumber(lookhead);
            this.mv.visitJumpInsn(ints, l0);
            this.popOperand();
        }
        this.popOperand();
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 154, OperatorType.EQ);
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.visitLineNumber(lookhead);
        this.visitBinOperator(lookhead, OperatorType.MATCH, "match");
        this.popOperand();
        this.pushOperand();
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 153, OperatorType.NEQ);
    }

    private void doCompareAndJump(Token<?> lookhead, int ints, OperatorType opType) {
        this.visitLineNumber(lookhead);
        this.loadEnv();
        this.visitCompare(ints, opType);
        this.popOperand();
        this.popOperand();
    }

    private boolean isEqNe(int ints) {
        return ints == 153 || ints == 154;
    }

    private void visitCompare(int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            this.mv.visitMethodInsn(182, OBJECT_OWNER, this.isEqNe(ints) ? "compareEq" : "compare", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;)I");
            Label l0 = this.makeLabel();
            Label l1 = this.makeLabel();
            this.mv.visitJumpInsn(ints, l0);
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "TRUE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.mv.visitJumpInsn(167, l1);
            this.visitLabel(l0);
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "FALSE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.visitLabel(l1);
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 155, OperatorType.GE);
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 158, OperatorType.GT);
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 157, OperatorType.LE);
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.doCompareAndJump(lookhead, 156, OperatorType.LT);
    }

    private void pushOperand(int delta) {
        this.operandsCount += delta;
        this.setMaxStacks(this.operandsCount);
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.visitUnaryOperator(lookhead, OperatorType.NOT, "not");
    }

    private void visitBinOperator(Token<?> token, OperatorType opType, String methodName) {
        this.visitLineNumber(token);
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            if (opType == OperatorType.MATCH) {
                this.mv.visitInsn(95);
            }
            this.loadEnv();
            this.mv.visitMethodInsn(182, OBJECT_OWNER, methodName, "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadEnv();
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand();
        this.popOperand();
    }

    private void visitLineNumber(Token<?> token) {
        if (token != null && token.getLineNo() > 0) {
            this.mv.visitLineNumber(token.getLineNo(), this.currentLabel);
        }
    }

    private void visitUnaryOperator(Token<?> lookhead, OperatorType opType, String methodName) {
        this.visitLineNumber(lookhead);
        this.mv.visitTypeInsn(192, OBJECT_OWNER);
        this.loadEnv();
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, opType)) {
            this.mv.visitMethodInsn(182, OBJECT_OWNER, methodName, "(Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand();
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.visitUnaryOperator(lookhead, OperatorType.BIT_NOT, "bitNot");
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.visitUnaryOperator(lookhead, OperatorType.NEG, "neg");
    }

    @Override
    public Expression getResult(boolean unboxObject) {
        this.end(unboxObject);
        byte[] bytes = this.classWriter.toByteArray();
        try {
            Class<?> defineClass = ClassDefiner.defineClass(this.className, Expression.class, bytes, this.classLoader);
            Constructor<?> constructor = defineClass.getConstructor(AviatorEvaluatorInstance.class, List.class, SymbolTable.class);
            ClassExpression exp = (ClassExpression)constructor.newInstance(this.instance, new ArrayList<String>(this.varTokens.keySet()), this.symbolTable);
            exp.setLambdaBootstraps(this.lambdaBootstraps);
            exp.setFuncsArgs(this.funcsArgs);
            return exp;
        }
        catch (ExpressionRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof ExpressionRuntimeException) {
                throw (ExpressionRuntimeException)e.getCause();
            }
            throw new CompileExpressionErrorException("define class error", e);
        }
    }

    private void end(boolean unboxObject) {
        this.endVisitMethodCode(unboxObject);
        this.endVisitClass();
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        this.onConstant0(lookhead, false);
    }

    private void onConstant0(Token<?> lookhead, boolean inConstructor) {
        if (lookhead == null) {
            return;
        }
        this.visitLineNumber(lookhead);
        switch (lookhead.getType()) {
            case Number: {
                if (this.loadConstant(lookhead, inConstructor)) {
                    return;
                }
                NumberToken numberToken = (NumberToken)lookhead;
                Number number = numberToken.getNumber();
                if (TypeUtils.isBigInt(number)) {
                    this.mv.visitLdcInsn(numberToken.getLexeme());
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorBigInt", "valueOf", "(Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorBigInt;");
                } else if (TypeUtils.isDecimal(number)) {
                    this.loadEnv();
                    this.mv.visitLdcInsn(numberToken.getLexeme());
                    String methodDesc = "(Ljava/util/Map;Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorDecimal;";
                    if (inConstructor) {
                        methodDesc = "(Lcom/googlecode/aviator/AviatorEvaluatorInstance;Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorDecimal;";
                    }
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorDecimal", "valueOf", methodDesc);
                    this.popOperand();
                } else if (TypeUtils.isDouble(number)) {
                    this.mv.visitLdcInsn(number);
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorDouble", "valueOf", "(D)Lcom/googlecode/aviator/runtime/type/AviatorDouble;");
                } else {
                    this.mv.visitLdcInsn(number);
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorLong", "valueOf", "(J)Lcom/googlecode/aviator/runtime/type/AviatorLong;");
                }
                this.pushOperand();
                break;
            }
            case String: {
                if (this.loadConstant(lookhead, inConstructor)) {
                    return;
                }
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorString");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(lookhead.getValue(null));
                this.mv.visitLdcInsn(true);
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorString", CONSTRUCTOR_METHOD_NAME, "(Ljava/lang/String;Z)V");
                this.pushOperand(4);
                this.popOperand(3);
                break;
            }
            case Pattern: {
                if (this.loadConstant(lookhead, inConstructor)) {
                    return;
                }
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorPattern");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(lookhead.getValue(null));
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorPattern", CONSTRUCTOR_METHOD_NAME, "(Ljava/lang/String;)V");
                this.pushOperand(3);
                this.popOperand(2);
                break;
            }
            case Variable: {
                Variable variable = (Variable)lookhead;
                if (variable.equals(Variable.TRUE)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "TRUE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
                    this.pushOperand();
                    break;
                }
                if (variable.equals(Variable.FALSE)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "FALSE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
                    this.pushOperand();
                    break;
                }
                if (variable.equals(Variable.NIL)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorNil", "NIL", "Lcom/googlecode/aviator/runtime/type/AviatorNil;");
                    this.pushOperand();
                    break;
                }
                String outterVarName = variable.getLexeme();
                String innerVarName = this.innerVars.get(outterVarName);
                if (innerVarName != null) {
                    Map<String, Integer> name2Index = this.labelNameIndexMap.get(this.currentLabel);
                    if (name2Index != null && name2Index.get(innerVarName) != null) {
                        int localIndex = name2Index.get(innerVarName);
                        this.mv.visitVarInsn(25, localIndex);
                        this.pushOperand();
                        break;
                    }
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, this.className, innerVarName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;");
                    if (this.varTokens.get(outterVarName) > 1) {
                        this.mv.visitInsn(89);
                        int localIndex = this.getLocalIndex();
                        this.mv.visitVarInsn(58, localIndex);
                        if (name2Index == null) {
                            name2Index = new HashMap<String, Integer>();
                            this.labelNameIndexMap.put(this.currentLabel, name2Index);
                        }
                        name2Index.put(innerVarName, localIndex);
                        this.pushOperand(3);
                        this.popOperand(2);
                        break;
                    }
                    this.pushOperand(2);
                    this.popOperand();
                    break;
                }
                this.mv.visitTypeInsn(187, JAVA_TYPE_OWNER);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(outterVarName);
                this.mv.visitMethodInsn(183, JAVA_TYPE_OWNER, CONSTRUCTOR_METHOD_NAME, "(Ljava/lang/String;)V");
                this.pushOperand(3);
                this.popOperand(2);
            }
        }
    }

    private boolean loadConstant(Token<?> lookhead, boolean inConstructor) {
        String fieldName;
        if (!inConstructor && (fieldName = this.constantPool.get(lookhead)) != null) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.className, fieldName, OBJECT_DESC);
            this.pushOperand();
            return true;
        }
        return false;
    }

    public void setLambdaBootstraps(Map<String, LambdaFunctionBootstrap> lambdaBootstraps) {
        this.lambdaBootstraps = lambdaBootstraps;
    }

    public void initVariables(Map<String, Integer> varTokens) {
        this.varTokens = varTokens;
        this.innerVars = new HashMap<String, String>(varTokens.size());
        for (String outterVarName : varTokens.keySet()) {
            String innerVarName = this.getInnerName(outterVarName);
            this.innerVars.put(outterVarName, innerVarName);
            this.classWriter.visitField(18, innerVarName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;", null, null).visitEnd();
        }
    }

    public void initConstants(Set<Token<?>> constants) {
        if (constants.isEmpty()) {
            return;
        }
        this.constantPool = new HashMap(constants.size());
        for (Token<?> token : constants) {
            String fieldName = this.getInnerName(token.getLexeme());
            this.constantPool.put(token, fieldName);
            this.classWriter.visitField(18, fieldName, OBJECT_DESC, null, null).visitEnd();
        }
    }

    public void initMethods(Map<String, Integer> methods) {
        this.methodTokens = methods;
        this.innerMethodMap = new HashMap<String, String>(methods.size());
        for (String outterMethodName : methods.keySet()) {
            String innerMethodName = this.getInnerName(outterMethodName);
            this.innerMethodMap.put(outterMethodName, innerMethodName);
            this.classWriter.visitField(18, innerMethodName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;", null, null).visitEnd();
        }
    }

    private String getInnerName(String varName) {
        return FIELD_PREFIX + this.fieldCounter++;
    }

    private static String getInvokeMethodDesc(int paramCount) {
        StringBuilder sb = new StringBuilder("(Ljava/util/Map;");
        if (paramCount <= 20) {
            for (int i = 0; i < paramCount; ++i) {
                sb.append(OBJECT_DESC);
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                sb.append(OBJECT_DESC);
            }
            sb.append("[Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        }
        sb.append(")Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        return sb.toString();
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        List params;
        this.visitLineNumber(lookhead);
        List list = params = lookhead != null ? lookhead.getMeta("params", Collections.EMPTY_LIST) : Collections.EMPTY_LIST;
        if (this.instance.getOptionValue((Options)Options.CAPTURE_FUNCTION_ARGS).bool) {
            int funcId = this.getNextFuncInvocationId();
            this.getFuncsArgs().put(funcId, Collections.unmodifiableList(params));
            this.loadEnv();
            this.mv.visitLdcInsn(FUNC_ARGS_INNER_VAR);
            this.mv.visitLdcInsn(funcId);
            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.mv.visitInsn(87);
            this.pushOperand(2);
            this.popOperand(3);
            this.pushOperand();
            this.popOperand();
        }
        MethodMetaData methodMetaData = this.methodMetaDataStack.pop();
        int parameterCount = methodMetaData.parameterCount;
        if (parameterCount >= 20) {
            if (parameterCount == 20) {
                this.mv.visitInsn(87);
                this.popOperand();
            } else {
                this.mv.visitMethodInsn(185, "java/util/List", "size", "()I");
                this.mv.visitTypeInsn(189, OBJECT_OWNER);
                int arrayIndex = this.getLocalIndex();
                this.mv.visitVarInsn(58, arrayIndex);
                this.mv.visitVarInsn(25, methodMetaData.variadicListIndex);
                this.mv.visitVarInsn(25, arrayIndex);
                this.mv.visitMethodInsn(185, "java/util/List", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                this.mv.visitTypeInsn(192, "[Lcom/googlecode/aviator/runtime/type/AviatorObject;");
                this.popOperand();
                this.pushOperand(2);
                this.popOperand();
            }
        }
        this.mv.visitMethodInsn(185, "com/googlecode/aviator/runtime/type/AviatorFunction", "call", ASMCodeGenerator.getInvokeMethodDesc(parameterCount));
        this.mv.visitMethodInsn(184, RUNTIME_UTILS, "assertNotNull", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        this.popOperand();
        this.popOperand();
        if (parameterCount <= 20) {
            this.popOperand(parameterCount);
        } else {
            this.popOperand(21);
        }
        this.pushOperand();
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        this.visitLineNumber(lookhead);
        MethodMetaData currentMethodMetaData = this.methodMetaDataStack.peek();
        if (currentMethodMetaData.parameterCount >= 20) {
            assert (currentMethodMetaData.variadicListIndex >= 0);
            this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            this.mv.visitInsn(87);
            this.mv.visitVarInsn(25, currentMethodMetaData.variadicListIndex);
            this.popOperand(2);
            this.pushOperand();
            this.popOperand();
            this.pushOperand();
        }
        ++currentMethodMetaData.parameterCount;
        if (currentMethodMetaData.parameterCount == 20) {
            this.mv.visitTypeInsn(187, "java/util/ArrayList");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/util/ArrayList", CONSTRUCTOR_METHOD_NAME, "()V");
            int listIndex = this.getLocalIndex();
            this.mv.visitVarInsn(58, listIndex);
            this.mv.visitVarInsn(25, listIndex);
            currentMethodMetaData.variadicListIndex = listIndex;
            this.pushOperand();
        }
    }

    private void pushOperand() {
        this.pushOperand(1);
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.onConstant(lookhead);
    }

    @Override
    public void onArrayIndexStart(Token<?> token) {
        this.loadEnv();
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.visitLineNumber(lookhead);
        if (!OperationRuntime.hasRuntimeContext(this.compileEnv, OperatorType.INDEX)) {
            this.mv.visitMethodInsn(182, OBJECT_OWNER, "getElement", "(Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadOpType(OperatorType.INDEX);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand(3);
        this.pushOperand();
    }

    public int getLocalIndex() {
        return this.maxLocals++;
    }

    @Override
    public void onLambdaDefineStart(Token<?> lookhead) {
        if (this.lambdaGenerator != null) {
            throw new CompileExpressionErrorException("Compile lambda error");
        }
        Boolean newLexicalScope = lookhead.getMeta("newLexicalScope", false);
        Boolean inheritEnv = lookhead.getMeta("inheritEnv", false);
        this.lambdaGenerator = new LambdaGenerator(this.instance, this, this.parser, this.classLoader, this.sourceFile, newLexicalScope, inheritEnv);
        this.lambdaGenerator.setScopeInfo(this.parser.enterScope(newLexicalScope));
    }

    @Override
    public void onLambdaArgument(Token<?> lookhead, FunctionParam param) {
        this.lambdaGenerator.addParam(param);
    }

    @Override
    public void onLambdaBodyStart(Token<?> lookhead) {
        this.parentCodeGenerator = this.parser.getCodeGenerator();
        this.parser.setCodeGenerator(this.lambdaGenerator);
    }

    @Override
    public void onLambdaBodyEnd(Token<?> lookhead) {
        LambdaFunctionBootstrap bootstrap = this.lambdaGenerator.getLmabdaBootstrap();
        if (this.lambdaBootstraps == null) {
            this.lambdaBootstraps = new HashMap<String, LambdaFunctionBootstrap>();
        }
        this.lambdaBootstraps.put(bootstrap.getName(), bootstrap);
        this.visitLineNumber(lookhead);
        this.genNewLambdaCode(bootstrap);
        this.parser.restoreScope(this.lambdaGenerator.getScopeInfo());
        this.lambdaGenerator = null;
        this.parser.setCodeGenerator(this.parentCodeGenerator);
    }

    public void genNewLambdaCode(LambdaFunctionBootstrap bootstrap) {
        this.mv.visitVarInsn(25, 0);
        this.loadEnv();
        this.mv.visitLdcInsn(bootstrap.getName());
        this.mv.visitMethodInsn(182, this.className, "newLambda", "(Lcom/googlecode/aviator/utils/Env;Ljava/lang/String;)Lcom/googlecode/aviator/runtime/function/LambdaFunction;");
        this.pushOperand(2);
        this.popOperand(2);
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        String outtterMethodName = "lambda";
        if (lookhead.getType() != Token.TokenType.Delegate) {
            outtterMethodName = lookhead.getLexeme();
            String innerMethodName = this.innerMethodMap.get(outtterMethodName);
            if (innerMethodName != null) {
                this.loadAviatorFunction(outtterMethodName, innerMethodName);
            } else {
                this.createAviatorFunctionObject(outtterMethodName);
            }
        } else {
            this.loadEnv();
            this.mv.visitMethodInsn(184, RUNTIME_UTILS, "getFunction", "(Ljava/lang/Object;Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
            this.popOperand();
        }
        if (this.instance.getOptionValue((Options)Options.TRACE_EVAL).bool) {
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/function/TraceFunction", "wrapTrace", "(Lcom/googlecode/aviator/runtime/type/AviatorFunction;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
        }
        this.loadEnv();
        this.methodMetaDataStack.push(new MethodMetaData(outtterMethodName));
    }

    private void loadAviatorFunction(String outterMethodName, String innerMethodName) {
        Map<String, Integer> name2Index = this.labelNameIndexMap.get(this.currentLabel);
        if (name2Index != null && name2Index.containsKey(innerMethodName)) {
            int localIndex = name2Index.get(innerMethodName);
            this.mv.visitVarInsn(25, localIndex);
            this.pushOperand();
        } else {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.className, innerMethodName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
            if (this.methodTokens.get(outterMethodName) > 1) {
                this.mv.visitInsn(89);
                int localIndex = this.getLocalIndex();
                this.mv.visitVarInsn(58, localIndex);
                if (name2Index == null) {
                    name2Index = new HashMap<String, Integer>();
                    this.labelNameIndexMap.put(this.currentLabel, name2Index);
                }
                name2Index.put(innerMethodName, localIndex);
                this.pushOperand(2);
                this.popOperand();
            } else {
                this.pushOperand();
            }
        }
    }

    private void loadEnv() {
        this.pushOperand();
        this.mv.visitVarInsn(25, 1);
    }

    private void createAviatorFunctionObject(String methodName) {
        this.loadEnv();
        this.pushOperand();
        this.mv.visitLdcInsn(methodName);
        this.mv.visitMethodInsn(184, RUNTIME_UTILS, "getFunction", "(Ljava/util/Map;Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
        this.popOperand(2);
        this.pushOperand();
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.BIT_AND, "bitAnd");
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.BIT_OR, "bitOr");
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.BIT_XOR, "bitXor");
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.SHIFT_LEFT, "shiftLeft");
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.SHIFT_RIGHT, "shiftRight");
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.visitBinOperator(lookhead, OperatorType.U_SHIFT_RIGHT, "unsignedShiftRight");
    }

    private static class MethodMetaData {
        int parameterCount = 0;
        int variadicListIndex = -1;

        public MethodMetaData(String methodName) {
        }
    }
}

