/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.ClassPathConfigFunctionLoader;
import com.googlecode.aviator.EnvProcessor;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.FunctionLoader;
import com.googlecode.aviator.FunctionMissing;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.RuntimeFunctionDelegator;
import com.googlecode.aviator.annotation.Function;
import com.googlecode.aviator.annotation.Ignore;
import com.googlecode.aviator.annotation.Import;
import com.googlecode.aviator.annotation.ImportScope;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.NoneCodeGenerator;
import com.googlecode.aviator.code.OptimizeCodeGenerator;
import com.googlecode.aviator.code.asm.ASMCodeGenerator;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.exception.ExpressionNotFoundException;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.exception.UnsupportedFeatureException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.ExpressionParser;
import com.googlecode.aviator.runtime.function.ClassMethodFunction;
import com.googlecode.aviator.runtime.function.math.MathAbsFunction;
import com.googlecode.aviator.runtime.function.math.MathAcosFunction;
import com.googlecode.aviator.runtime.function.math.MathAsinFunction;
import com.googlecode.aviator.runtime.function.math.MathAtanFunction;
import com.googlecode.aviator.runtime.function.math.MathCeilFunction;
import com.googlecode.aviator.runtime.function.math.MathCosFunction;
import com.googlecode.aviator.runtime.function.math.MathFloorFunction;
import com.googlecode.aviator.runtime.function.math.MathLog10Function;
import com.googlecode.aviator.runtime.function.math.MathLogFunction;
import com.googlecode.aviator.runtime.function.math.MathPowFunction;
import com.googlecode.aviator.runtime.function.math.MathRoundFunction;
import com.googlecode.aviator.runtime.function.math.MathSinFunction;
import com.googlecode.aviator.runtime.function.math.MathSqrtFunction;
import com.googlecode.aviator.runtime.function.math.MathTanFunction;
import com.googlecode.aviator.runtime.function.seq.SeqAddFunction;
import com.googlecode.aviator.runtime.function.seq.SeqArrayFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCollectorFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCollectorRawFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCompsitePredFunFunction;
import com.googlecode.aviator.runtime.function.seq.SeqContainsKeyFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCountFunction;
import com.googlecode.aviator.runtime.function.seq.SeqEveryFunction;
import com.googlecode.aviator.runtime.function.seq.SeqFilterFunction;
import com.googlecode.aviator.runtime.function.seq.SeqGetFunction;
import com.googlecode.aviator.runtime.function.seq.SeqIncludeFunction;
import com.googlecode.aviator.runtime.function.seq.SeqIntoFunction;
import com.googlecode.aviator.runtime.function.seq.SeqKeysFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMakePredicateFunFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMapEntryFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMapFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMaxFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMinFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNewArrayFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNewListFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNewMapFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNewSetFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNotAnyFunction;
import com.googlecode.aviator.runtime.function.seq.SeqPutFunction;
import com.googlecode.aviator.runtime.function.seq.SeqReduceFunction;
import com.googlecode.aviator.runtime.function.seq.SeqRemoveFunction;
import com.googlecode.aviator.runtime.function.seq.SeqReverseFunction;
import com.googlecode.aviator.runtime.function.seq.SeqSomeFunction;
import com.googlecode.aviator.runtime.function.seq.SeqSortFunction;
import com.googlecode.aviator.runtime.function.seq.SeqValsFunction;
import com.googlecode.aviator.runtime.function.seq.SeqZipmapFunction;
import com.googlecode.aviator.runtime.function.string.StringContainsFunction;
import com.googlecode.aviator.runtime.function.string.StringEndsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringIndexOfFunction;
import com.googlecode.aviator.runtime.function.string.StringJoinFunction;
import com.googlecode.aviator.runtime.function.string.StringLengthFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceAllFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceFirstFunction;
import com.googlecode.aviator.runtime.function.string.StringSplitFunction;
import com.googlecode.aviator.runtime.function.string.StringStartsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringSubStringFunction;
import com.googlecode.aviator.runtime.function.system.AssertFunction;
import com.googlecode.aviator.runtime.function.system.BigIntFunction;
import com.googlecode.aviator.runtime.function.system.BinaryFunction;
import com.googlecode.aviator.runtime.function.system.BooleanFunction;
import com.googlecode.aviator.runtime.function.system.ComparatorFunction;
import com.googlecode.aviator.runtime.function.system.CompareFunction;
import com.googlecode.aviator.runtime.function.system.Date2StringFunction;
import com.googlecode.aviator.runtime.function.system.DecimalFunction;
import com.googlecode.aviator.runtime.function.system.DoubleFunction;
import com.googlecode.aviator.runtime.function.system.EvalFunction;
import com.googlecode.aviator.runtime.function.system.IdentityFunction;
import com.googlecode.aviator.runtime.function.system.IsAFunction;
import com.googlecode.aviator.runtime.function.system.IsDefFunction;
import com.googlecode.aviator.runtime.function.system.LongFunction;
import com.googlecode.aviator.runtime.function.system.MaxFunction;
import com.googlecode.aviator.runtime.function.system.MinFunction;
import com.googlecode.aviator.runtime.function.system.NowFunction;
import com.googlecode.aviator.runtime.function.system.PrintFunction;
import com.googlecode.aviator.runtime.function.system.PrintlnFunction;
import com.googlecode.aviator.runtime.function.system.PstFunction;
import com.googlecode.aviator.runtime.function.system.RandomFunction;
import com.googlecode.aviator.runtime.function.system.RangeFunction;
import com.googlecode.aviator.runtime.function.system.SeqFunction;
import com.googlecode.aviator.runtime.function.system.StrFunction;
import com.googlecode.aviator.runtime.function.system.String2DateFunction;
import com.googlecode.aviator.runtime.function.system.SysDateFunction;
import com.googlecode.aviator.runtime.function.system.TupleFunction;
import com.googlecode.aviator.runtime.function.system.TypeFunction;
import com.googlecode.aviator.runtime.function.system.UndefFunction;
import com.googlecode.aviator.runtime.module.IoModule;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.string.ExpressionSegment;
import com.googlecode.aviator.runtime.type.string.LiteralSegment;
import com.googlecode.aviator.runtime.type.string.StringSegment;
import com.googlecode.aviator.runtime.type.string.VarSegment;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.LRUMap;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;

public final class AviatorEvaluatorInstance {
    private volatile AviatorClassLoader aviatorClassLoader = this.initAviatorClassLoader();
    private OutputStream traceOutputStream = System.out;
    private FunctionMissing functionMissing;
    private int bytecodeVersion = 51;
    private EnvProcessor envProcessor;
    private volatile Map<Options, Options.Value> options = new IdentityHashMap<Options, Options.Value>();
    private List<FunctionLoader> functionLoaders;
    private static final String[] libs = new String[]{"aviator.av"};
    private static volatile Map<String, AviatorFunction> internalLibFunctions;
    private final Map<String, Object> funcMap = new HashMap<String, Object>();
    private final ConcurrentHashMap<String, Object> moduleCache = new ConcurrentHashMap();
    private final Map<OperatorType, AviatorFunction> opsMap = new IdentityHashMap<OperatorType, AviatorFunction>();
    private final ConcurrentHashMap<String, FutureTask<Expression>> expressionCache = new ConcurrentHashMap();
    private LRUMap<String, FutureTask<Expression>> expressionLRUCache;

    public void addFunctionLoader(FunctionLoader loader) {
        if (this.functionLoaders == null) {
            this.functionLoaders = new ArrayList<FunctionLoader>();
        }
        this.functionLoaders.add(loader);
    }

    public EnvProcessor getEnvProcessor() {
        return this.envProcessor;
    }

    public void setEnvProcessor(EnvProcessor envProcessor) {
        this.envProcessor = envProcessor;
    }

    public Expression compileScript(String path, boolean cached) throws IOException {
        File file = this.tryFindScriptFile(path);
        return this.compileScript(file.getAbsolutePath(), file, cached);
    }

    /*
     * Exception decompiling
     */
    public Expression compileScript(String cacheKey, File file, boolean cached) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File tryFindScriptFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        file = this.tryFindFileFromClassLoader(path, contextLoader);
        if (file != null) {
            return file;
        }
        contextLoader = this.getClass().getClassLoader();
        file = this.tryFindFileFromClassLoader(path, contextLoader);
        if (file != null) {
            return file;
        }
        throw new FileNotFoundException("File not found: " + path);
    }

    public void setAviatorClassLoader(AviatorClassLoader aviatorClassLoader) {
        this.aviatorClassLoader = aviatorClassLoader;
    }

    private File tryFindFileFromClassLoader(String path, ClassLoader contextLoader) {
        URL url = contextLoader.getResource(path);
        if (url != null) {
            return new File(url.getPath());
        }
        if (!path.startsWith("/")) {
            url = contextLoader.getResource("/" + path);
        }
        return null;
    }

    public Map<String, Object> loadScript(String path) throws IOException {
        this.ensureFeatureEnabled(Feature.Module);
        File file = this.tryFindScriptFile(path);
        String abPath = file.getAbsolutePath();
        return this.loadScript0(abPath);
    }

    private Map<String, Object> loadScript0(String abPath) throws IOException {
        Expression exp = this.compileScript(abPath);
        return this.executeModule(exp, abPath);
    }

    private Map<String, Object> executeModule(Expression exp, String abPath) {
        Env exports = new Env();
        Map<String, Object> module = exp.newEnv("exports", exports, "path", abPath);
        Map<String, Object> env = exp.newEnv("__MODULE__", module, "exports", exports);
        exp.execute(env);
        exports.configure(this, exp);
        return (Map)module.get("exports");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> requireScript(String path) throws IOException {
        Env exports;
        this.ensureFeatureEnabled(Feature.Module);
        if (!path.endsWith(".av") && (exports = (Env)this.moduleCache.get(path)) != null) {
            return exports;
        }
        File file = this.tryFindScriptFile(path);
        String abPath = file.getAbsolutePath();
        Map<String, Object> exports2 = (Env)this.moduleCache.get(abPath);
        if (exports2 != null) {
            return exports2;
        }
        String string = abPath.intern();
        synchronized (string) {
            exports2 = (Env)this.moduleCache.get(abPath);
            if (exports2 != null) {
                return exports2;
            }
            exports2 = this.loadScript0(abPath);
            this.moduleCache.put(abPath, exports2);
            return exports2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Env addModule(Class<?> moduleClazz) throws NoSuchMethodException, IllegalAccessException {
        String namespace = moduleClazz.getSimpleName();
        Import importAnt = moduleClazz.getAnnotation(Import.class);
        if (importAnt != null && ((namespace = importAnt.ns()) == null || namespace.isEmpty() || !ExpressionParser.isJavaIdentifier(namespace))) {
            throw new IllegalArgumentException("Invalid namespace in Import annotation: " + namespace);
        }
        Env exports = null;
        String string = namespace.intern();
        synchronized (string) {
            exports = (Env)this.moduleCache.get(namespace);
            if (exports != null) {
                return exports;
            }
            exports = this.loadModule(moduleClazz);
            this.moduleCache.put(namespace, exports);
            return exports;
        }
    }

    public void removeModule(String ns) {
        this.moduleCache.remove(ns);
    }

    private Env loadModule(Class<?> moduleClazz) throws IllegalAccessException, NoSuchMethodException {
        Map<String, List<Method>> methodMap = this.findMethodsFromClass(moduleClazz, true);
        if (methodMap == null || methodMap.isEmpty()) {
            throw new IllegalArgumentException("Empty module");
        }
        Env exports = new Env();
        for (Map.Entry<String, List<Method>> entry : methodMap.entrySet()) {
            exports.put(entry.getKey(), (Object)new ClassMethodFunction(moduleClazz, true, entry.getKey(), entry.getKey(), entry.getValue()));
        }
        exports.setInstance(this);
        return exports;
    }

    public Map<String, Object> getModuleCache() {
        return this.moduleCache;
    }

    public Expression compileScript(String path) throws IOException {
        return this.compileScript(path, false);
    }

    public FunctionMissing getFunctionMissing() {
        return this.functionMissing;
    }

    public void setFunctionMissing(FunctionMissing functionMissing) {
        this.functionMissing = functionMissing;
    }

    public List<String> addInstanceFunctions(String namespace, Class<?> clazz) throws IllegalAccessException, NoSuchMethodException {
        return this.addMethodFunctions(namespace, false, clazz);
    }

    private List<String> addMethodFunctions(String namespace, boolean isStatic, Class<?> clazz) throws IllegalAccessException, NoSuchMethodException {
        Map<String, List<Method>> methodMap = this.findMethodsFromClass(clazz, isStatic);
        ArrayList<String> added = new ArrayList<String>();
        for (Map.Entry<String, List<Method>> entry : methodMap.entrySet()) {
            String methodName = entry.getKey();
            String name = namespace + "." + methodName;
            this.addFunction(new ClassMethodFunction(clazz, isStatic, name, methodName, entry.getValue()));
            added.add(name);
        }
        return added;
    }

    public List<String> addStaticFunctions(String namespace, Class<?> clazz) throws IllegalAccessException, NoSuchMethodException {
        return this.addMethodFunctions(namespace, true, clazz);
    }

    public List<String> importFunctions(Class<?> clazz) throws IllegalAccessException, NoSuchMethodException {
        String namespace = clazz.getSimpleName();
        ImportScope[] scopes = new ImportScope[]{ImportScope.Static, ImportScope.Instance};
        Import importAnt = clazz.getAnnotation(Import.class);
        if (importAnt != null) {
            namespace = importAnt.ns();
            if (namespace == null || namespace.isEmpty() || !ExpressionParser.isJavaIdentifier(namespace)) {
                throw new IllegalArgumentException("Invalid namespace in Import annotation: " + namespace);
            }
            scopes = importAnt.scopes();
            if (scopes == null || scopes.length == 0) {
                throw new IllegalArgumentException("Empty scopes in Import annotation");
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        block4: for (ImportScope scope : scopes) {
            switch (scope) {
                case Static: {
                    result.addAll(this.addStaticFunctions(namespace, clazz));
                    continue block4;
                }
                case Instance: {
                    result.addAll(this.addInstanceFunctions(namespace, clazz));
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Invalid import scope: " + (Object)((Object)scope));
                }
            }
        }
        return result;
    }

    private Map<String, List<Method>> findMethodsFromClass(Class<?> clazz, boolean isStatic) {
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        for (Method method : clazz.getMethods()) {
            ArrayList<Method> methods;
            String rename;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || (!isStatic ? Modifier.isStatic(modifiers) : !Modifier.isStatic(modifiers)) || method.getAnnotation(Ignore.class) != null) continue;
            String methodName = method.getName();
            Function func = method.getAnnotation(Function.class);
            if (func != null && !(rename = func.rename()).isEmpty()) {
                if (!ExpressionParser.isJavaIdentifier(rename)) {
                    throw new IllegalArgumentException("Invalid rename `" + rename + "` for method " + method.getName() + " in class " + clazz);
                }
                methodName = func.rename();
            }
            if ((methods = (ArrayList<Method>)methodMap.get(methodName)) == null) {
                methods = new ArrayList<Method>(3);
                methodMap.put(methodName, methods);
            }
            methods.add(method);
        }
        return methodMap;
    }

    public void removeFunctionLoader(FunctionLoader loader) {
        if (this.functionLoaders == null) {
            return;
        }
        this.functionLoaders.remove(loader);
    }

    public void setOption(Options opt, Object val) {
        Set newSet;
        HashSet<Feature> oldSet;
        if (opt == null || val == null) {
            throw new IllegalArgumentException("Option and value should not be null.");
        }
        if (!opt.isValidValue(val)) {
            throw new IllegalArgumentException("Invalid value for option:" + opt.name());
        }
        IdentityHashMap<Options, Options.Value> newOpts = new IdentityHashMap<Options, Options.Value>(this.options);
        newOpts.put(opt, opt.intoValue(val));
        if (opt == Options.FEATURE_SET && (oldSet = new HashSet<Feature>(this.getFeatures())).removeAll(newSet = (Set)val)) {
            for (Feature feat : oldSet) {
                for (AviatorFunction fn : feat.getFunctions()) {
                    this.removeFunction(fn);
                }
            }
        }
        this.options = newOpts;
        if (opt == Options.FEATURE_SET) {
            this.loadFeatureFunctions();
        }
    }

    public void enableFeature(Feature feature) {
        this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet.add(feature);
        this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet.addAll(feature.getPrequires());
        this.loadFeatureFunctions();
    }

    public Set<Feature> getFeatures() {
        return this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet;
    }

    public boolean isFeatureEnabled(Feature feature) {
        return this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet.contains((Object)feature);
    }

    public void disableFeature(Feature feature) {
        this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet.remove((Object)feature);
        for (AviatorFunction fn : feature.getFunctions()) {
            this.removeFunction(fn);
        }
        this.loadFeatureFunctions();
    }

    @Deprecated
    public <T> T getOption(Options opt) {
        Options.Value val = this.options.get((Object)opt);
        if (val == null) {
            val = opt.getDefaultValueObject();
        }
        return (T)opt.intoObject(val);
    }

    public Options.Value getOptionValue(Options opt) {
        Options.Value val = this.options.get((Object)opt);
        assert (val != null);
        return val;
    }

    public int getBytecodeVersion() {
        return this.bytecodeVersion;
    }

    public void setBytecodeVersion(int bytecodeVersion) {
        this.bytecodeVersion = bytecodeVersion;
    }

    public Map<Options, Object> getOptions() {
        HashMap<Options, Object> ret = new HashMap<Options, Object>();
        for (Map.Entry<Options, Options.Value> entry : this.options.entrySet()) {
            ret.put(entry.getKey(), entry.getKey().intoObject(entry.getValue()));
        }
        return ret;
    }

    public Map<String, Object> getFuncMap() {
        return this.funcMap;
    }

    public Map<OperatorType, AviatorFunction> getOpsMap() {
        return this.opsMap;
    }

    public OutputStream getTraceOutputStream() {
        return this.traceOutputStream;
    }

    public void setTraceOutputStream(OutputStream traceOutputStream) {
        this.traceOutputStream = traceOutputStream;
    }

    private AviatorClassLoader initAviatorClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<AviatorClassLoader>(){

            @Override
            public AviatorClassLoader run() {
                return new AviatorClassLoader(AviatorEvaluatorInstance.class.getClassLoader());
            }
        });
    }

    private void loadModule() {
        try {
            this.addModule(IoModule.class);
        }
        catch (Exception e) {
            System.err.println("Fail to load internal modules.");
            System.exit(1);
        }
    }

    public void aliasFunction(String name, String aliasName) {
        this.addFunction(aliasName, this.getFunction(name));
    }

    private void loadLib() {
        this.loadSystemFunctions();
        this.loadStringFunctions();
        this.loadMathFunctions();
        this.loadSeqFunctions();
        this.aliasFunction("println", "p");
        this.aliasFunction("pst", "printStackTrace");
        this.loadInternalLibs();
    }

    private void loadSeqFunctions() {
        this.addFunction(SeqCollectorFunction.INSTANCE);
        this.addFunction(SeqCollectorRawFunction.INSTANCE);
        this.addFunction(SeqKeysFunction.INSTANCE);
        this.addFunction(SeqValsFunction.INSTANCE);
        this.addFunction(SeqReverseFunction.INSTANCE);
        this.addFunction(SeqZipmapFunction.INSTANCE);
        this.addFunction(new SeqNewArrayFunction());
        this.addFunction(new SeqArrayFunction());
        this.addFunction(new SeqNewListFunction());
        this.addFunction(new SeqNewMapFunction());
        this.addFunction(new SeqNewSetFunction());
        this.addFunction(new SeqMapEntryFunction());
        this.addFunction(new SeqIntoFunction());
        this.addFunction(new SeqAddFunction());
        this.addFunction(new SeqRemoveFunction());
        this.addFunction(new SeqGetFunction());
        this.addFunction(new SeqPutFunction());
        this.addFunction(new SeqMinFunction());
        this.addFunction(new SeqMaxFunction());
        this.addFunction(new SeqMapFunction());
        this.addFunction(new SeqReduceFunction());
        this.addFunction(new SeqFilterFunction());
        this.addFunction(new SeqSortFunction());
        this.addFunction(new SeqIncludeFunction());
        this.addFunction(new SeqContainsKeyFunction());
        this.addFunction(new SeqCountFunction());
        this.addFunction(new SeqEveryFunction());
        this.addFunction(new SeqNotAnyFunction());
        this.addFunction(new SeqSomeFunction());
        this.addFunction(new SeqMakePredicateFunFunction("seq.eq", OperatorType.EQ));
        this.addFunction(new SeqMakePredicateFunFunction("seq.neq", OperatorType.NEQ));
        this.addFunction(new SeqMakePredicateFunFunction("seq.lt", OperatorType.LT));
        this.addFunction(new SeqMakePredicateFunFunction("seq.le", OperatorType.LE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.gt", OperatorType.GT));
        this.addFunction(new SeqMakePredicateFunFunction("seq.ge", OperatorType.GE));
        this.addFunction(new SeqCompsitePredFunFunction("seq.and", SeqCompsitePredFunFunction.LogicOp.AND));
        this.addFunction(new SeqCompsitePredFunFunction("seq.or", SeqCompsitePredFunFunction.LogicOp.OR));
        this.addFunction(new SeqMakePredicateFunFunction("seq.true", OperatorType.EQ, AviatorBoolean.TRUE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.false", OperatorType.EQ, AviatorBoolean.FALSE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.nil", OperatorType.EQ, AviatorNil.NIL));
        this.addFunction(new SeqMakePredicateFunFunction("seq.exists", OperatorType.NEQ, AviatorNil.NIL));
    }

    private void loadMathFunctions() {
        this.addFunction(new MathAbsFunction());
        this.addFunction(new MathRoundFunction());
        this.addFunction(new MathPowFunction());
        this.addFunction(new MathSqrtFunction());
        this.addFunction(new MathLog10Function());
        this.addFunction(new MathLogFunction());
        this.addFunction(new MathSinFunction());
        this.addFunction(new MathCosFunction());
        this.addFunction(new MathTanFunction());
        this.addFunction(MathAsinFunction.INSTANCE);
        this.addFunction(MathAcosFunction.INSTANCE);
        this.addFunction(MathAtanFunction.INSTANCE);
        this.addFunction(MathFloorFunction.INSTANCE);
        this.addFunction(MathCeilFunction.INSTANCE);
    }

    private void loadStringFunctions() {
        this.addFunction(new StringContainsFunction());
        this.addFunction(new StringIndexOfFunction());
        this.addFunction(new StringStartsWithFunction());
        this.addFunction(new StringEndsWithFunction());
        this.addFunction(new StringSubStringFunction());
        this.addFunction(new StringLengthFunction());
        this.addFunction(new StringSplitFunction());
        this.addFunction(new StringJoinFunction());
        this.addFunction(new StringReplaceFirstFunction());
        this.addFunction(new StringReplaceAllFunction());
    }

    private void loadSystemFunctions() {
        this.addFunction(ComparatorFunction.INSTANCE);
        this.addFunction(new CompareFunction());
        this.addFunction(new SysDateFunction());
        this.addFunction(new PrintlnFunction());
        this.addFunction(new PrintFunction());
        this.addFunction(new PstFunction());
        this.addFunction(new RandomFunction());
        this.addFunction(new NowFunction());
        this.addFunction(new LongFunction());
        this.addFunction(new BooleanFunction());
        this.addFunction(new DoubleFunction());
        this.addFunction(new StrFunction());
        this.addFunction(new BigIntFunction());
        this.addFunction(new DecimalFunction());
        this.addFunction(new Date2StringFunction());
        this.addFunction(new String2DateFunction());
        this.addFunction(new BinaryFunction(OperatorType.ADD));
        this.addFunction(new BinaryFunction(OperatorType.Exponent));
        this.addFunction(new BinaryFunction(OperatorType.SUB));
        this.addFunction(new BinaryFunction(OperatorType.MULT));
        this.addFunction(new BinaryFunction(OperatorType.DIV));
        this.addFunction(new BinaryFunction(OperatorType.MOD));
        this.addFunction(new BinaryFunction(OperatorType.NEG));
        this.addFunction(new BinaryFunction(OperatorType.NOT));
        this.addFunction(new BinaryFunction(OperatorType.BIT_AND));
        this.addFunction(new BinaryFunction(OperatorType.BIT_OR));
        this.addFunction(new BinaryFunction(OperatorType.BIT_XOR));
        this.addFunction(new BinaryFunction(OperatorType.BIT_NOT));
        this.addFunction(new TupleFunction());
        this.addFunction(new MinFunction());
        this.addFunction(new MaxFunction());
        this.addFunction(new IdentityFunction());
        this.addFunction(new AssertFunction());
        this.addFunction(new RangeFunction());
        this.addFunction(new IsDefFunction());
        this.addFunction(new UndefFunction());
        this.addFunction(new TypeFunction());
        this.addFunction(SeqFunction.INSTANCE);
        this.addFunction(EvalFunction.INSTANCE);
        this.addFunction(IsAFunction.INSTANCE);
    }

    private void loadInternalLibs() {
        if (internalLibFunctions == null) {
            HashMap<String, AviatorFunction> funcs = new HashMap<String, AviatorFunction>();
            for (String lib : libs) {
                try (InputStream in = this.getClass().getResourceAsStream("/" + lib);
                     BufferedInputStream bis = new BufferedInputStream(in);
                     InputStreamReader reader = new InputStreamReader(bis);){
                    Expression exp = this.compile(lib, Utils.readFully(reader), false);
                    Map<String, Object> exports = this.executeModule(exp, lib);
                    for (Map.Entry<String, Object> entry : exports.entrySet()) {
                        if (!(entry.getValue() instanceof AviatorFunction)) continue;
                        AviatorFunction fn = (AviatorFunction)entry.getValue();
                        this.addFunction(entry.getKey(), fn);
                        funcs.put(entry.getKey(), fn);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to load internal lib: " + lib, e);
                }
            }
            internalLibFunctions = funcs;
        } else {
            for (Map.Entry<String, AviatorFunction> entry : internalLibFunctions.entrySet()) {
                this.addFunction(entry.getKey(), entry.getValue());
            }
        }
    }

    AviatorEvaluatorInstance() {
        this.fillDefaultOpts();
        this.loadFeatureFunctions();
        this.loadLib();
        this.loadModule();
        this.addFunctionLoader(ClassPathConfigFunctionLoader.getInstance());
    }

    private void fillDefaultOpts() {
        for (Options opt : Options.values()) {
            this.options.put(opt, opt.getDefaultValueObject());
        }
    }

    private void loadFeatureFunctions() {
        for (Feature feat : this.options.get((Object)((Object)Options.FEATURE_SET)).featureSet) {
            for (AviatorFunction fn : feat.getFunctions()) {
                if (this.containsFunction(fn.getName())) continue;
                this.addFunction(fn);
            }
        }
    }

    public AviatorEvaluatorInstance useLRUExpressionCache(int capacity) {
        this.expressionLRUCache = new LRUMap(capacity);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpressionCache() {
        this.resetClassLoader();
        if (this.expressionLRUCache != null) {
            LRUMap<String, FutureTask<Expression>> lRUMap = this.expressionLRUCache;
            synchronized (lRUMap) {
                this.expressionLRUCache.clear();
            }
        } else {
            this.expressionCache.clear();
        }
    }

    public void resetClassLoader() {
        this.aviatorClassLoader = this.initAviatorClassLoader();
    }

    public AviatorClassLoader getAviatorClassLoader() {
        return this.getAviatorClassLoader(false);
    }

    public AviatorClassLoader getAviatorClassLoader(boolean cached) {
        if (cached) {
            return this.aviatorClassLoader;
        }
        return new AviatorClassLoader(this.getClass().getClassLoader());
    }

    public void addFunction(AviatorFunction function) {
        this.addFunction(function.getName(), function);
    }

    public void addFunction(String name, AviatorFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("Null function");
        }
        if (SymbolTable.isReservedKeyword(name)) {
            throw new IllegalArgumentException("Invalid function name, lambda is a keyword.");
        }
        if (this.funcMap.containsKey(name)) {
            System.out.println("[Aviator WARN] The function '" + name + "' is already exists, but is replaced with new one.");
        }
        this.funcMap.put(name, function);
    }

    public void defineFunction(String name, String expression) {
        this.defineFunction(name, expression, null);
    }

    public void defineFunction(String name, String expression, Map<String, Object> env) {
        AviatorFunction function = (AviatorFunction)this.execute(expression, env);
        this.addFunction(name, function);
    }

    public AviatorFunction removeFunction(String name) {
        return (AviatorFunction)this.funcMap.remove(name);
    }

    public AviatorFunction getFunction(String name) {
        return this.getFunction(name, null);
    }

    public AviatorFunction getFunction(String name, SymbolTable symbolTable) {
        AviatorFunction function = (AviatorFunction)this.funcMap.get(name);
        if (function == null && this.functionLoaders != null) {
            for (FunctionLoader loader : this.functionLoaders) {
                if (loader != null) {
                    function = loader.onFunctionNotFound(name);
                }
                if (function == null) continue;
                break;
            }
        }
        if (function == null) {
            function = new RuntimeFunctionDelegator(name, symbolTable, this.functionMissing);
        }
        return function;
    }

    public void addOpFunction(OperatorType opType, AviatorFunction function) {
        this.opsMap.put(opType, function);
    }

    public AviatorFunction getOpFunction(OperatorType opType) {
        return this.opsMap.get((Object)opType);
    }

    public AviatorFunction removeOpFunction(OperatorType opType) {
        return this.opsMap.remove((Object)opType);
    }

    public boolean containsFunction(String name) {
        return this.funcMap.containsKey(name);
    }

    public AviatorFunction removeFunction(AviatorFunction function) {
        return this.removeFunction(function.getName());
    }

    public Expression getCachedExpression(String expression) {
        return this.getCachedExpressionByKey(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCachedExpressionByKey(String cacheKey) {
        FutureTask<Expression> task = null;
        if (this.expressionLRUCache != null) {
            LRUMap<String, FutureTask<Expression>> lRUMap = this.expressionLRUCache;
            synchronized (lRUMap) {
                task = this.expressionLRUCache.get(cacheKey);
            }
        } else {
            task = this.expressionCache.get(cacheKey);
        }
        if (task != null) {
            return this.getCompiledExpression(cacheKey, task);
        }
        return null;
    }

    public boolean isExpressionCached(String expression) {
        return this.getCachedExpression(expression) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpressionCacheSize() {
        if (this.expressionLRUCache != null) {
            LRUMap<String, FutureTask<Expression>> lRUMap = this.expressionLRUCache;
            synchronized (lRUMap) {
                return this.expressionLRUCache.size();
            }
        }
        return this.expressionCache.size();
    }

    public Expression compile(String expression, boolean cached) {
        return this.compile(expression, expression, cached);
    }

    public Expression compile(String cacheKey, String expression, boolean cached) {
        return this.compile(cacheKey, expression, null, cached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression compile(String cacheKey, String expression, String sourceFile, boolean cached) {
        if (expression == null || expression.trim().length() == 0) {
            throw new CompileExpressionErrorException("Blank expression");
        }
        if (cacheKey == null || cacheKey.trim().length() == 0) {
            throw new CompileExpressionErrorException("Blank cacheKey");
        }
        if (cached) {
            FutureTask<Expression> existedTask = null;
            if (this.expressionLRUCache != null) {
                boolean runTask = false;
                LRUMap<String, FutureTask<Expression>> lRUMap = this.expressionLRUCache;
                synchronized (lRUMap) {
                    existedTask = this.expressionLRUCache.get(cacheKey);
                    if (existedTask == null) {
                        existedTask = this.newCompileTask(expression, sourceFile, cached);
                        runTask = true;
                        this.expressionLRUCache.put(cacheKey, existedTask);
                    }
                }
                if (runTask) {
                    existedTask.run();
                }
            } else {
                FutureTask<Expression> task = this.expressionCache.get(cacheKey);
                if (task != null) {
                    return this.getCompiledExpression(expression, task);
                }
                task = this.newCompileTask(expression, sourceFile, cached);
                existedTask = this.expressionCache.putIfAbsent(cacheKey, task);
                if (existedTask == null) {
                    existedTask = task;
                    existedTask.run();
                }
            }
            return this.getCompiledExpression(cacheKey, existedTask);
        }
        return this.innerCompile(expression, sourceFile, cached);
    }

    private FutureTask<Expression> newCompileTask(final String expression, final String sourceFile, final boolean cached) {
        return new FutureTask<Expression>(new Callable<Expression>(){

            @Override
            public Expression call() throws Exception {
                return AviatorEvaluatorInstance.this.innerCompile(expression, sourceFile, cached);
            }
        });
    }

    private Expression getCompiledExpression(String cacheKey, FutureTask<Expression> task) {
        try {
            return task.get();
        }
        catch (Throwable t) {
            this.invalidateCacheByKey(cacheKey);
            Throwable cause = t.getCause();
            if (cause instanceof ExpressionSyntaxErrorException || cause instanceof CompileExpressionErrorException) {
                throw Reflector.sneakyThrow(cause);
            }
            throw new CompileExpressionErrorException("Compile expression failure, cacheKey=" + cacheKey, t);
        }
    }

    private Expression innerCompile(String expression, String sourceFile, boolean cached) {
        ExpressionLexer lexer = new ExpressionLexer(this, expression);
        CodeGenerator codeGenerator = this.newCodeGenerator(sourceFile, cached);
        ExpressionParser parser = new ExpressionParser(this, lexer, codeGenerator);
        Expression exp = parser.parse();
        if (this.getOptionValue((Options)Options.TRACE_EVAL).bool) {
            ((BaseExpression)exp).setExpression(expression);
        }
        return exp;
    }

    private int getOptimizeLevel() {
        return this.getOptionValue((Options)Options.OPTIMIZE_LEVEL).number;
    }

    public CodeGenerator newCodeGenerator(String sourceFile, boolean cached) {
        AviatorClassLoader classLoader = this.getAviatorClassLoader(cached);
        return this.newCodeGenerator(classLoader, sourceFile);
    }

    public CodeGenerator newCodeGenerator(AviatorClassLoader classLoader, String sourceFile) {
        switch (this.getOptimizeLevel()) {
            case 0: {
                ASMCodeGenerator asmCodeGenerator = new ASMCodeGenerator(this, sourceFile, classLoader, this.traceOutputStream);
                asmCodeGenerator.start();
                return asmCodeGenerator;
            }
            case 1: {
                return new OptimizeCodeGenerator(this, sourceFile, classLoader, this.traceOutputStream);
            }
        }
        throw new IllegalArgumentException("Unknow option " + this.getOptimizeLevel());
    }

    public Expression compile(String expression) {
        return this.compile(expression, false);
    }

    public void validate(String script) {
        if (script == null || script.trim().length() == 0) {
            throw new CompileExpressionErrorException("Blank script");
        }
        ExpressionLexer lexer = new ExpressionLexer(this, script);
        NoneCodeGenerator codeGenerator = new NoneCodeGenerator();
        ExpressionParser parser = new ExpressionParser(this, lexer, codeGenerator);
        parser.parse();
    }

    @Deprecated
    public Object exec(String expression, Object ... values) {
        if (this.getOptimizeLevel() != 1) {
            throw new IllegalStateException("Aviator evaluator is not in EVAL mode.");
        }
        Expression compiledExpression = this.compile(expression, true);
        if (compiledExpression != null) {
            List<String> vars = compiledExpression.getVariableNames();
            if (!vars.isEmpty()) {
                int valLen;
                int n = valLen = values == null ? 0 : values.length;
                if (valLen != vars.size()) {
                    throw new IllegalArgumentException("Expect " + vars.size() + " values,but has " + valLen);
                }
                HashMap<String, Object> env = new HashMap<String, Object>();
                int i = 0;
                for (String var : vars) {
                    env.put(var, values[i++]);
                }
                return compiledExpression.execute(env);
            }
            return compiledExpression.execute();
        }
        throw new ExpressionNotFoundException("Null compiled expression for " + expression);
    }

    public Object execute(String expression, Map<String, Object> env, boolean cached) {
        Expression compiledExpression = this.compile(expression, cached);
        if (compiledExpression != null) {
            return compiledExpression.execute(env);
        }
        throw new ExpressionNotFoundException("Null compiled expression for " + expression);
    }

    public Object execute(String expression, Map<String, Object> env) {
        return this.execute(expression, env, false);
    }

    public void invalidateCache(String expression) {
        this.invalidateCacheByKey(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheByKey(String cacheKey) {
        if (this.expressionLRUCache != null) {
            LRUMap<String, FutureTask<Expression>> lRUMap = this.expressionLRUCache;
            synchronized (lRUMap) {
                this.expressionLRUCache.remove(cacheKey);
            }
        } else {
            this.expressionCache.remove(cacheKey);
        }
    }

    public Object execute(String expression) {
        return this.execute(expression, null);
    }

    public void ensureFeatureEnabled(Feature feature) {
        if (!this.getOptionValue((Options)Options.FEATURE_SET).featureSet.contains((Object)feature)) {
            throw new UnsupportedFeatureException(feature);
        }
    }

    public StringSegments compileStringSegments(String lexeme) {
        ArrayList<StringSegment> segs = new ArrayList<StringSegment>();
        boolean hasInterpolationOrEscaped = false;
        StringCharacterIterator it = new StringCharacterIterator(lexeme);
        char ch = it.current();
        int prev = 65535;
        int lastInterPos = 0;
        int i = 1;
        while (true) {
            String segStr;
            if (ch == '#') {
                if (prev == 92) {
                    segStr = lexeme.substring(lastInterPos, i - 2);
                    segs.add(new LiteralSegment(segStr));
                    lastInterPos = i - 1;
                    hasInterpolationOrEscaped = true;
                } else {
                    prev = ch;
                    ch = it.next();
                    ++i;
                    if (ch == '{') {
                        if (i - 2 > lastInterPos) {
                            segStr = lexeme.substring(lastInterPos, i - 2);
                            segs.add(new LiteralSegment(segStr));
                        }
                        try {
                            ExpressionLexer lexer = new ExpressionLexer(this, lexeme.substring(i));
                            ExpressionParser parser = new ExpressionParser(this, lexer, this.newCodeGenerator(null, false));
                            Expression exp = parser.parse(false);
                            Token<?> lookhead = parser.getLookhead();
                            if (lookhead == null || lookhead.getType() != Token.TokenType.Char || ((CharToken)lookhead).getCh() != '}') {
                                parser.reportSyntaxError("expect '}' to complete string interpolation");
                            }
                            int expStrLen = lookhead.getStartIndex() + 1;
                            while (expStrLen-- > 0) {
                                prev = ch;
                                ch = it.next();
                                ++i;
                            }
                            Token<?> previousToken = null;
                            if (parser.getParsedTokens() == 2 && (previousToken = parser.getPrevToken()) != null && previousToken.getType() == Token.TokenType.Variable) {
                                if (previousToken == Variable.TRUE) {
                                    segs.add(new LiteralSegment("true"));
                                } else if (previousToken == Variable.FALSE) {
                                    segs.add(new LiteralSegment("false"));
                                } else if (previousToken == Variable.NIL) {
                                    segs.add(new LiteralSegment("null"));
                                } else {
                                    segs.add(new VarSegment(parser.getSymbolTable().reserve(previousToken.getLexeme()).getLexeme()));
                                }
                            } else {
                                segs.add(new ExpressionSegment(exp));
                            }
                            hasInterpolationOrEscaped = true;
                            lastInterPos = i;
                        }
                        catch (Throwable t) {
                            throw new CompileExpressionErrorException("Fail to compile string interpolation: " + lexeme, t);
                        }
                    }
                }
            }
            if (ch == '\uffff') {
                if (i - 1 <= lastInterPos) break;
                segStr = lexeme.substring(lastInterPos, i - 1);
                segs.add(new LiteralSegment(segStr));
                break;
            }
            prev = ch;
            ch = it.next();
            ++i;
        }
        if (hasInterpolationOrEscaped) {
            return new StringSegments(segs, lexeme.length() * 2 / 3);
        }
        return new StringSegments(Collections.emptyList(), 0);
    }

    public static class StringSegments {
        public final List<StringSegment> segs;
        public int hintLength;

        public StringSegments(List<StringSegment> segs, int hintLength) {
            this.segs = segs;
            this.hintLength = hintLength;
        }

        public boolean isEmpty() {
            return this.segs.isEmpty();
        }

        public String toString(Map<String, Object> env, String lexeme) {
            if (this.segs.isEmpty()) {
                return lexeme;
            }
            StringBuilder sb = new StringBuilder(this.hintLength);
            int size = this.segs.size();
            for (int i = 0; i < size; ++i) {
                this.segs.get(i).appendTo(sb, env);
            }
            String result = sb.toString();
            int newLen = result.length();
            if (newLen > this.hintLength && newLen < 10 * this.hintLength) {
                this.hintLength = newLen;
            }
            return result;
        }
    }
}

