/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Map;

public class AviatorLong
extends AviatorNumber {
    public AviatorLong(Number number) {
        super(number);
    }

    public static AviatorLong valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new AviatorLong(l);
    }

    public static AviatorLong valueOf(Long l) {
        return AviatorLong.valueOf((long)l);
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return AviatorLong.valueOf(-this.number.longValue());
    }

    @Override
    public int innerCompare(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return this.toBigInt().compareTo(other.toBigInt());
            }
            case Decimal: {
                return this.toDecimal(env).compareTo(other.toDecimal(env));
            }
            case Long: {
                return TypeUtils.comapreLong(this.longValue(), other.longValue());
            }
            case Double: {
                return Double.compare(this.number.doubleValue(), other.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
    }

    @Override
    public AviatorObject innerDiv(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return AviatorBigInt.valueOf(this.toBigInt().divide(other.toBigInt()));
            }
            case Decimal: {
                return AviatorDecimal.valueOf(this.toDecimal(env).divide(other.toDecimal(env), RuntimeUtils.getMathContext(env)));
            }
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() / other.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() / other.doubleValue());
    }

    @Override
    public AviatorObject innerAdd(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return AviatorBigInt.valueOf(this.toBigInt().add(other.toBigInt()));
            }
            case Decimal: {
                return AviatorDecimal.valueOf(this.toDecimal(env).add(other.toDecimal(env), RuntimeUtils.getMathContext(env)));
            }
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() + other.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() + other.doubleValue());
    }

    @Override
    public AviatorObject innerMod(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return AviatorBigInt.valueOf(this.toBigInt().mod(other.toBigInt()));
            }
            case Decimal: {
                return AviatorDecimal.valueOf(this.toDecimal(env).remainder(other.toDecimal(env), RuntimeUtils.getMathContext(env)));
            }
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() % other.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() % other.doubleValue());
    }

    @Override
    public AviatorObject innerMult(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return AviatorBigInt.valueOf(this.toBigInt().multiply(other.toBigInt()));
            }
            case Decimal: {
                return AviatorDecimal.valueOf(this.toDecimal(env).multiply(other.toDecimal(env), RuntimeUtils.getMathContext(env)));
            }
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() * other.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() * other.doubleValue());
    }

    protected void ensureLong(AviatorObject other) {
        if (other.getAviatorType() != AviatorType.Long) {
            throw new ExpressionRuntimeException(other + " is not long type,could not be used as a bit operand.");
        }
    }

    @Override
    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerBitAnd(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitAnd(AviatorNumber.valueOf(otherValue));
                }
                return super.bitAnd(other, env);
            }
        }
        return super.bitAnd(other, env);
    }

    protected AviatorObject innerBitAnd(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() & otherLong.longValue());
    }

    protected AviatorObject innerBitOr(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() | otherLong.longValue());
    }

    protected AviatorObject innerBitXor(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() ^ otherLong.longValue());
    }

    protected AviatorObject innerShiftLeft(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() << (int)otherLong.longValue());
    }

    protected AviatorObject innerShiftRight(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() >> (int)otherLong.longValue());
    }

    protected AviatorObject innerUnsignedShiftRight(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() >>> (int)otherLong.longValue());
    }

    @Override
    public AviatorObject bitNot(Map<String, Object> env) {
        return AviatorLong.valueOf(this.number.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerBitOr(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitOr(AviatorNumber.valueOf(otherValue));
                }
                return super.bitOr(other, env);
            }
        }
        return super.bitOr(other, env);
    }

    @Override
    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerBitXor(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitXor(AviatorNumber.valueOf(otherValue));
                }
                return super.bitXor(other, env);
            }
        }
        return super.bitXor(other, env);
    }

    @Override
    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerShiftLeft(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerShiftLeft(AviatorNumber.valueOf(otherValue));
                }
                return super.shiftLeft(other, env);
            }
        }
        return super.shiftLeft(other, env);
    }

    @Override
    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerShiftRight(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerShiftRight(AviatorNumber.valueOf(otherValue));
                }
                return super.shiftRight(other, env);
            }
        }
        return super.shiftRight(other, env);
    }

    @Override
    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case BigInt: 
            case Decimal: 
            case Long: 
            case Double: {
                return this.innerUnsignedShiftRight(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerUnsignedShiftRight(AviatorNumber.valueOf(otherValue));
                }
                return super.unsignedShiftRight(other, env);
            }
        }
        return super.unsignedShiftRight(other, env);
    }

    @Override
    public AviatorObject innerSub(Map<String, Object> env, AviatorNumber other) {
        switch (other.getAviatorType()) {
            case BigInt: {
                return AviatorBigInt.valueOf(this.toBigInt().subtract(other.toBigInt()));
            }
            case Decimal: {
                return AviatorDecimal.valueOf(this.toDecimal(env).subtract(other.toDecimal(env), RuntimeUtils.getMathContext(env)));
            }
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() - other.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() - other.doubleValue());
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Long;
    }

    private static class LongCache {
        static final AviatorLong[] cache = new AviatorLong[256];

        private LongCache() {
        }

        static {
            for (long i = 0L; i < (long)cache.length; ++i) {
                LongCache.cache[(int)i] = new AviatorLong(i - 128L);
            }
        }
    }
}

