/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class LongFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        switch (arg1.getAviatorType()) {
            case Boolean: {
                return AviatorLong.valueOf(arg1.booleanValue(env) ? 1L : 0L);
            }
            case JavaType: {
                Object obj = arg1.getValue(env);
                if (obj instanceof Number) {
                    return AviatorLong.valueOf(((Number)obj).longValue());
                }
                if (obj instanceof String) {
                    return AviatorLong.valueOf(Long.valueOf((String)obj));
                }
                if (obj instanceof Character) {
                    return AviatorLong.valueOf(Long.valueOf(String.valueOf(obj)));
                }
                throw new ClassCastException("Could not cast " + obj.getClass().getName() + " to long");
            }
            case String: {
                return AviatorLong.valueOf(Long.valueOf((String)arg1.getValue(env)));
            }
            case Long: 
            case Double: {
                return AviatorLong.valueOf(((Number)arg1.getValue(env)).longValue());
            }
        }
        throw new ClassCastException("Could not cast " + arg1 + " to long");
    }

    @Override
    public String getName() {
        return "long";
    }
}

