/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.parser;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.DelegateToken;
import com.googlecode.aviator.lexer.token.PatternToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.DepthState;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.parser.ScopeInfo;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ExpressionParser
implements Parser {
    private final ExpressionLexer lexer;
    static final Set<String> RESERVED_WORDS = new HashSet<String>();
    private Token<?> lookhead;
    private Token<?> prevToken;
    private CodeGenerator codeGenerator;
    private int parenDepth = 0;
    private int bracketDepth = 0;
    private int lambdaDepth = 0;
    private LinkedList<DepthState> depthState = new LinkedList();
    private boolean inPattern = false;
    private AviatorEvaluatorInstance instance;
    public static final CharToken LEFT_PAREN;
    public static final CharToken RIGHT_PAREN;

    @Override
    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @Override
    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    @Override
    public ScopeInfo enterScope() {
        ScopeInfo info = new ScopeInfo(this.parenDepth, this.bracketDepth, this.lambdaDepth, this.depthState);
        this.parenDepth = 0;
        this.bracketDepth = 0;
        this.lambdaDepth = 0;
        this.depthState = new LinkedList();
        return info;
    }

    @Override
    public void restoreScope(ScopeInfo info) {
        this.parenDepth = info.parenDepth;
        this.bracketDepth = info.bracketDepth;
        this.lambdaDepth = info.lambdaDepth;
        this.depthState = info.depthState;
    }

    public ExpressionParser(AviatorEvaluatorInstance instance, ExpressionLexer lexer, CodeGenerator codeGenerator) {
        this.instance = instance;
        this.lexer = lexer;
        this.lookhead = this.lexer.scan();
        if (this.lookhead == null) {
            throw new ExpressionSyntaxErrorException("Blank expression");
        }
        this.codeGenerator = codeGenerator;
        this.codeGenerator.setParser(this);
    }

    public void ternary() {
        this.join();
        if (this.lookhead == null || this.expectChar(':') || this.expectChar(',')) {
            return;
        }
        if (this.expectChar('?')) {
            this.move(true);
            this.codeGenerator.onTernaryBoolean(this.lookhead);
            this.ternary();
            if (this.expectChar(':')) {
                this.move(true);
                this.codeGenerator.onTernaryLeft(this.lookhead);
                this.ternary();
                this.codeGenerator.onTernaryRight(this.lookhead);
            } else {
                this.reportSyntaxError("expect ':'");
            }
        }
    }

    public void join() {
        this.and();
        while (this.isJoinToken()) {
            this.codeGenerator.onJoinLeft(this.lookhead);
            this.move(true);
            if (this.isJoinToken()) {
                this.move(true);
                this.and();
                this.codeGenerator.onJoinRight(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '|'");
        }
        if (this.lookhead != null) {
            // empty if block
        }
    }

    private boolean isJoinToken() {
        return this.expectChar('|');
    }

    private boolean expectChar(char ch) {
        if (this.lookhead == null) {
            return false;
        }
        return this.lookhead.getType() == Token.TokenType.Char && ((CharToken)this.lookhead).getCh() == ch;
    }

    private boolean isAndToken() {
        return this.expectChar('&');
    }

    public void bitOr() {
        this.xor();
        while (this.isJoinToken()) {
            this.move(true);
            if (this.isJoinToken()) {
                this.back();
                break;
            }
            this.xor();
            this.codeGenerator.onBitOr(this.lookhead);
        }
    }

    public void xor() {
        this.bitAnd();
        while (this.expectChar('^')) {
            this.move(true);
            this.bitAnd();
            this.codeGenerator.onBitXor(this.lookhead);
        }
    }

    public void bitAnd() {
        this.equality();
        while (this.isAndToken()) {
            this.move(true);
            if (this.isAndToken()) {
                this.back();
                break;
            }
            this.equality();
            this.codeGenerator.onBitAnd(this.lookhead);
        }
    }

    public void and() {
        this.bitOr();
        while (this.isAndToken()) {
            this.codeGenerator.onAndLeft(this.lookhead);
            this.move(true);
            if (this.isAndToken()) {
                this.move(true);
                this.bitOr();
                this.codeGenerator.onAndRight(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '&'");
        }
    }

    public void equality() {
        this.rel();
        while (true) {
            if (this.expectChar('=')) {
                this.move(true);
                if (this.expectChar('=')) {
                    this.move(true);
                    this.rel();
                    this.codeGenerator.onEq(this.lookhead);
                    continue;
                }
                if (this.expectChar('~')) {
                    this.move(true);
                    this.rel();
                    this.codeGenerator.onMatch(this.lookhead);
                    continue;
                }
                this.reportSyntaxError("Aviator doesn't support assignment");
                continue;
            }
            if (!this.expectChar('!')) break;
            this.move(true);
            if (this.expectChar('=')) {
                this.move(true);
                this.rel();
                this.codeGenerator.onNeq(this.lookhead);
                continue;
            }
            this.reportSyntaxError("expect '='");
        }
    }

    public void rel() {
        this.shift();
        while (true) {
            if (this.expectChar('<')) {
                this.move(true);
                if (this.expectChar('=')) {
                    this.move(true);
                    this.expr();
                    this.codeGenerator.onLe(this.lookhead);
                    continue;
                }
                this.expr();
                this.codeGenerator.onLt(this.lookhead);
                continue;
            }
            if (!this.expectChar('>')) break;
            this.move(true);
            if (this.expectChar('=')) {
                this.move(true);
                this.expr();
                this.codeGenerator.onGe(this.lookhead);
                continue;
            }
            this.expr();
            this.codeGenerator.onGt(this.lookhead);
        }
    }

    public void shift() {
        block4: {
            this.expr();
            while (true) {
                if (this.expectChar('<')) {
                    this.move(true);
                    if (this.expectChar('<')) {
                        this.move(true);
                        this.expr();
                        this.codeGenerator.onShiftLeft(this.lookhead);
                        continue;
                    }
                    this.back();
                    break block4;
                }
                if (!this.expectChar('>')) break block4;
                this.move(true);
                if (!this.expectChar('>')) break;
                this.move(true);
                if (this.expectChar('>')) {
                    this.move(true);
                    this.expr();
                    this.codeGenerator.onUnsignedShiftRight(this.lookhead);
                    continue;
                }
                this.expr();
                this.codeGenerator.onShiftRight(this.lookhead);
            }
            this.back();
        }
    }

    public void expr() {
        this.term();
        while (true) {
            if (this.expectChar('+')) {
                this.move(true);
                this.term();
                this.codeGenerator.onAdd(this.lookhead);
                continue;
            }
            if (!this.expectChar('-')) break;
            this.move(true);
            this.term();
            this.codeGenerator.onSub(this.lookhead);
        }
    }

    public void term() {
        this.unary();
        while (true) {
            if (this.expectChar('*')) {
                this.move(true);
                this.unary();
                this.codeGenerator.onMult(this.lookhead);
                continue;
            }
            if (this.expectChar('/')) {
                this.move(true);
                this.unary();
                this.codeGenerator.onDiv(this.lookhead);
                continue;
            }
            if (!this.expectChar('%')) break;
            this.move(true);
            this.unary();
            this.codeGenerator.onMod(this.lookhead);
        }
    }

    public void unary() {
        if (this.expectChar('!')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onNot(this.lookhead);
            }
        } else if (this.expectChar('-')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onNeg(this.lookhead);
            }
        } else if (this.expectChar('~')) {
            this.move(true);
            if (this.expectChar(',') || this.expectChar(')')) {
                this.back();
                this.factor();
            } else {
                this.unary();
                this.codeGenerator.onBitNot(this.lookhead);
            }
        } else {
            this.factor();
        }
        while (this.expectChar('[') || this.expectChar('(')) {
            if (this.expectChar('[')) {
                this.arrayAccess();
                continue;
            }
            if (!this.expectChar('(')) continue;
            ++this.parenDepth;
            this.depthState.add(DepthState.Parent);
            this.codeGenerator.onMethodName(new DelegateToken(this.lookhead.getStartIndex(), this.lookhead, DelegateToken.DelegateTokenType.Method_Name));
            this.move(true);
            if (!this.expectChar(')')) {
                this.ternary();
                this.codeGenerator.onMethodParameter(this.lookhead);
                while (this.expectChar(',')) {
                    this.move(true);
                    this.ternary();
                    this.codeGenerator.onMethodParameter(this.lookhead);
                }
            }
            if (!this.expectChar(')')) continue;
            --this.parenDepth;
            this.depthState.removeLast();
            this.move(true);
            this.codeGenerator.onMethodInvoke(this.lookhead);
        }
    }

    public boolean isOPVariable(Token<?> token) {
        if (token.getType() != Token.TokenType.Char) {
            return false;
        }
        CharToken charToken = (CharToken)token;
        this.move(true);
        if (this.expectChar(',') || this.expectChar(')')) {
            this.back();
            String lexeme = String.valueOf(charToken.getCh());
            if (lexeme.equals("-")) {
                lexeme = "-sub";
            }
            return this.instance.containsFunction(lexeme);
        }
        this.back();
        return false;
    }

    public void factor() {
        if (this.lookhead == null) {
            this.reportSyntaxError("invalid value");
        }
        if (this.expectChar('(')) {
            ++this.parenDepth;
            this.depthState.add(DepthState.Parent);
            this.move(true);
            this.ternary();
            if (this.expectChar(')')) {
                this.move(true);
                --this.parenDepth;
                this.depthState.removeLast();
            }
        } else if (this.lookhead.getType() == Token.TokenType.Number || this.lookhead.getType() == Token.TokenType.String || this.lookhead.getType() == Token.TokenType.Variable || this.lookhead == Variable.TRUE || this.lookhead == Variable.FALSE || this.isOPVariable(this.lookhead)) {
            if (this.lookhead.getType() == Token.TokenType.Variable) {
                this.checkVariableName();
            }
            if (this.lookhead.getType() == Token.TokenType.Char) {
                CharToken charToken = (CharToken)this.lookhead;
                if (!ExpressionLexer.isBinaryOP(charToken.getCh())) {
                    this.reportSyntaxError("Unexpect char '" + charToken.getCh() + "'");
                }
                this.lookhead = new Variable(charToken.getLexeme(), charToken.getStartIndex());
            }
            this.move(true);
            Token<?> prev = this.prevToken;
            if (prev.getType() == Token.TokenType.Variable && this.expectChar('(')) {
                if (prev == Variable.LAMBDA) {
                    this.lambda();
                } else {
                    this.method();
                }
            } else if (prev.getType() == Token.TokenType.Variable) {
                this.arrayAccess();
            } else {
                this.codeGenerator.onConstant(prev);
            }
        } else if (this.expectChar('/')) {
            this.pattern();
        } else {
            this.reportSyntaxError("invalid value");
        }
    }

    private void lambda() {
        ++this.lambdaDepth;
        this.depthState.add(DepthState.Lambda);
        this.codeGenerator.onLambdaDefineStart(this.prevToken);
        ++this.parenDepth;
        this.depthState.add(DepthState.Parent);
        this.move(true);
        if (!this.expectChar(')')) {
            this.lambdaArgument();
            while (this.expectChar(',')) {
                this.move(true);
                this.lambdaArgument();
            }
        }
        if (this.expectChar(')')) {
            --this.parenDepth;
            this.depthState.removeLast();
            this.move(true);
            if (this.expectChar('-')) {
                this.move(true);
                if (this.expectChar('>')) {
                    this.codeGenerator.onLambdaBodyStart(this.lookhead);
                    this.move(true);
                    this.statement();
                    if (this.lookhead != null && this.lookhead.getType() == Token.TokenType.Variable && this.lookhead.getLexeme().equals("end")) {
                        this.codeGenerator.onLambdaBodyEnd(this.lookhead);
                        --this.lambdaDepth;
                        this.depthState.removeLast();
                        this.move(true);
                    } else {
                        this.reportSyntaxError("Expect lambda 'end', but is: '" + this.currentTokenLexeme() + "'");
                    }
                } else {
                    this.reportSyntaxError("Expect lambda body, but is: '" + this.currentTokenLexeme() + "'");
                }
            } else {
                this.reportSyntaxError("Expect lambda body, but is: '" + this.currentTokenLexeme() + "'");
            }
        }
    }

    private String currentTokenLexeme() {
        return this.lookhead == null ? "END_OF_STRING" : this.lookhead.getLexeme();
    }

    private void lambdaArgument() {
        if (this.lookhead.getType() == Token.TokenType.Variable) {
            if (!ExpressionParser.isJavaIdentifier(this.lookhead.getLexeme())) {
                this.reportSyntaxError("Illegal argument name: " + this.currentTokenLexeme() + ",index=" + this.lookhead.getStartIndex());
            }
            this.codeGenerator.onLambdaArgument(this.lookhead);
            this.move(true);
        } else {
            this.reportSyntaxError("Expect argument name,but is: " + this.currentTokenLexeme() + ",index=" + this.lookhead.getStartIndex());
        }
    }

    private void arrayAccess() {
        boolean hasArray = false;
        while (this.expectChar('[')) {
            if (!hasArray) {
                this.codeGenerator.onArray(this.prevToken);
                this.move(true);
                hasArray = true;
            } else {
                this.move(true);
            }
            this.codeGenerator.onArrayIndexStart(this.prevToken);
            this.array();
        }
        if (!hasArray) {
            this.codeGenerator.onConstant(this.prevToken);
        }
    }

    private void array() {
        ++this.bracketDepth;
        this.depthState.add(DepthState.Bracket);
        if (RESERVED_WORDS.contains(this.prevToken.getLexeme())) {
            throw new ExpressionSyntaxErrorException(this.prevToken.getLexeme() + " could not use [] operator");
        }
        this.ternary();
        if (this.expectChar(']')) {
            --this.bracketDepth;
            this.depthState.removeLast();
            this.move(true);
            this.codeGenerator.onArrayIndexEnd(this.lookhead);
        }
    }

    private void checkVariableName() {
        if (!((Variable)this.lookhead).isQuote()) {
            String[] names;
            for (String name : names = this.lookhead.getLexeme().split("\\.")) {
                if (ExpressionParser.isJavaIdentifier(name)) continue;
                this.reportSyntaxError("Illegal identifier " + name + ",index=" + this.lookhead.getStartIndex());
            }
        }
    }

    private void method() {
        if (this.expectChar('(')) {
            ++this.parenDepth;
            this.depthState.add(DepthState.Parent);
            this.codeGenerator.onMethodName(this.prevToken);
            this.move(true);
            if (!this.expectChar(')')) {
                this.ternary();
                this.codeGenerator.onMethodParameter(this.lookhead);
                while (this.expectChar(',')) {
                    this.move(true);
                    this.ternary();
                    this.codeGenerator.onMethodParameter(this.lookhead);
                }
            }
            if (this.expectChar(')')) {
                --this.parenDepth;
                this.depthState.removeLast();
                this.move(true);
                this.codeGenerator.onMethodInvoke(this.lookhead);
            }
        }
    }

    public static final boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return !id.equals("null");
    }

    private void pattern() {
        int startIndex = this.lookhead.getStartIndex();
        this.move(true);
        this.inPattern = true;
        StringBuffer sb = new StringBuffer();
        while (this.lookhead != null) {
            while (!this.expectChar('/')) {
                sb.append(this.lookhead.getLexeme());
                this.move(false);
            }
            if (this.prevToken.getType() == Token.TokenType.Char && ((CharToken)this.prevToken).getLexeme().equals("\\")) {
                sb.append("/");
                this.move(false);
                continue;
            }
            this.inPattern = false;
            break;
        }
        if (this.inPattern) {
            this.reportSyntaxError("invalid regular pattern");
        }
        this.codeGenerator.onConstant(new PatternToken(sb.toString(), startIndex));
        this.move(true);
    }

    private void reportSyntaxError(String message) {
        int index = this.lookhead != null && this.lookhead.getStartIndex() > 0 ? this.lookhead.getStartIndex() : this.lexer.getCurrentIndex();
        throw new ExpressionSyntaxErrorException("Syntax error:" + message + " at " + index + ", current token: " + this.lookhead + ". Parsing expression: `" + this.lexer.getScanString() + "^^`");
    }

    public void move(boolean analyse) {
        if (this.lookhead != null) {
            this.prevToken = this.lookhead;
            this.lookhead = this.lexer.scan(analyse);
        } else {
            this.reportSyntaxError("Illegal expression");
        }
    }

    public void back() {
        this.lexer.pushback(this.lookhead);
        this.lookhead = this.prevToken;
    }

    public Expression parse() {
        this.statement();
        if (this.lookhead != null) {
            this.reportSyntaxError("Unexpect token '" + this.currentTokenLexeme() + "'");
        }
        return this.codeGenerator.getResult();
    }

    private void statement() {
        this.ternary();
        this.ensureDepthState();
        while (this.expectChar(';')) {
            this.codeGenerator.onTernaryEnd(this.lookhead);
            this.move(true);
            this.ternary();
            this.ensureDepthState();
        }
    }

    private void ensureDepthState() {
        DepthState state = this.depthState.peekLast();
        if (state != null) {
            this.back();
            switch (state) {
                case Parent: {
                    if (this.parenDepth <= 0) break;
                    this.reportSyntaxError("insert ')' to complete Expression");
                    break;
                }
                case Bracket: {
                    if (this.bracketDepth <= 0) break;
                    this.reportSyntaxError("insert ']' to complete Expression");
                    break;
                }
                case Lambda: {
                    if (this.lambdaDepth <= 0) break;
                    this.reportSyntaxError("insert 'end' to complete lambda Expression");
                }
            }
        }
    }

    static {
        RESERVED_WORDS.add(Variable.TRUE.getLexeme());
        RESERVED_WORDS.add(Variable.FALSE.getLexeme());
        RESERVED_WORDS.add(Variable.NIL.getLexeme());
        LEFT_PAREN = new CharToken('(', -1);
        RIGHT_PAREN = new CharToken(')', -1);
    }
}

