/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.asm.ClassWriter;
import com.googlecode.aviator.asm.MethodVisitor;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.asm.ClassDefiner;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.parser.ScopeInfo;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class LambdaGenerator
implements CodeGenerator {
    private ClassWriter classWriter;
    private List<String> arguments = new ArrayList<String>();
    private CodeGenerator codeGenerator;
    private CodeGenerator parentCodeGenerator;
    private AviatorClassLoader classLoader;
    private AviatorEvaluatorInstance instance;
    private String className;
    private static final AtomicLong LAMBDA_COUNTER = new AtomicLong();
    private MethodVisitor mv;
    private ScopeInfo scopeInfo;

    public LambdaGenerator(AviatorEvaluatorInstance instance, CodeGenerator parentCodeGenerator, Parser parser, AviatorClassLoader classLoader) {
        this.instance = instance;
        this.parentCodeGenerator = parentCodeGenerator;
        this.codeGenerator = instance.newCodeGenerator(classLoader);
        this.codeGenerator.setParser(parser);
        this.classLoader = classLoader;
        this.className = "Lambda_" + System.currentTimeMillis() + "_" + LAMBDA_COUNTER.getAndIncrement();
        this.classWriter = new ClassWriter(2);
        this.visitClass();
        this.makeConstructor();
        this.makeGetName();
    }

    public ScopeInfo getScopeInfo() {
        return this.scopeInfo;
    }

    public void setScopeInfo(ScopeInfo scopeInfo) {
        this.scopeInfo = scopeInfo;
    }

    @Override
    public void setParser(Parser parser) {
        this.codeGenerator.setParser(parser);
    }

    private void makeConstructor() {
        this.mv = this.classWriter.visitMethod(1, "<init>", "(Ljava/util/List;Lcom/googlecode/aviator/Expression;Lcom/googlecode/aviator/utils/Env;)V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitVarInsn(25, 3);
        this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/function/LambdaFunction", "<init>", "(Ljava/util/List;Lcom/googlecode/aviator/Expression;Lcom/googlecode/aviator/utils/Env;)V");
        this.mv.visitInsn(177);
        this.mv.visitMaxs(4, 1);
        this.mv.visitEnd();
    }

    private void makeGetName() {
        this.mv = this.classWriter.visitMethod(17, "getName", "()Ljava/lang/String;", "()Ljava/lang/String;", null);
        this.mv.visitCode();
        this.mv.visitLdcInsn(this.className);
        this.mv.visitInsn(176);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
    }

    public void compileCallMethod() {
        int argsNumber = this.arguments.size();
        int arrayIndex = 2 + argsNumber;
        if (argsNumber < 20) {
            StringBuilder argsDescSb = new StringBuilder();
            for (int i = 0; i < argsNumber; ++i) {
                argsDescSb.append("Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            }
            String argsDec = argsDescSb.toString();
            this.mv = this.classWriter.visitMethod(17, "call", "(Ljava/util/Map;" + argsDec + ")Lcom/googlecode/aviator/runtime/type/AviatorObject;", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;" + argsDec + ")Lcom/googlecode/aviator/runtime/type/AviatorObject;", null);
            this.mv.visitCode();
            this.mv.visitIntInsn(25, 0);
            this.mv.visitFieldInsn(180, this.className, "expression", "Lcom/googlecode/aviator/Expression;");
            this.mv.visitIntInsn(25, 0);
            this.mv.visitIntInsn(25, 1);
            this.mv.visitLdcInsn(argsNumber);
            this.mv.visitTypeInsn(189, "com/googlecode/aviator/runtime/type/AviatorObject");
            this.mv.visitVarInsn(58, arrayIndex);
            for (int i = 0; i < argsNumber; ++i) {
                this.mv.visitVarInsn(25, arrayIndex);
                this.mv.visitLdcInsn(i);
                this.mv.visitVarInsn(25, i + 2);
                this.mv.visitInsn(83);
            }
        } else {
            throw new CompileExpressionErrorException("Lambda function arguments number at most 20.");
        }
        this.mv.visitVarInsn(25, arrayIndex);
        this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/function/LambdaFunction", "newEnv", "(Ljava/util/Map;[Lcom/googlecode/aviator/runtime/type/AviatorObject;)Ljava/util/Map;");
        this.mv.visitMethodInsn(185, "com/googlecode/aviator/Expression", "execute", "(Ljava/util/Map;)Ljava/lang/Object;");
        this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorRuntimeJavaType", "valueOf", "(Ljava/lang/Object;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        this.mv.visitInsn(176);
        this.mv.visitMaxs(5, 1);
        this.mv.visitEnd();
    }

    private void visitClass() {
        this.classWriter.visit(this.instance.getBytecodeVersion(), 33, this.className, null, "com/googlecode/aviator/runtime/function/LambdaFunction", null);
    }

    private void endVisitClass() {
        this.classWriter.visitEnd();
    }

    public LambdaFunctionBootstrap getLmabdaBootstrap() {
        Expression expression = this.getResult();
        this.endVisitClass();
        byte[] bytes = this.classWriter.toByteArray();
        try {
            Class<?> defineClass = null;
            defineClass = ClassDefiner.isJDK7() ? ClassDefiner.defineClassByClassLoader(this.className, bytes, this.classLoader) : ClassDefiner.defineClass(this.className, LambdaFunction.class, bytes, this.classLoader);
            Constructor<?> constructor = defineClass.getConstructor(List.class, Expression.class, Env.class);
            MethodHandle methodHandle = MethodHandles.lookup().unreflectConstructor(constructor);
            return new LambdaFunctionBootstrap(this.className, expression, methodHandle, this.arguments);
        }
        catch (Exception e) {
            throw new CompileExpressionErrorException("define lambda class error", e);
        }
    }

    public void addArgument(String name) {
        this.arguments.add(name);
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.codeGenerator.onShiftRight(lookhead);
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.codeGenerator.onShiftLeft(lookhead);
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.codeGenerator.onUnsignedShiftRight(lookhead);
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.codeGenerator.onBitOr(lookhead);
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.codeGenerator.onBitAnd(lookhead);
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.codeGenerator.onBitXor(lookhead);
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.codeGenerator.onBitNot(lookhead);
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.codeGenerator.onAdd(lookhead);
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.codeGenerator.onSub(lookhead);
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.codeGenerator.onMult(lookhead);
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.codeGenerator.onDiv(lookhead);
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.codeGenerator.onAndLeft(lookhead);
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.codeGenerator.onAndRight(lookhead);
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.codeGenerator.onTernaryBoolean(lookhead);
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.codeGenerator.onTernaryLeft(lookhead);
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.codeGenerator.onTernaryRight(lookhead);
    }

    @Override
    public void onTernaryEnd(Token<?> lookhead) {
        this.codeGenerator.onTernaryEnd(lookhead);
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.codeGenerator.onJoinLeft(lookhead);
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.codeGenerator.onJoinRight(lookhead);
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.codeGenerator.onEq(lookhead);
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.codeGenerator.onMatch(lookhead);
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.codeGenerator.onNeq(lookhead);
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.codeGenerator.onLt(lookhead);
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.codeGenerator.onLe(lookhead);
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.codeGenerator.onGt(lookhead);
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.codeGenerator.onGe(lookhead);
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.codeGenerator.onMod(lookhead);
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.codeGenerator.onNot(lookhead);
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.codeGenerator.onNeg(lookhead);
    }

    @Override
    public Expression getResult() {
        return this.codeGenerator.getResult();
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        this.codeGenerator.onConstant(lookhead);
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        this.codeGenerator.onMethodName(lookhead);
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        this.codeGenerator.onMethodParameter(lookhead);
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        this.codeGenerator.onMethodInvoke(lookhead);
    }

    @Override
    public void onLambdaDefineStart(Token<?> lookhead) {
        this.codeGenerator.onLambdaDefineStart(lookhead);
    }

    @Override
    public void onLambdaArgument(Token<?> lookhead) {
        this.codeGenerator.onLambdaArgument(lookhead);
    }

    @Override
    public void onLambdaBodyStart(Token<?> lookhead) {
        this.codeGenerator.onLambdaBodyStart(lookhead);
    }

    @Override
    public void onLambdaBodyEnd(Token<?> lookhead) {
        this.parentCodeGenerator.onLambdaBodyEnd(lookhead);
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.codeGenerator.onArray(lookhead);
    }

    @Override
    public void onArrayIndexStart(Token<?> token) {
        this.codeGenerator.onArrayIndexStart(token);
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.codeGenerator.onArrayIndexEnd(lookhead);
    }
}

