/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.ClassPathConfigFunctionLoader;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.FunctionLoader;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.OptimizeCodeGenerator;
import com.googlecode.aviator.code.asm.ASMCodeGenerator;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.ExpressionLexer;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.ExpressionParser;
import com.googlecode.aviator.runtime.function.math.MathAbsFunction;
import com.googlecode.aviator.runtime.function.math.MathCosFunction;
import com.googlecode.aviator.runtime.function.math.MathLog10Function;
import com.googlecode.aviator.runtime.function.math.MathLogFunction;
import com.googlecode.aviator.runtime.function.math.MathPowFunction;
import com.googlecode.aviator.runtime.function.math.MathRoundFunction;
import com.googlecode.aviator.runtime.function.math.MathSinFunction;
import com.googlecode.aviator.runtime.function.math.MathSqrtFunction;
import com.googlecode.aviator.runtime.function.math.MathTanFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCompsitePredFunFunction;
import com.googlecode.aviator.runtime.function.seq.SeqCountFunction;
import com.googlecode.aviator.runtime.function.seq.SeqEveryFunction;
import com.googlecode.aviator.runtime.function.seq.SeqFilterFunction;
import com.googlecode.aviator.runtime.function.seq.SeqIncludeFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMakePredicateFunFunction;
import com.googlecode.aviator.runtime.function.seq.SeqMapFunction;
import com.googlecode.aviator.runtime.function.seq.SeqNotAnyFunction;
import com.googlecode.aviator.runtime.function.seq.SeqReduceFunction;
import com.googlecode.aviator.runtime.function.seq.SeqSomeFunction;
import com.googlecode.aviator.runtime.function.seq.SeqSortFunction;
import com.googlecode.aviator.runtime.function.string.StringContainsFunction;
import com.googlecode.aviator.runtime.function.string.StringEndsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringIndexOfFunction;
import com.googlecode.aviator.runtime.function.string.StringJoinFunction;
import com.googlecode.aviator.runtime.function.string.StringLengthFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceAllFunction;
import com.googlecode.aviator.runtime.function.string.StringReplaceFirstFunction;
import com.googlecode.aviator.runtime.function.string.StringSplitFunction;
import com.googlecode.aviator.runtime.function.string.StringStartsWithFunction;
import com.googlecode.aviator.runtime.function.string.StringSubStringFunction;
import com.googlecode.aviator.runtime.function.system.BinaryFunction;
import com.googlecode.aviator.runtime.function.system.BooleanFunction;
import com.googlecode.aviator.runtime.function.system.Date2StringFunction;
import com.googlecode.aviator.runtime.function.system.DoubleFunction;
import com.googlecode.aviator.runtime.function.system.LongFunction;
import com.googlecode.aviator.runtime.function.system.NowFunction;
import com.googlecode.aviator.runtime.function.system.PrintFunction;
import com.googlecode.aviator.runtime.function.system.PrintlnFunction;
import com.googlecode.aviator.runtime.function.system.RandomFunction;
import com.googlecode.aviator.runtime.function.system.StrFunction;
import com.googlecode.aviator.runtime.function.system.String2DateFunction;
import com.googlecode.aviator.runtime.function.system.SysDateFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorNil;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;

public final class AviatorEvaluatorInstance {
    private AviatorClassLoader aviatorClassLoader;
    private OutputStream traceOutputStream = System.out;
    public int bytecodeVersion = 50;
    private final ConcurrentHashMap<Options, Object> options = new ConcurrentHashMap();
    private List<FunctionLoader> functionLoaders;
    private final Map<String, Object> funcMap;
    private final Map<OperatorType, AviatorFunction> opsMap;
    private final ConcurrentHashMap<String, FutureTask<Expression>> cacheExpressions;

    public void addFunctionLoader(FunctionLoader loader) {
        if (this.functionLoaders == null) {
            this.functionLoaders = new ArrayList<FunctionLoader>();
        }
        this.functionLoaders.add(loader);
    }

    public void removeFunctionLoader(FunctionLoader loader) {
        if (this.functionLoaders == null) {
            return;
        }
        this.functionLoaders.remove(loader);
    }

    public void setOption(Options opt, Object val) {
        if (opt == null || val == null) {
            throw new IllegalArgumentException("Option and value should not be null.");
        }
        if (!opt.isValidValue(val)) {
            throw new IllegalArgumentException("Invalid value for option:" + opt.name());
        }
        this.options.put(opt, val);
    }

    public <T> T getOption(Options opt) {
        Object val = this.options.get((Object)opt);
        if (val == null) {
            val = opt.getDefaultValue();
        }
        return (T)val;
    }

    public int getBytecodeVersion() {
        return this.bytecodeVersion;
    }

    public void setBytecodeVersion(int bytecodeVersion) {
        this.bytecodeVersion = bytecodeVersion;
    }

    public ConcurrentHashMap<Options, Object> getOptions() {
        return this.options;
    }

    public Map<String, Object> getFuncMap() {
        return this.funcMap;
    }

    public Map<OperatorType, AviatorFunction> getOpsMap() {
        return this.opsMap;
    }

    public OutputStream getTraceOutputStream() {
        return this.traceOutputStream;
    }

    public void setTraceOutputStream(OutputStream traceOutputStream) {
        this.traceOutputStream = traceOutputStream;
    }

    private void loadLib() {
        this.addFunction(new SysDateFunction());
        this.addFunction(new PrintlnFunction());
        this.addFunction(new PrintFunction());
        this.addFunction(new RandomFunction());
        this.addFunction(new NowFunction());
        this.addFunction(new LongFunction());
        this.addFunction(new BooleanFunction());
        this.addFunction(new DoubleFunction());
        this.addFunction(new StrFunction());
        this.addFunction(new Date2StringFunction());
        this.addFunction(new String2DateFunction());
        this.addFunction(new BinaryFunction(OperatorType.ADD));
        this.addFunction(new BinaryFunction(OperatorType.SUB));
        this.addFunction(new BinaryFunction(OperatorType.MULT));
        this.addFunction(new BinaryFunction(OperatorType.DIV));
        this.addFunction(new BinaryFunction(OperatorType.MOD));
        this.addFunction(new BinaryFunction(OperatorType.NEG));
        this.addFunction(new BinaryFunction(OperatorType.NOT));
        this.addFunction(new BinaryFunction(OperatorType.BIT_AND));
        this.addFunction(new BinaryFunction(OperatorType.BIT_OR));
        this.addFunction(new BinaryFunction(OperatorType.BIT_XOR));
        this.addFunction(new BinaryFunction(OperatorType.BIT_NOT));
        this.addFunction(new StringContainsFunction());
        this.addFunction(new StringIndexOfFunction());
        this.addFunction(new StringStartsWithFunction());
        this.addFunction(new StringEndsWithFunction());
        this.addFunction(new StringSubStringFunction());
        this.addFunction(new StringLengthFunction());
        this.addFunction(new StringSplitFunction());
        this.addFunction(new StringJoinFunction());
        this.addFunction(new StringReplaceFirstFunction());
        this.addFunction(new StringReplaceAllFunction());
        this.addFunction(new MathAbsFunction());
        this.addFunction(new MathRoundFunction());
        this.addFunction(new MathPowFunction());
        this.addFunction(new MathSqrtFunction());
        this.addFunction(new MathLog10Function());
        this.addFunction(new MathLogFunction());
        this.addFunction(new MathSinFunction());
        this.addFunction(new MathCosFunction());
        this.addFunction(new MathTanFunction());
        this.addFunction(new SeqMapFunction());
        this.addFunction(new SeqReduceFunction());
        this.addFunction(new SeqFilterFunction());
        this.addFunction(new SeqSortFunction());
        this.addFunction(new SeqIncludeFunction());
        this.addFunction(new SeqCountFunction());
        this.addFunction(new SeqEveryFunction());
        this.addFunction(new SeqNotAnyFunction());
        this.addFunction(new SeqSomeFunction());
        this.addFunction(new SeqMakePredicateFunFunction("seq.eq", OperatorType.EQ));
        this.addFunction(new SeqMakePredicateFunFunction("seq.neq", OperatorType.NEQ));
        this.addFunction(new SeqMakePredicateFunFunction("seq.lt", OperatorType.LT));
        this.addFunction(new SeqMakePredicateFunFunction("seq.le", OperatorType.LE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.gt", OperatorType.GT));
        this.addFunction(new SeqMakePredicateFunFunction("seq.ge", OperatorType.GE));
        this.addFunction(new SeqCompsitePredFunFunction("seq.and", SeqCompsitePredFunFunction.LogicOp.AND));
        this.addFunction(new SeqCompsitePredFunFunction("seq.or", SeqCompsitePredFunFunction.LogicOp.OR));
        this.addFunction(new SeqMakePredicateFunFunction("seq.true", OperatorType.EQ, AviatorBoolean.TRUE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.false", OperatorType.EQ, AviatorBoolean.FALSE));
        this.addFunction(new SeqMakePredicateFunFunction("seq.nil", OperatorType.EQ, AviatorNil.NIL));
        this.addFunction(new SeqMakePredicateFunFunction("seq.exists", OperatorType.NEQ, AviatorNil.NIL));
    }

    AviatorEvaluatorInstance() {
        this.aviatorClassLoader = AccessController.doPrivileged(new PrivilegedAction<AviatorClassLoader>(){

            @Override
            public AviatorClassLoader run() {
                return new AviatorClassLoader(AviatorEvaluatorInstance.class.getClassLoader());
            }
        });
        this.funcMap = new HashMap<String, Object>();
        this.opsMap = new IdentityHashMap<OperatorType, AviatorFunction>();
        this.cacheExpressions = new ConcurrentHashMap();
        this.loadLib();
        this.addFunctionLoader(ClassPathConfigFunctionLoader.getInstance());
    }

    public void clearExpressionCache() {
        this.cacheExpressions.clear();
    }

    public AviatorClassLoader getAviatorClassLoader() {
        return this.getAviatorClassLoader(false);
    }

    public AviatorClassLoader getAviatorClassLoader(boolean cached) {
        if (cached) {
            return this.aviatorClassLoader;
        }
        return new AviatorClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void addFunction(AviatorFunction function) {
        String name = function.getName();
        this.addFunction(name, function);
    }

    public void addFunction(String name, AviatorFunction function) {
        if ("lambda".equals(name)) {
            throw new IllegalArgumentException("Invalid function name, lambda is a keyword.");
        }
        if (this.funcMap.containsKey(name)) {
            System.out.println("[Aviator WARN] The function '" + name + "' is already exists, but is replaced with new one.");
        }
        this.funcMap.put(name, function);
    }

    public void defineFunction(String name, String expression) {
        this.defineFunction(name, expression, null);
    }

    public void defineFunction(String name, String expression, Map<String, Object> env) {
        AviatorFunction function = (AviatorFunction)this.execute(expression, env);
        this.addFunction(name, function);
    }

    public AviatorFunction removeFunction(String name) {
        return (AviatorFunction)this.funcMap.remove(name);
    }

    public AviatorFunction getFunction(String name) {
        AviatorFunction function = (AviatorFunction)this.funcMap.get(name);
        if (function == null && this.functionLoaders != null) {
            FunctionLoader loader;
            Iterator<FunctionLoader> i$ = this.functionLoaders.iterator();
            while (i$.hasNext() && (function = (loader = i$.next()).onFunctionNotFound(name)) == null) {
            }
        }
        if (function == null) {
            throw new ExpressionRuntimeException("Could not find function named '" + name + "'");
        }
        return function;
    }

    public void addOpFunction(OperatorType opType, AviatorFunction function) {
        this.opsMap.put(opType, function);
    }

    public AviatorFunction getOpFunction(OperatorType opType) {
        return this.opsMap.get((Object)opType);
    }

    public AviatorFunction removeOpFunction(OperatorType opType) {
        return this.opsMap.remove((Object)opType);
    }

    public boolean containsFunction(String name) {
        return this.funcMap.containsKey(name);
    }

    public AviatorFunction removeFunction(AviatorFunction function) {
        return this.removeFunction(function.getName());
    }

    public Expression getCachedExpression(String expression) {
        FutureTask<Expression> task = this.cacheExpressions.get(expression);
        if (task != null) {
            return this.getCompiledExpression(expression, task);
        }
        return null;
    }

    public Expression compile(final String expression, final boolean cached) {
        if (expression == null || expression.trim().length() == 0) {
            throw new CompileExpressionErrorException("Blank expression");
        }
        if (cached) {
            FutureTask<Expression> task = this.cacheExpressions.get(expression);
            if (task != null) {
                return this.getCompiledExpression(expression, task);
            }
            task = new FutureTask<Expression>(new Callable<Expression>(){

                @Override
                public Expression call() throws Exception {
                    return AviatorEvaluatorInstance.this.innerCompile(expression, cached);
                }
            });
            FutureTask<Expression> existedTask = this.cacheExpressions.putIfAbsent(expression, task);
            if (existedTask == null) {
                existedTask = task;
                existedTask.run();
            }
            return this.getCompiledExpression(expression, existedTask);
        }
        return this.innerCompile(expression, cached);
    }

    private Expression getCompiledExpression(String expression, FutureTask<Expression> task) {
        try {
            return task.get();
        }
        catch (Exception e) {
            this.cacheExpressions.remove(expression);
            throw new CompileExpressionErrorException("Compile expression failure:" + expression, e);
        }
    }

    private Expression innerCompile(String expression, boolean cached) {
        ExpressionLexer lexer = new ExpressionLexer(this, expression);
        CodeGenerator codeGenerator = this.newCodeGenerator(cached);
        ExpressionParser parser = new ExpressionParser(this, lexer, codeGenerator);
        Expression exp = parser.parse();
        if (((Boolean)this.getOption(Options.TRACE_EVAL)).booleanValue()) {
            ((BaseExpression)exp).setExpression(expression);
        }
        return exp;
    }

    private int getOptimizeLevel() {
        return (Integer)this.getOption(Options.OPTIMIZE_LEVEL);
    }

    public CodeGenerator newCodeGenerator(boolean cached) {
        AviatorClassLoader classLoader = this.getAviatorClassLoader(cached);
        return this.newCodeGenerator(classLoader);
    }

    public CodeGenerator newCodeGenerator(AviatorClassLoader classLoader) {
        switch (this.getOptimizeLevel()) {
            case 0: {
                ASMCodeGenerator asmCodeGenerator = new ASMCodeGenerator(this, classLoader, this.traceOutputStream, (Boolean)this.getOption(Options.TRACE));
                asmCodeGenerator.start();
                return asmCodeGenerator;
            }
            case 1: {
                return new OptimizeCodeGenerator(this, classLoader, this.traceOutputStream, (Boolean)this.getOption(Options.TRACE));
            }
        }
        throw new IllegalArgumentException("Unknow option " + this.getOptimizeLevel());
    }

    public Expression compile(String expression) {
        return this.compile(expression, false);
    }

    public Object exec(String expression, Object ... values) {
        if (this.getOptimizeLevel() != 1) {
            throw new IllegalStateException("Aviator evaluator is not in EVAL mode.");
        }
        Expression compiledExpression = this.compile(expression, true);
        if (compiledExpression != null) {
            List<String> vars = compiledExpression.getVariableNames();
            if (!vars.isEmpty()) {
                int valLen;
                int n = valLen = values == null ? 0 : values.length;
                if (valLen != vars.size()) {
                    throw new IllegalArgumentException("Expect " + vars.size() + " values,but has " + valLen);
                }
                HashMap<String, Object> env = new HashMap<String, Object>();
                int i = 0;
                for (String var : vars) {
                    env.put(var, values[i++]);
                }
                return compiledExpression.execute(env);
            }
            return compiledExpression.execute();
        }
        throw new ExpressionRuntimeException("Null compiled expression for " + expression);
    }

    public Object execute(String expression, Map<String, Object> env, boolean cached) {
        Expression compiledExpression = this.compile(expression, cached);
        if (compiledExpression != null) {
            return compiledExpression.execute(env);
        }
        throw new ExpressionRuntimeException("Null compiled expression for " + expression);
    }

    public Object execute(String expression, Map<String, Object> env) {
        return this.execute(expression, env, false);
    }

    public void invalidateCache(String expression) {
        this.cacheExpressions.remove(expression);
    }

    public Object execute(String expression) {
        return this.execute(expression, null);
    }
}

