/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class SeqReduceFunction
extends AbstractFunction {
    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
        Object first = arg1.getValue(env);
        AviatorFunction fun = FunctionUtils.getFunction(arg2, env, 2);
        if (fun == null) {
            throw new ExpressionRuntimeException("There is no function named " + ((AviatorJavaType)arg2).getName());
        }
        if (first == null) {
            throw new NullPointerException("null seq");
        }
        AviatorObject result = arg3;
        Class<?> clazz = first.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            for (Object obj : (Collection)first) {
                result = fun.call(env, result, new AviatorRuntimeJavaType(obj));
            }
        } else if (clazz.isArray()) {
            int length = Array.getLength(first);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(first, i);
                result = fun.call(env, result, new AviatorRuntimeJavaType(obj));
            }
        } else {
            throw new IllegalArgumentException(arg1.desc(env) + " is not a seq");
        }
        return result;
    }

    @Override
    public String getName() {
        return "reduce";
    }
}

