/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class SeqPredicateFunction
extends AbstractFunction {
    private final String name;
    private final OperatorType opType;
    private final AviatorObject value;

    public SeqPredicateFunction(String name, OperatorType opType, AviatorObject value) {
        this.name = name;
        this.opType = opType;
        this.value = value;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        switch (this.opType) {
            case EQ: {
                return arg1.compare(this.value, env) == 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case NEQ: {
                return arg1.compare(this.value, env) != 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case LT: {
                return arg1.compare(this.value, env) < 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case LE: {
                return arg1.compare(this.value, env) <= 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case GE: {
                return arg1.compare(this.value, env) >= 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case GT: {
                return arg1.compare(this.value, env) > 0 ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
        }
        throw new ExpressionRuntimeException(this.getName() + " is not a relation operator");
    }

    @Override
    public String getName() {
        return this.name;
    }
}

