/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.Map;

public class FunctionUtils {
    public static final String getStringValue(AviatorObject arg, Map<String, Object> env) {
        String result = null;
        Object value = arg.getValue(env);
        if (value == null && arg.getAviatorType() == AviatorType.JavaType) {
            throw new NullPointerException("There is no string named" + ((AviatorJavaType)arg).getName());
        }
        result = value instanceof Character ? value.toString() : (String)value;
        return result;
    }

    public static Object getJavaObject(AviatorObject arg, Map<String, Object> env) {
        if (arg.getAviatorType() != AviatorType.JavaType) {
            throw new ExpressionRuntimeException(arg.desc(env) + " is not a javaType");
        }
        return env.get(((AviatorJavaType)arg).getName());
    }

    public static AviatorFunction getFunction(AviatorObject arg, Map<String, Object> env, int arity) {
        if (arg.getAviatorType() != AviatorType.JavaType) {
            throw new ExpressionRuntimeException(arg.desc(env) + " is not a function");
        }
        if (arg instanceof AviatorRuntimeJavaType && arg.getValue(env) instanceof AviatorFunction) {
            return (AviatorFunction)arg.getValue(env);
        }
        String name = ((AviatorJavaType)arg).getName();
        if (name.equals("-")) {
            name = arity == 2 ? "-sub" : "-neg";
        }
        AviatorFunction rt = null;
        if (env != null) {
            rt = (AviatorFunction)env.get(name);
        }
        if (rt == null) {
            rt = AviatorEvaluator.getFunction(name);
        }
        return rt;
    }

    public static final Number getNumberValue(AviatorObject arg1, Map<String, Object> env) {
        return (Number)arg1.getValue(env);
    }
}

