/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer.token;

import com.googlecode.aviator.lexer.token.AbstractToken;
import com.googlecode.aviator.lexer.token.Token;
import java.util.Map;

public class Variable
extends AbstractToken<Object> {
    private boolean quote = false;
    public static final Variable TRUE = new Variable("true", -1){

        @Override
        public Object getValue(Map<String, Object> env) {
            return true;
        }
    };
    public static final Variable FALSE = new Variable("false", -1){

        @Override
        public Object getValue(Map<String, Object> env) {
            return false;
        }
    };
    public static final Variable NIL = new Variable("nil", -1){

        @Override
        public Object getValue(Map<String, Object> env) {
            return null;
        }
    };

    public boolean isQuote() {
        return this.quote;
    }

    public void setQuote(boolean special) {
        this.quote = special;
    }

    @Override
    public Token.TokenType getType() {
        return Token.TokenType.Variable;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        if (env != null) {
            return env.get(this.lexeme);
        }
        return this.lexeme;
    }

    public Variable(String name, int startIndex) {
        super(startIndex, name);
    }

    @Override
    public String toString() {
        return "[type='string',lexeme='$" + this.getLexeme() + "',index=" + this.getStartIndex() + "]";
    }
}

