/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.asm;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.asm.ClassWriter;
import com.googlecode.aviator.asm.Label;
import com.googlecode.aviator.asm.MethodVisitor;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.asm.ClassDefiner;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.runtime.op.OperationRuntime;
import com.googlecode.aviator.utils.TypeUtils;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;

public class ASMCodeGenerator
implements CodeGenerator {
    private static final String FIELD_PREFIX = "var_";
    private ClassWriter classWriter;
    private MethodVisitor mv;
    private final String className;
    private final AviatorClassLoader classLoader;
    private static final AtomicLong CLASS_COUNTER = new AtomicLong();
    private int operandsCount = 0;
    private int maxStacks = 0;
    private int maxLocals = 2;
    private int fieldCounter = 0;
    private final Map<String, String> innerVarMap = new HashMap<String, String>();
    private final Map<String, String> innerMethodMap = new HashMap<String, String>();
    private Map<String, Integer> varTokens = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> methodTokens = new HashMap<String, Integer>();
    private final Map<Label, Map<String, Integer>> labelNameIndexMap = new HashMap<Label, Map<String, Integer>>();
    private static final Label START_LABEL = new Label();
    private Label currentLabel = START_LABEL;
    private final Stack<Label> l0stack = new Stack();
    private final Stack<Label> l1stack = new Stack();
    private final Stack<MethodMetaData> methodMetaDataStack = new Stack();

    private void setMaxStacks(int newMaxStacks) {
        if (newMaxStacks > this.maxStacks) {
            this.maxStacks = newMaxStacks;
        }
    }

    public ASMCodeGenerator(AviatorClassLoader classLoader, OutputStream traceOut, boolean trace) {
        this.classLoader = classLoader;
        this.className = "Script_" + System.currentTimeMillis() + "_" + CLASS_COUNTER.getAndIncrement();
        this.classWriter = new ClassWriter(2);
        this.visitClass();
    }

    public void start() {
        this.makeConstructor();
        this.startVisitMethodCode();
    }

    private void startVisitMethodCode() {
        this.mv = this.classWriter.visitMethod(17, "execute0", "(Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)Ljava/lang/Object;", null);
        this.mv.visitCode();
    }

    private void endVisitMethodCode() {
        if (this.operandsCount > 0) {
            this.loadEnv();
            this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", "getValue", "(Ljava/util/Map;)Ljava/lang/Object;");
            this.mv.visitInsn(176);
            this.popOperand();
            this.popOperand();
        } else {
            this.mv.visitInsn(1);
            this.mv.visitInsn(176);
            this.pushOperand();
            this.popOperand();
        }
        if (this.operandsCount > 0) {
            throw new CompileExpressionErrorException("operand stack is not empty,count=" + this.operandsCount);
        }
        this.mv.visitMaxs(this.maxStacks, this.maxLocals);
        this.mv.visitEnd();
    }

    private void endVisitClass() {
        this.classWriter.visitEnd();
    }

    private void makeConstructor() {
        String innerName;
        String outterName;
        this.mv = this.classWriter.visitMethod(1, "<init>", "(Ljava/util/List;)V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(183, "com/googlecode/aviator/ClassExpression", "<init>", "(Ljava/util/List;)V");
        if (!this.innerVarMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.innerVarMap.entrySet()) {
                outterName = entry.getKey();
                innerName = entry.getValue();
                this.mv.visitVarInsn(25, 0);
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorJavaType");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(outterName);
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorJavaType", "<init>", "(Ljava/lang/String;)V");
                this.mv.visitFieldInsn(181, this.className, innerName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;");
            }
        }
        if (!this.innerMethodMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.innerMethodMap.entrySet()) {
                outterName = entry.getKey();
                innerName = entry.getValue();
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn(outterName);
                this.mv.visitMethodInsn(184, "com/googlecode/aviator/AviatorEvaluator", "getFunction", "(Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
                this.mv.visitFieldInsn(181, this.className, innerName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
            }
        }
        this.mv.visitInsn(177);
        this.mv.visitMaxs(4, 1);
        this.mv.visitEnd();
    }

    private void visitClass() {
        this.classWriter.visit(AviatorEvaluator.BYTECODE_VER, 33, this.className, null, "com/googlecode/aviator/ClassExpression", null);
    }

    private Label makeLabel() {
        return new Label();
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.ADD, "add");
    }

    private void loadOpType(OperatorType opType) {
        this.pushOperand();
        this.mv.visitFieldInsn(178, "com/googlecode/aviator/lexer/token/OperatorType", opType.name(), "Lcom/googlecode/aviator/lexer/token/OperatorType;");
    }

    private void popOperand() {
        --this.operandsCount;
    }

    private void popOperand(int n) {
        this.operandsCount -= n;
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.SUB, "sub");
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.MULT, "mult");
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.DIV, "div");
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.MOD, "mod");
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.loadEnv();
        this.visitLeftBranch(153, OperatorType.AND);
    }

    private void visitBoolean() {
        this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", "booleanValue", "(Ljava/util/Map;)Z");
    }

    private void pushLabel0(Label l0) {
        this.l0stack.push(l0);
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.visitRightBranch(153, OperatorType.AND);
        this.popOperand();
        this.popOperand();
        this.pushOperand();
    }

    private void visitRightBranch(int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(opType)) {
            this.loadEnv();
            String first = "TRUE";
            String second = "FALSE";
            if (opType == OperatorType.OR) {
                first = "FALSE";
                second = "TRUE";
            }
            this.visitBoolean();
            this.mv.visitJumpInsn(ints, this.peekLabel0());
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", first, "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            Label l1 = this.makeLabel();
            this.mv.visitJumpInsn(167, l1);
            this.visitLabel(this.popLabel0());
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", second, "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.visitLabel(l1);
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.loadEnv();
        this.visitBoolean();
        Label l0 = this.makeLabel();
        Label l1 = this.makeLabel();
        this.pushLabel0(l0);
        this.pushLabel1(l1);
        this.mv.visitJumpInsn(153, l0);
        this.popOperand();
        this.popOperand();
        this.pushOperand(1);
        this.popOperand();
    }

    private void pushLabel1(Label l1) {
        this.l1stack.push(l1);
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.mv.visitJumpInsn(167, this.peekLabel1());
        this.visitLabel(this.popLabel0());
        this.popOperand();
    }

    private Label peekLabel1() {
        return this.l1stack.peek();
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.visitLabel(this.popLabel1());
        this.popOperand();
    }

    private Label popLabel1() {
        return this.l1stack.pop();
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.visitRightBranch(154, OperatorType.OR);
        this.popOperand();
        this.popOperand();
        this.pushOperand();
    }

    private void visitLabel(Label label) {
        this.mv.visitLabel(label);
        this.currentLabel = label;
    }

    private Label peekLabel0() {
        return this.l0stack.peek();
    }

    private Label popLabel0() {
        return this.l0stack.pop();
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.loadEnv();
        this.visitLeftBranch(154, OperatorType.OR);
    }

    private void visitLeftBranch(int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(opType)) {
            this.visitBoolean();
            Label l0 = this.makeLabel();
            this.pushLabel0(l0);
            this.mv.visitJumpInsn(ints, l0);
            this.popOperand();
        }
        this.popOperand();
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.doCompareAndJump(154, OperatorType.EQ);
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.MATCH, "match");
        this.popOperand();
        this.pushOperand();
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.doCompareAndJump(153, OperatorType.NEQ);
    }

    private void doCompareAndJump(int ints, OperatorType opType) {
        this.loadEnv();
        this.visitCompare(ints, opType);
        this.popOperand();
        this.popOperand();
    }

    private void visitCompare(int ints, OperatorType opType) {
        if (!OperationRuntime.hasRuntimeContext(opType)) {
            this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", "compare", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;)I");
            Label l0 = this.makeLabel();
            Label l1 = this.makeLabel();
            this.mv.visitJumpInsn(ints, l0);
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "TRUE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.mv.visitJumpInsn(167, l1);
            this.visitLabel(l0);
            this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "FALSE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
            this.visitLabel(l1);
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.doCompareAndJump(155, OperatorType.GE);
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.doCompareAndJump(158, OperatorType.GT);
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.doCompareAndJump(157, OperatorType.LE);
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.doCompareAndJump(156, OperatorType.LT);
    }

    public void pushOperand(int extras) {
        ++this.operandsCount;
        this.operandsCount += extras;
        this.setMaxStacks(this.operandsCount);
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.visitUnaryOperator(OperatorType.NOT, "not");
    }

    private void visitBinOperator(OperatorType opType, String methodName) {
        if (!OperationRuntime.hasRuntimeContext(opType)) {
            if (opType == OperatorType.MATCH) {
                this.mv.visitInsn(95);
            }
            this.loadEnv();
            this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", methodName, "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadEnv();
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand();
        this.popOperand();
    }

    private void visitUnaryOperator(OperatorType opType, String methodName) {
        this.mv.visitTypeInsn(192, "com/googlecode/aviator/runtime/type/AviatorObject");
        this.loadEnv();
        if (!OperationRuntime.hasRuntimeContext(opType)) {
            this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", methodName, "(Ljava/util/Map;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadOpType(opType);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand();
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.visitUnaryOperator(OperatorType.BIT_NOT, "bitNot");
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.visitUnaryOperator(OperatorType.NEG, "neg");
    }

    @Override
    public Expression getResult() {
        this.end();
        byte[] bytes = this.classWriter.toByteArray();
        try {
            Class<?> defineClass = ClassDefiner.defineClass(this.className, bytes, this.classLoader);
            Constructor<?> constructor = defineClass.getConstructor(List.class);
            return (Expression)constructor.newInstance(new ArrayList<String>(this.varTokens.keySet()));
        }
        catch (Exception e) {
            throw new CompileExpressionErrorException("define class error", e);
        }
    }

    private void end() {
        this.endVisitMethodCode();
        this.endVisitClass();
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        if (lookhead == null) {
            return;
        }
        switch (lookhead.getType()) {
            case Number: {
                NumberToken numberToken = (NumberToken)lookhead;
                Number number = numberToken.getNumber();
                if (TypeUtils.isBigInt(number)) {
                    this.mv.visitLdcInsn(numberToken.getLexeme());
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorBigInt", "valueOf", "(Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorBigInt;");
                } else if (TypeUtils.isDecimal(number)) {
                    this.mv.visitLdcInsn(numberToken.getLexeme());
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorDecimal", "valueOf", "(Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorDecimal;");
                } else if (TypeUtils.isDouble(number)) {
                    this.mv.visitLdcInsn(number);
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorDouble", "valueOf", "(D)Lcom/googlecode/aviator/runtime/type/AviatorDouble;");
                } else {
                    this.mv.visitLdcInsn(number);
                    this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/type/AviatorLong", "valueOf", "(J)Lcom/googlecode/aviator/runtime/type/AviatorLong;");
                }
                this.pushOperand();
                break;
            }
            case String: {
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorString");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(lookhead.getValue(null));
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorString", "<init>", "(Ljava/lang/String;)V");
                this.pushOperand(2);
                this.popOperand();
                this.popOperand();
                break;
            }
            case Pattern: {
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorPattern");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(lookhead.getValue(null));
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorPattern", "<init>", "(Ljava/lang/String;)V");
                this.pushOperand(2);
                this.popOperand();
                this.popOperand();
                break;
            }
            case Variable: {
                Variable variable = (Variable)lookhead;
                if (variable.equals(Variable.TRUE)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "TRUE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
                    this.pushOperand();
                    break;
                }
                if (variable.equals(Variable.FALSE)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorBoolean", "FALSE", "Lcom/googlecode/aviator/runtime/type/AviatorBoolean;");
                    this.pushOperand();
                    break;
                }
                if (variable.equals(Variable.NIL)) {
                    this.mv.visitFieldInsn(178, "com/googlecode/aviator/runtime/type/AviatorNil", "NIL", "Lcom/googlecode/aviator/runtime/type/AviatorNil;");
                    this.pushOperand();
                    break;
                }
                String outterVarName = variable.getLexeme();
                String innerVarName = this.innerVarMap.get(outterVarName);
                if (innerVarName != null) {
                    Map<String, Integer> name2Index = this.labelNameIndexMap.get(this.currentLabel);
                    if (name2Index != null && name2Index.get(innerVarName) != null) {
                        int localIndex = name2Index.get(innerVarName);
                        this.mv.visitVarInsn(25, localIndex);
                        this.pushOperand();
                        break;
                    }
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, this.className, innerVarName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;");
                    if (this.varTokens.get(outterVarName) > 1) {
                        this.mv.visitInsn(89);
                        int localIndex = this.getLocalIndex();
                        this.mv.visitVarInsn(58, localIndex);
                        if (name2Index == null) {
                            name2Index = new HashMap<String, Integer>();
                            this.labelNameIndexMap.put(this.currentLabel, name2Index);
                        }
                        name2Index.put(innerVarName, localIndex);
                        this.pushOperand(2);
                        this.popOperand();
                        this.popOperand();
                        break;
                    }
                    this.pushOperand(1);
                    this.popOperand();
                    break;
                }
                this.mv.visitTypeInsn(187, "com/googlecode/aviator/runtime/type/AviatorJavaType");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(outterVarName);
                this.mv.visitMethodInsn(183, "com/googlecode/aviator/runtime/type/AviatorJavaType", "<init>", "(Ljava/lang/String;)V");
                this.pushOperand(2);
                this.popOperand();
                this.popOperand();
            }
        }
    }

    public void initVariables(Map<String, Integer> varTokens) {
        this.varTokens = varTokens;
        for (String outterVarName : varTokens.keySet()) {
            String innerVarName = this.getInnerName(outterVarName);
            this.innerVarMap.put(outterVarName, innerVarName);
            this.classWriter.visitField(18, innerVarName, "Lcom/googlecode/aviator/runtime/type/AviatorJavaType;", null, null).visitEnd();
        }
    }

    public void initMethods(Map<String, Integer> methods) {
        this.methodTokens = methods;
        for (String outterMethodName : methods.keySet()) {
            String innerMethodName = this.getInnerName(outterMethodName);
            this.innerMethodMap.put(outterMethodName, innerMethodName);
            this.classWriter.visitField(18, innerMethodName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;", null, null).visitEnd();
        }
    }

    private String getInnerName(String varName) {
        return FIELD_PREFIX + this.fieldCounter++;
    }

    private String getInvokeMethodDesc(int paramCount) {
        StringBuilder sb = new StringBuilder("(Ljava/util/Map;");
        if (paramCount <= 20) {
            for (int i = 0; i < paramCount; ++i) {
                sb.append("Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                sb.append("Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            }
            sb.append("[Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        }
        sb.append(")Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        return sb.toString();
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        MethodMetaData methodMetaData = this.methodMetaDataStack.pop();
        int parameterCount = methodMetaData.parameterCount;
        if (parameterCount >= 20) {
            if (parameterCount == 20) {
                this.mv.visitInsn(87);
                this.popOperand();
            } else {
                this.mv.visitMethodInsn(185, "java/util/List", "size", "()I");
                this.mv.visitTypeInsn(189, "com/googlecode/aviator/runtime/type/AviatorObject");
                int arrayIndex = this.getLocalIndex();
                this.mv.visitVarInsn(58, arrayIndex);
                this.mv.visitVarInsn(25, methodMetaData.variadicListIndex);
                this.mv.visitVarInsn(25, arrayIndex);
                this.mv.visitMethodInsn(185, "java/util/List", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                this.mv.visitTypeInsn(192, "[Lcom/googlecode/aviator/runtime/type/AviatorObject;");
                this.popOperand();
                this.pushOperand();
                this.pushOperand();
                this.popOperand();
            }
        }
        this.mv.visitMethodInsn(185, "com/googlecode/aviator/runtime/type/AviatorFunction", "call", this.getInvokeMethodDesc(parameterCount));
        this.popOperand();
        this.popOperand();
        if (parameterCount <= 20) {
            this.popOperand(parameterCount);
        } else {
            this.popOperand(21);
        }
        this.pushOperand();
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        MethodMetaData currentMethodMetaData = this.methodMetaDataStack.peek();
        if (currentMethodMetaData.parameterCount >= 20) {
            assert (currentMethodMetaData.variadicListIndex >= 0);
            this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            this.mv.visitInsn(87);
            this.mv.visitVarInsn(25, currentMethodMetaData.variadicListIndex);
            this.popOperand();
            this.popOperand();
            this.pushOperand();
            this.popOperand();
            this.pushOperand();
        }
        ++currentMethodMetaData.parameterCount;
        if (currentMethodMetaData.parameterCount == 20) {
            this.mv.visitTypeInsn(187, "java/util/ArrayList");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            int listIndex = this.getLocalIndex();
            this.mv.visitVarInsn(58, listIndex);
            this.mv.visitVarInsn(25, listIndex);
            currentMethodMetaData.variadicListIndex = listIndex;
            this.pushOperand();
        }
    }

    private void pushOperand() {
        this.pushOperand(0);
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.onConstant(lookhead);
    }

    @Override
    public void onArrayIndexStart(Token<?> token) {
        this.loadEnv();
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        if (!OperationRuntime.hasRuntimeContext(OperatorType.INDEX)) {
            this.mv.visitMethodInsn(182, "com/googlecode/aviator/runtime/type/AviatorObject", "getElement", "(Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
        } else {
            this.loadOpType(OperatorType.INDEX);
            this.mv.visitMethodInsn(184, "com/googlecode/aviator/runtime/op/OperationRuntime", "eval", "(Lcom/googlecode/aviator/runtime/type/AviatorObject;Ljava/util/Map;Lcom/googlecode/aviator/runtime/type/AviatorObject;Lcom/googlecode/aviator/lexer/token/OperatorType;)Lcom/googlecode/aviator/runtime/type/AviatorObject;");
            this.popOperand();
        }
        this.popOperand();
        this.popOperand();
        this.popOperand();
        this.pushOperand();
    }

    public int getLocalIndex() {
        return this.maxLocals++;
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        String outtterMethodName = lookhead.getLexeme();
        String innerMethodName = this.innerMethodMap.get(outtterMethodName);
        if (innerMethodName != null) {
            this.loadAviatorFunction(outtterMethodName, innerMethodName);
        } else {
            this.createAviatorFunctionObject(outtterMethodName);
        }
        this.loadEnv();
        this.methodMetaDataStack.push(new MethodMetaData(outtterMethodName));
    }

    private void loadAviatorFunction(String outterMethodName, String innerMethodName) {
        Map<String, Integer> name2Index = this.labelNameIndexMap.get(this.currentLabel);
        if (name2Index != null && name2Index.containsKey(innerMethodName)) {
            int localIndex = name2Index.get(innerMethodName);
            this.mv.visitVarInsn(25, localIndex);
            this.pushOperand();
        } else {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.className, innerMethodName, "Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
            if (this.methodTokens.get(outterMethodName) > 1) {
                this.mv.visitInsn(89);
                int localIndex = this.getLocalIndex();
                this.mv.visitVarInsn(58, localIndex);
                if (name2Index == null) {
                    name2Index = new HashMap<String, Integer>();
                    this.labelNameIndexMap.put(this.currentLabel, name2Index);
                }
                name2Index.put(innerMethodName, localIndex);
                this.pushOperand(1);
                this.popOperand();
            } else {
                this.pushOperand();
            }
        }
    }

    private void loadEnv() {
        this.pushOperand();
        this.mv.visitVarInsn(25, 1);
    }

    private void createAviatorFunctionObject(String methodName) {
        this.pushOperand();
        this.mv.visitLdcInsn(methodName);
        this.mv.visitMethodInsn(184, "com/googlecode/aviator/AviatorEvaluator", "getFunction", "(Ljava/lang/String;)Lcom/googlecode/aviator/runtime/type/AviatorFunction;");
        this.popOperand();
        this.pushOperand();
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.BIT_AND, "bitAnd");
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.BIT_OR, "bitOr");
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.BIT_XOR, "bitXor");
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.SHIFT_LEFT, "shiftLeft");
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.SHIFT_RIGHT, "shiftRight");
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.visitBinOperator(OperatorType.U_SHIFT_RIGHT, "unsignedShiftRight");
    }

    private static class MethodMetaData {
        int parameterCount = 0;
        int variadicListIndex = -1;

        public MethodMetaData(String methodName) {
        }
    }
}

