/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import java.math.MathContext;

public enum Options {
    ALWAYS_USE_DOUBLE_AS_DECIMAL,
    OPTIMIZE_LEVEL,
    MATH_CONTEXT,
    TRACE,
    ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL,
    TRACE_EVAL,
    PUT_CAPTURING_GROUPS_INTO_ENV;

    private static final Boolean TRACE_DEFAULT_VAL;
    private static final Boolean TRACE_EVAL_DEFAULT_VAL;

    public boolean isValidValue(Object val) {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: 
            case TRACE_EVAL: 
            case PUT_CAPTURING_GROUPS_INTO_ENV: 
            case TRACE: {
                return val instanceof Boolean;
            }
            case OPTIMIZE_LEVEL: {
                return val instanceof Integer && ((Integer)val == 1 || (Integer)val == 0);
            }
            case MATH_CONTEXT: {
                return val instanceof MathContext;
            }
        }
        return false;
    }

    public Object getDefaultValue() {
        switch (this) {
            case ALWAYS_USE_DOUBLE_AS_DECIMAL: 
            case ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL: {
                return false;
            }
            case OPTIMIZE_LEVEL: {
                return 1;
            }
            case MATH_CONTEXT: {
                return MathContext.DECIMAL128;
            }
            case TRACE_EVAL: {
                return TRACE_EVAL_DEFAULT_VAL;
            }
            case TRACE: {
                return TRACE_DEFAULT_VAL;
            }
            case PUT_CAPTURING_GROUPS_INTO_ENV: {
                return true;
            }
        }
        return null;
    }

    static {
        TRACE_DEFAULT_VAL = Boolean.valueOf(System.getProperty("aviator.asm.trace", "false"));
        TRACE_EVAL_DEFAULT_VAL = Boolean.valueOf(System.getProperty("aviator.trace_eval", "false"));
    }
}

