/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.Network;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

@Beta
public abstract class Traverser<N> {
    public static <N> Traverser<N> forGraph(SuccessorsFunction<N> graph) {
        Preconditions.checkNotNull(graph);
        return new GraphTraverser<N>(graph);
    }

    public static <N> Traverser<N> forTree(SuccessorsFunction<N> tree) {
        Preconditions.checkNotNull(tree);
        if (tree instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)tree).isDirected(), "Undirected graphs can never be trees.");
        }
        if (tree instanceof Network) {
            Preconditions.checkArgument(((Network)tree).isDirected(), "Undirected networks can never be trees.");
        }
        return new TreeTraverser<N>(tree);
    }

    public abstract Iterable<N> breadthFirst(N var1);

    public abstract Iterable<N> depthFirstPreOrder(N var1);

    public abstract Iterable<N> depthFirstPostOrder(N var1);

    private static enum Order {
        PREORDER,
        POSTORDER;

    }

    private static final class TreeTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> tree;

        TreeTraverser(SuccessorsFunction<N> tree) {
            this.tree = Preconditions.checkNotNull(tree);
        }

        @Override
        public Iterable<N> breadthFirst(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInTree(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new BreadthFirstIterator(startNode);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPreOrder(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInTree(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstPreOrderIterator(startNode);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPostOrder(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInTree(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstPostOrderIterator(startNode);
                }
            };
        }

        private void checkThatNodeIsInTree(N startNode) {
            this.tree.successors(startNode);
        }

        private final class DepthFirstPostOrderIterator
        extends AbstractIterator<N> {
            private final ArrayDeque<com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren> stack = new ArrayDeque();

            DepthFirstPostOrderIterator(N root) {
                this.stack.addLast((com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren)this.withChildren(root));
            }

            @Override
            protected N computeNext() {
                while (!this.stack.isEmpty()) {
                    NodeAndChildren top = (NodeAndChildren)this.stack.getLast();
                    if (top.childIterator.hasNext()) {
                        Object child = top.childIterator.next();
                        this.stack.addLast((com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren)this.withChildren(child));
                        continue;
                    }
                    this.stack.removeLast();
                    return top.node;
                }
                return this.endOfData();
            }

            com.google.common.graph.Traverser$TreeTraverser$DepthFirstPostOrderIterator.NodeAndChildren withChildren(N node) {
                return new NodeAndChildren(node, TreeTraverser.this.tree.successors(node));
            }

            private final class NodeAndChildren {
                final N node;
                final Iterator<? extends N> childIterator;

                NodeAndChildren(N node, Iterable<? extends N> children) {
                    this.node = node;
                    this.childIterator = children.iterator();
                }
            }
        }

        private final class DepthFirstPreOrderIterator
        extends UnmodifiableIterator<N> {
            private final Deque<Iterator<? extends N>> stack = new ArrayDeque();

            DepthFirstPreOrderIterator(N root) {
                this.stack.addLast(Iterators.singletonIterator(Preconditions.checkNotNull(root)));
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public N next() {
                Iterator childIterator;
                Iterator iterator = this.stack.getLast();
                Object result = Preconditions.checkNotNull(iterator.next());
                if (!iterator.hasNext()) {
                    this.stack.removeLast();
                }
                if ((childIterator = TreeTraverser.this.tree.successors(result).iterator()).hasNext()) {
                    this.stack.addLast(childIterator);
                }
                return result;
            }
        }

        private final class BreadthFirstIterator
        extends UnmodifiableIterator<N> {
            private final Queue<N> queue = new ArrayDeque();

            BreadthFirstIterator(N root) {
                this.queue.add(root);
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public N next() {
                Object current = this.queue.remove();
                Iterables.addAll(this.queue, TreeTraverser.this.tree.successors(current));
                return current;
            }
        }
    }

    private static final class GraphTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> graph;

        GraphTraverser(SuccessorsFunction<N> graph) {
            this.graph = Preconditions.checkNotNull(graph);
        }

        @Override
        public Iterable<N> breadthFirst(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInGraph(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new BreadthFirstIterator(startNode);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPreOrder(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInGraph(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstIterator(startNode, Order.PREORDER);
                }
            };
        }

        @Override
        public Iterable<N> depthFirstPostOrder(final N startNode) {
            Preconditions.checkNotNull(startNode);
            this.checkThatNodeIsInGraph(startNode);
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstIterator(startNode, Order.POSTORDER);
                }
            };
        }

        private void checkThatNodeIsInGraph(N startNode) {
            this.graph.successors(startNode);
        }

        private final class DepthFirstIterator
        extends AbstractIterator<N> {
            private final Deque<com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors> stack = new ArrayDeque<com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors>();
            private final Set<N> visited = new HashSet();
            private final Order order;

            DepthFirstIterator(N root, Order order) {
                this.stack.push((com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors)this.withSuccessors(root));
                this.order = order;
            }

            @Override
            protected N computeNext() {
                NodeAndSuccessors node;
                boolean produceNode;
                do {
                    if (this.stack.isEmpty()) {
                        return this.endOfData();
                    }
                    node = (NodeAndSuccessors)this.stack.getFirst();
                    boolean firstVisit = this.visited.add(node.node);
                    boolean lastVisit = !node.successorIterator.hasNext();
                    boolean bl = produceNode = firstVisit && this.order == Order.PREORDER || lastVisit && this.order == Order.POSTORDER;
                    if (lastVisit) {
                        this.stack.pop();
                        continue;
                    }
                    Object successor = node.successorIterator.next();
                    if (this.visited.contains(successor)) continue;
                    this.stack.push((com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors)this.withSuccessors(successor));
                } while (!produceNode);
                return node.node;
            }

            com.google.common.graph.Traverser$GraphTraverser$DepthFirstIterator.NodeAndSuccessors withSuccessors(N node) {
                return new NodeAndSuccessors(node, GraphTraverser.this.graph.successors(node));
            }

            private final class NodeAndSuccessors {
                final N node;
                final Iterator<? extends N> successorIterator;

                NodeAndSuccessors(N node, Iterable<? extends N> successors) {
                    this.node = node;
                    this.successorIterator = successors.iterator();
                }
            }
        }

        private final class BreadthFirstIterator
        extends UnmodifiableIterator<N> {
            private final Queue<N> queue = new ArrayDeque();
            private final Set<N> visited = new HashSet();

            BreadthFirstIterator(N root) {
                this.queue.add(root);
                this.visited.add(root);
            }

            @Override
            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            @Override
            public N next() {
                Object current = this.queue.remove();
                for (Object neighbor : GraphTraverser.this.graph.successors(current)) {
                    if (!this.visited.add(neighbor)) continue;
                    this.queue.add(neighbor);
                }
                return current;
            }
        }
    }
}

