/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_NamedParameterChecker_LabelledArgument;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(name="NamedParameters", summary="Parameter name in argument comment is incorrect", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class NamedParameterChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchNewClassOrMethodInvocation(ASTHelpers.getSymbol((MethodInvocationTree)tree), (ImmutableList<Commented<ExpressionTree>>)Comments.findCommentsForArguments((MethodInvocationTree)tree, (VisitorState)state), tree);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchNewClassOrMethodInvocation(ASTHelpers.getSymbol((NewClassTree)tree), (ImmutableList<Commented<ExpressionTree>>)Comments.findCommentsForArguments((NewClassTree)tree, (VisitorState)state), tree);
    }

    private Description matchNewClassOrMethodInvocation(Symbol.MethodSymbol symbol, ImmutableList<Commented<ExpressionTree>> arguments, Tree tree) {
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (NamedParameterComment.containsSyntheticParameterName(symbol)) {
            return Description.NO_MATCH;
        }
        ImmutableList<LabelledArgument> labelledArguments = LabelledArgument.createFromParametersList((List<Symbol.VarSymbol>)symbol.getParameters(), arguments);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        ImmutableList.Builder incorrectParameterDescriptions = ImmutableList.builder();
        for (LabelledArgument labelledArgument : labelledArguments) {
            switch (labelledArgument.matchedComment().matchType()) {
                case NOT_ANNOTATED: 
                case EXACT_MATCH: {
                    break;
                }
                case APPROXIMATE_MATCH: {
                    break;
                }
                case BAD_MATCH: {
                    Tokens.Comment badLabel = labelledArgument.matchedComment().comment();
                    Optional<LabelledArgument> maybeGoodTarget = NamedParameterChecker.findGoodSwap(labelledArgument, labelledArguments);
                    if (maybeGoodTarget.isPresent()) {
                        LabelledArgument argumentWithCorrectLabel = maybeGoodTarget.get();
                        fixBuilder.swap(labelledArgument.actualParameter().tree(), argumentWithCorrectLabel.actualParameter().tree());
                        if (argumentWithCorrectLabel.matchedComment().matchType() == NamedParameterComment.MatchType.NOT_ANNOTATED) {
                            NamedParameterChecker.removeComment(badLabel, fixBuilder);
                            NamedParameterChecker.addComment(argumentWithCorrectLabel, fixBuilder);
                        } else {
                            NamedParameterChecker.replaceComment(badLabel, argumentWithCorrectLabel.matchedComment().comment().getText(), fixBuilder);
                        }
                    } else {
                        NamedParameterChecker.replaceComment(badLabel, NamedParameterComment.toCommentText(labelledArgument.parameterName()), fixBuilder);
                    }
                    incorrectParameterDescriptions.add((Object)String.format("`%s` does not match formal parameter name `%s`", badLabel.getText(), labelledArgument.parameterName()));
                }
            }
        }
        if (fixBuilder.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Parameters with incorrectly labelled arguments: " + incorrectParameterDescriptions.build().stream().collect(Collectors.joining(", "))).addFix((Fix)fixBuilder.build()).build();
    }

    private static void addComment(LabelledArgument labelledArgument, SuggestedFix.Builder fixBuilder) {
        fixBuilder.prefixWith(labelledArgument.actualParameter().tree(), NamedParameterComment.toCommentText(labelledArgument.parameterName()));
    }

    private static void replaceComment(Tokens.Comment comment, String replacementText, SuggestedFix.Builder fixBuilder) {
        int commentStart = comment.getSourcePos(0);
        int commentEnd = commentStart + comment.getText().length();
        fixBuilder.replace(commentStart, commentEnd, replacementText);
    }

    private static void removeComment(Tokens.Comment comment, SuggestedFix.Builder fixBuilder) {
        NamedParameterChecker.replaceComment(comment, "", fixBuilder);
    }

    private static Optional<LabelledArgument> findGoodSwap(LabelledArgument source, ImmutableList<LabelledArgument> allArguments) {
        for (LabelledArgument target : allArguments) {
            boolean targetLabelMatchesSource;
            if (source.equals(target)) continue;
            boolean sourceLabelMatchesTarget = NamedParameterComment.match(source.actualParameter(), target.parameterName()).matchType() == NamedParameterComment.MatchType.EXACT_MATCH;
            NamedParameterComment.MatchType targetCommentMatch = NamedParameterComment.match(target.actualParameter(), source.parameterName()).matchType();
            boolean bl = targetLabelMatchesSource = targetCommentMatch == NamedParameterComment.MatchType.EXACT_MATCH || targetCommentMatch == NamedParameterComment.MatchType.NOT_ANNOTATED;
            if (!sourceLabelMatchesTarget || !targetLabelMatchesSource) continue;
            return Optional.of(target);
        }
        return Optional.empty();
    }

    static abstract class LabelledArgument {
        LabelledArgument() {
        }

        abstract String parameterName();

        abstract Commented<ExpressionTree> actualParameter();

        abstract NamedParameterComment.MatchedComment matchedComment();

        static ImmutableList<LabelledArgument> createFromParametersList(List<Symbol.VarSymbol> parameters, ImmutableList<Commented<ExpressionTree>> actualParameters) {
            return (ImmutableList)Streams.zip((Stream)actualParameters.stream(), parameters.stream(), (actualParameter, formalParameter) -> {
                String formalParameterName = ((Name)formalParameter.getSimpleName()).toString();
                return new AutoValue_NamedParameterChecker_LabelledArgument(formalParameterName, (Commented<ExpressionTree>)actualParameter, NamedParameterComment.match((Commented<ExpressionTree>)actualParameter, formalParameterName));
            }).collect(ImmutableList.toImmutableList());
        }
    }
}

