/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Equivalence;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Range;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

@BugPattern(name="UnnecessarySetDefault", summary="Unnecessary call to NullPointerTester#setDefault", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UnnecessarySetDefault
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> SET_DEFAULT = MethodMatchers.instanceMethod().onExactClass("com.google.common.testing.NullPointerTester").withSignature("<T>setDefault(java.lang.Class<T>,T)");
    @VisibleForTesting
    static final ImmutableMap<String, Matcher<ExpressionTree>> DEFAULTS = ImmutableMap.builder().put((Object)"java.lang.reflect.Type", UnnecessarySetDefault.sourceMatcher("Object.class")).put((Object)"java.lang.reflect.GenericDeclaration", UnnecessarySetDefault.sourceMatcher("Object.class")).put((Object)"java.lang.reflect.AnnotatedElement", UnnecessarySetDefault.sourceMatcher("Object.class")).put((Object)"com.google.common.collect.SortedMapDifference", UnnecessarySetDefault.sourceMatcher("Maps.difference(ImmutableSortedMap.of(), ImmutableSortedMap.of())")).put((Object)"com.google.common.collect.MapDifference", UnnecessarySetDefault.sourceMatcher("Maps.difference(ImmutableMap.of(), ImmutableMap.of())")).put((Object)"com.google.common.collect.Range", (Object)UnnecessarySetDefault.factoryMatcher(Range.class, "all")).put((Object)"com.google.common.collect.ImmutableClassToInstanceMap", UnnecessarySetDefault.sourceMatcher("ImmutableClassToInstanceMap.builder().build()")).put((Object)"com.google.common.collect.ClassToInstanceMap", UnnecessarySetDefault.sourceMatcher("ImmutableClassToInstanceMap.builder().build()")).put((Object)"com.google.common.collect.RowSortedTable", UnnecessarySetDefault.sourceMatcher("Tables.unmodifiableRowSortedTable(TreeBasedTable.create())")).put((Object)"com.google.common.collect.ImmutableTable", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableTable.class, "of")).put((Object)"com.google.common.collect.Table", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableTable.class, "of")).put((Object)"com.google.common.collect.ImmutableBiMap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableBiMap.class, "of")).put((Object)"com.google.common.collect.BiMap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableBiMap.class, "of")).put((Object)"com.google.common.collect.ImmutableSortedMultiset", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedMultiset.class, "of")).put((Object)"com.google.common.collect.SortedMultiset", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedMultiset.class, "of")).put((Object)"com.google.common.collect.ImmutableMultiset", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMultiset.class, "of")).put((Object)"com.google.common.collect.Multiset", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMultiset.class, "of")).put((Object)"com.google.common.collect.SortedSetMultimap", UnnecessarySetDefault.sourceMatcher("Multimaps.unmodifiableSortedSetMultimap(TreeMultimap.create())")).put((Object)"com.google.common.collect.ImmutableSetMultimap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSetMultimap.class, "of")).put((Object)"com.google.common.collect.SetMultimap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSetMultimap.class, "of")).put((Object)"com.google.common.collect.ImmutableListMultimap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableListMultimap.class, "of")).put((Object)"com.google.common.collect.ListMultimap", (Object)UnnecessarySetDefault.factoryMatcher(ListMultimap.class, "of")).put((Object)"com.google.common.collect.ImmutableMultimap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMultimap.class, "of")).put((Object)"com.google.common.collect.Multimap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMultimap.class, "of")).put((Object)"java.util.NavigableMap", UnnecessarySetDefault.sourceMatcher("Maps.unmodifiableNavigableMap(Maps.newTreeMap())")).put((Object)"com.google.common.collect.ImmutableSortedMap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedMap.class, "of")).put((Object)"java.util.SortedMap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedMap.class, "of")).put((Object)"com.google.common.collect.ImmutableMap", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMap.class, "of")).put((Object)"java.util.Map", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableMap.class, "of")).put((Object)"java.util.NavigableSet", UnnecessarySetDefault.sourceMatcher("Sets.unmodifiableNavigableSet(Sets.newTreeSet())")).put((Object)"com.google.common.collect.ImmutableSortedSet", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedSet.class, "of")).put((Object)"java.util.SortedSet", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSortedSet.class, "of")).put((Object)"com.google.common.collect.ImmutableSet", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSet.class, "of")).put((Object)"java.util.Set", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSet.class, "of")).put((Object)"com.google.common.collect.ImmutableList", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableList.class, "of")).put((Object)"java.util.List", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableList.class, "of")).put((Object)"com.google.common.collect.ImmutableCollection", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableList.class, "of")).put((Object)"java.util.Collection", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableList.class, "of")).put((Object)"java.lang.Iterable", (Object)UnnecessarySetDefault.factoryMatcher(ImmutableSet.class, "of")).put((Object)"java.util.ListIterator", UnnecessarySetDefault.sourceMatcher("ImmutableList.of().listIterator()")).put((Object)"com.google.common.collect.PeekingIterator", UnnecessarySetDefault.sourceMatcher("Iterators.peekingIterator(ImmutableSet.of().iterator())")).put((Object)"java.util.Iterator", UnnecessarySetDefault.sourceMatcher("ImmutableSet.of().iterator()")).put((Object)"com.google.common.io.CharSource", (Object)UnnecessarySetDefault.factoryMatcher(CharSource.class, "empty")).put((Object)"com.google.common.io.ByteSource", (Object)UnnecessarySetDefault.factoryMatcher(ByteSource.class, "empty")).put((Object)"java.io.File", UnnecessarySetDefault.sourceMatcher("new File(\"\")")).put((Object)"java.nio.DoubleBuffer", UnnecessarySetDefault.sourceMatcher("DoubleBuffer.allocate(0)")).put((Object)"java.nio.FloatBuffer", UnnecessarySetDefault.sourceMatcher("FloatBuffer.allocate(0)")).put((Object)"java.nio.LongBuffer", UnnecessarySetDefault.sourceMatcher("LongBuffer.allocate(0)")).put((Object)"java.nio.IntBuffer", UnnecessarySetDefault.sourceMatcher("IntBuffer.allocate(0)")).put((Object)"java.nio.ShortBuffer", UnnecessarySetDefault.sourceMatcher("ShortBuffer.allocate(0)")).put((Object)"java.nio.ByteBuffer", UnnecessarySetDefault.sourceMatcher("ByteBuffer.allocate(0)")).put((Object)"java.nio.CharBuffer", UnnecessarySetDefault.sourceMatcher("CharBuffer.allocate(0)")).put((Object)"java.nio.Buffer", UnnecessarySetDefault.sourceMatcher("ByteBuffer.allocate(0)")).put((Object)"java.io.StringReader", UnnecessarySetDefault.sourceMatcher("new StringReader(\"\")")).put((Object)"java.io.Reader", UnnecessarySetDefault.sourceMatcher("new StringReader(\"\")")).put((Object)"java.lang.Readable", UnnecessarySetDefault.sourceMatcher("new StringReader(\"\")")).put((Object)"java.io.ByteArrayInputStream", UnnecessarySetDefault.sourceMatcher("new ByteArrayInputStream(new byte[0])")).put((Object)"java.io.InputStream", UnnecessarySetDefault.sourceMatcher("new ByteArrayInputStream(new byte[0])")).put((Object)"com.google.common.base.Stopwatch", (Object)UnnecessarySetDefault.factoryMatcher(Stopwatch.class, "createUnstarted")).put((Object)"com.google.common.base.Ticker", (Object)UnnecessarySetDefault.factoryMatcher(Ticker.class, "systemTicker")).put((Object)"com.google.common.base.Equivalence", (Object)UnnecessarySetDefault.factoryMatcher(Equivalence.class, "equals")).put((Object)"com.google.common.base.Predicate", (Object)UnnecessarySetDefault.factoryMatcher(Predicates.class, "alwaysTrue")).put((Object)"com.google.common.base.Optional", (Object)UnnecessarySetDefault.factoryMatcher(com.google.common.base.Optional.class, "absent")).put((Object)"com.google.common.base.Splitter", UnnecessarySetDefault.sourceMatcher("Splitter.on(',')")).put((Object)"com.google.common.base.Joiner", UnnecessarySetDefault.sourceMatcher("Joiner.on(',')")).put((Object)"com.google.common.base.CharMatcher", (Object)UnnecessarySetDefault.factoryMatcher(CharMatcher.class, "none")).put((Object)"java.util.Locale", UnnecessarySetDefault.sourceMatcher("Locale.US")).put((Object)"java.util.Currency", UnnecessarySetDefault.sourceMatcher("Currency.getInstance(Locale.US)")).put((Object)"java.nio.charset.Charset", UnnecessarySetDefault.sourceMatcher("Charsets.UTF_8")).put((Object)"java.util.concurrent.TimeUnit", UnnecessarySetDefault.sourceMatcher("TimeUnit.SECONDS")).put((Object)"java.util.regex.Pattern", UnnecessarySetDefault.sourceMatcher("Pattern.compile(\"\")")).put((Object)"java.lang.String", UnnecessarySetDefault.sourceMatcher("\"\"")).put((Object)"java.lang.CharSequence", UnnecessarySetDefault.sourceMatcher("\"\"")).put((Object)"java.math.BigDecimal", UnnecessarySetDefault.sourceMatcher("BigDecimal.ZERO")).put((Object)"java.math.BigInteger", UnnecessarySetDefault.sourceMatcher("BigInteger.ZERO")).put((Object)"com.google.common.primitives.UnsignedLong", UnnecessarySetDefault.sourceMatcher("UnsignedLong.ZERO")).put((Object)"com.google.common.primitives.UnsignedInteger", UnnecessarySetDefault.sourceMatcher("UnsignedInteger.ZERO")).put((Object)"java.lang.Number", UnnecessarySetDefault.sourceMatcher("0")).put((Object)"java.lang.Object", UnnecessarySetDefault.sourceMatcher("\"\"")).put((Object)"Optional.class", (Object)UnnecessarySetDefault.factoryMatcher(Optional.class, "empty")).put((Object)"OptionalInt.class", (Object)UnnecessarySetDefault.factoryMatcher(OptionalInt.class, "empty")).put((Object)"OptionalLong.class", (Object)UnnecessarySetDefault.factoryMatcher(OptionalLong.class, "empty")).put((Object)"OptionalDouble.class", (Object)UnnecessarySetDefault.factoryMatcher(OptionalDouble.class, "empty")).build();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SET_DEFAULT.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType((Tree)tree.getArguments().get(0));
        if (type == null) {
            return Description.NO_MATCH;
        }
        Type classType = state.getTypes().asSuper(type, state.getSymtab().classType.asElement());
        if (classType == null || classType.getTypeArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        String defaultTypeName = ((Type)Iterables.getOnlyElement(classType.getTypeArguments())).asElement().getQualifiedName().toString();
        if (!DEFAULTS.containsKey((Object)defaultTypeName)) {
            return Description.NO_MATCH;
        }
        Matcher defaultType = (Matcher)DEFAULTS.get((Object)defaultTypeName);
        if (!defaultType.matches((Tree)tree.getArguments().get(1), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        Tree ancestor = state.getPath().getParentPath().getLeaf();
        if (ancestor instanceof ExpressionStatementTree) {
            description.addFix((Fix)SuggestedFix.delete((Tree)ancestor));
        } else if (receiver != null) {
            description.addFix((Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)receiver), (int)state.getEndPosition((Tree)tree), (String)""));
        }
        return description.build();
    }

    private static MethodMatchers.ParameterMatcher factoryMatcher(Class<?> clazz, String name) {
        return MethodMatchers.staticMethod().onClass(clazz.getCanonicalName()).named(name).withParameters(new String[0]);
    }

    static Matcher<ExpressionTree> sourceMatcher(String source) {
        return (Matcher & Serializable)(tree, state) -> state.getSourceForNode(tree).equals(source);
    }
}

