/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ImmutableCollections;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="MutableConstantField", category=BugPattern.Category.JDK, summary="Constant field declarations should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List)", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class MutableConstantField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final SimpleTreeVisitor<Tree, Void> GET_TYPE_TREE_VISITOR = new SimpleTreeVisitor<Tree, Void>(){

        @Override
        public Tree visitIdentifier(IdentifierTree tree, Void unused) {
            return tree;
        }

        @Override
        public Tree visitParameterizedType(ParameterizedTypeTree tree, Void unused) {
            return tree.getType();
        }
    };

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!MutableConstantField.isConstantField(ASTHelpers.getSymbol((VariableTree)tree))) {
            return Description.NO_MATCH;
        }
        ExpressionTree rhsTree = tree.getInitializer();
        Type rhsType = ASTHelpers.getType((Tree)rhsTree);
        if (rhsType == null || !ImmutableCollections.isImmutableType(rhsType)) {
            return Description.NO_MATCH;
        }
        Tree lhsTree = tree.getType();
        Type lhsType = ASTHelpers.getType((Tree)lhsTree);
        if (lhsType == null || ImmutableCollections.isImmutableType(lhsType)) {
            return Description.NO_MATCH;
        }
        String lhsTypeQualifiedName = MutableConstantField.getTypeQualifiedName(lhsType);
        String newLhsTypeQualifiedName = ImmutableCollections.mutableToImmutable(lhsTypeQualifiedName).orElse(MutableConstantField.getTypeQualifiedName(rhsType));
        Type newLhsType = state.getTypeFromString(newLhsTypeQualifiedName);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(MutableConstantField.getTypeTree(lhsTree), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (Symbol)newLhsType.asElement()));
        SuggestedFix fix = fixBuilder.build();
        return this.describeMatch(lhsTree, (Fix)fix);
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }

    private static boolean isConstantField(Symbol sym) {
        return sym.getKind() == ElementKind.FIELD && MutableConstantField.isStaticFinalField(sym) && MutableConstantField.isConstantFieldName(sym.getSimpleName().toString());
    }

    private static boolean isStaticFinalField(Symbol sym) {
        return sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isConstantFieldName(String fieldName) {
        return fieldName.toUpperCase().equals(fieldName);
    }

    private static Tree getTypeTree(Tree tree) {
        return tree.accept(GET_TYPE_TREE_VISITOR, null);
    }
}

