/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit4TestNotRun", summary="This looks like a test method but is not run; please add @Test or @Ignore, or, if this is a helper method, reduce its visibility.", explanation="Unlike in JUnit 3, JUnit 4 tests will not be run unless annotated with @Test. The test method that triggered this error looks like it was meant to be a test, but was not so annotated, so it will not be run. If you intend for this test method not to run, please add both an @Test and an @Ignore annotation to make it clear that you are purposely disabling it. If this is a helper method and not a test, consider reducing its visibility to non-public, if possible.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TestNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String TEST_CLASS = "org.junit.Test";
    private static final String IGNORE_CLASS = "org.junit.Ignore";
    private static final String TEST_ANNOTATION = "@Test ";
    private static final String IGNORE_ANNOTATION = "@Ignore ";
    private final Matcher<MethodTree> possibleTestMethod = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[0]), Matchers.not((Matcher)JUnitMatchers.hasJUnitAnnotation), Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit4TestClass)});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!this.possibleTestMethod.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        if (JUnitMatchers.isJunit3TestCase.matches((Tree)methodTree, state)) {
            return this.describeFixes(methodTree, state);
        }
        List<? extends AnnotationTree> annotations = methodTree.getModifiers().getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.STATIC)).matches((Tree)methodTree, state) && JUnitMatchers.containsTestMethod((Tree)methodTree) && !JUnit4TestNotRun.calledElsewhere(methodTree, state)) {
            return this.describeFixes(methodTree, state);
        }
        return Description.NO_MATCH;
    }

    private static boolean calledElsewhere(MethodTree methodTree, VisitorState state) {
        final Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (methodSymbol == null) {
            return false;
        }
        return ((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})).accept(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                if (methodSymbol.equals(ASTHelpers.getSymbol((Tree)callTree.getMethodSelect()))) {
                    return true;
                }
                return (Boolean)super.visitMethodInvocation(callTree, unused);
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                r1 = r1 == null ? false : r1;
                r2 = r2 == null ? false : r2;
                return r1 != false || r2 != false;
            }
        }, null);
    }

    private Description describeFixes(MethodTree methodTree, VisitorState state) {
        Optional removeStatic = SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC});
        SuggestedFix testFix = SuggestedFix.builder().merge((SuggestedFix)removeStatic.orElse(null)).addImport(TEST_CLASS).prefixWith((Tree)methodTree, TEST_ANNOTATION).build();
        SuggestedFix ignoreFix = SuggestedFix.builder().merge(testFix).addImport(IGNORE_CLASS).prefixWith((Tree)methodTree, IGNORE_ANNOTATION).build();
        SuggestedFix visibilityFix = SuggestedFix.builder().merge((SuggestedFix)SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC}).orElse(null)).merge((SuggestedFix)SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PRIVATE}).orElse(null)).build();
        String methodName = methodTree.getName().toString();
        if (methodName.startsWith("disabl") || methodName.startsWith("ignor")) {
            return this.buildDescription(methodTree).addFix((Fix)ignoreFix).addFix((Fix)testFix).addFix((Fix)visibilityFix).build();
        }
        return this.buildDescription(methodTree).addFix((Fix)testFix).addFix((Fix)ignoreFix).addFix((Fix)visibilityFix).build();
    }
}

