/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

@BugPattern(name="FunctionalInterfaceClash", summary="Overloads will be ambiguous when passing lambda arguments", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class FunctionalInterfaceClash
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.MethodSymbol msym;
        Symbol.ClassSymbol origin = ASTHelpers.getSymbol((ClassTree)tree);
        Types types = state.getTypes();
        HashMultimap methods = HashMultimap.create();
        for (Symbol symbol : types.membersClosure(ASTHelpers.getType((ClassTree)tree), false).getSymbols()) {
            if (!(symbol instanceof Symbol.MethodSymbol) || this.isBugCheckerSuppressed((Symbol.MethodSymbol)symbol) || (msym = (Symbol.MethodSymbol)symbol).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state)) || msym.isConstructor() && !msym.owner.equals(origin)) continue;
            methods.put((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, msym), (Object)msym);
        }
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof MethodTree) || (msym = ASTHelpers.getSymbol((MethodTree)((MethodTree)tree2))).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types, state))) continue;
            ArrayList clash = new ArrayList(methods.removeAll((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, msym)));
            ArrayDeque<Symbol.MethodSymbol> worklist = new ArrayDeque<Symbol.MethodSymbol>();
            worklist.push(msym);
            clash.remove(msym);
            while (!worklist.isEmpty()) {
                Symbol.MethodSymbol msym2 = (Symbol.MethodSymbol)worklist.removeFirst();
                ImmutableList overrides = (ImmutableList)clash.stream().filter(m -> msym2.overrides((Symbol)m, origin, types, false)).collect(ImmutableList.toImmutableList());
                worklist.addAll((Collection<Symbol.MethodSymbol>)overrides);
                clash.removeAll((Collection<?>)overrides);
            }
            if (clash.isEmpty()) continue;
            String message = "When passing lambda arguments to this function, callers will need a cast to disambiguate with: " + clash.stream().map(m -> Signatures.prettyMethodSignature((Symbol.ClassSymbol)origin, (Symbol.MethodSymbol)m)).collect(Collectors.joining("\n    "));
            state.reportMatch(this.buildDescription(tree2).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    private static String functionalInterfaceSignature(VisitorState state, Symbol.MethodSymbol msym) {
        return String.format("%s(%s)", msym.getSimpleName(), msym.getParameters().stream().map(p -> FunctionalInterfaceClash.functionalInterfaceSignature(state, p.type)).collect(Collectors.joining(",")));
    }

    private static String functionalInterfaceSignature(VisitorState state, Type type) {
        Types types = state.getTypes();
        if (!FunctionalInterfaceClash.maybeFunctionalInterface(type, types, state)) {
            return Signatures.descriptor((Type)type, (Types)types);
        }
        Type descriptorType = types.findDescriptorType(type);
        List<Type> fiparams = descriptorType.getParameterTypes();
        String result = fiparams.isEmpty() ? Signatures.descriptor((Type)descriptorType.getReturnType(), (Types)types) : "_";
        return String.format("(%s)->%s", fiparams.stream().map(t -> Signatures.descriptor((Type)t, (Types)types)).collect(Collectors.joining(",")), result);
    }

    private static boolean maybeFunctionalInterface(Type type, Types types, VisitorState state) {
        try {
            return types.isFunctionalInterface(type);
        }
        catch (Symbol.CompletionFailure e) {
            Check.instance(state.context).completionError((JCDiagnostic.DiagnosticPosition)((Object)state.getPath().getLeaf()), e);
            return false;
        }
    }

    private boolean isBugCheckerSuppressed(Symbol.MethodSymbol method) {
        SuppressWarnings suppression = (SuppressWarnings)ASTHelpers.getAnnotation((Symbol)method, SuppressWarnings.class);
        return suppression != null && !Collections.disjoint(Arrays.asList(suppression.value()), this.allNames());
    }
}

