/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="FilesLinesLeak", category=BugPattern.Category.JDK, summary="The stream returned by Files.lines should be closed using try-with-resources", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class FilesLinesLeak
extends AbstractMustBeClosedChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.Files").named("lines");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return super.matchNewClassOrMethodInvocation(tree, state);
    }

    @Override
    protected void addFix(Description.Builder description, Tree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof MemberSelectTree) {
            MemberSelectTree select = (MemberSelectTree)parent;
            StatementTree statement = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (statement instanceof VariableTree) {
                VariableTree var = (VariableTree)statement;
                int pos = ((JCTree)((Object)var)).getStartPosition();
                int initPos = ((JCTree)((Object)var.getInitializer())).getStartPosition();
                int eqPos = pos + state.getSourceForNode((Tree)var).substring(0, initPos - pos).lastIndexOf(61);
                fix.replace(eqPos, initPos, String.format(";\ntry (Stream<String> stream = %s) {\n%s =", state.getSourceForNode(tree), var.getName().toString()));
            } else {
                fix.prefixWith((Tree)statement, String.format("try (Stream<String> stream = %s) {\n", state.getSourceForNode(tree)));
                fix.replace((Tree)select.getExpression(), "stream");
            }
            fix.replace(tree, "stream");
            fix.postfixWith((Tree)statement, "}");
            fix.addImport("java.util.stream.Stream");
            description.addFix((Fix)fix.build());
        }
    }
}

