/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@BugPattern(name="AssertionFailureIgnored", summary="This assertion throws an AssertionError if it fails, which will be caught by an enclosing try block.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"}, category=BugPattern.Category.JDK)
public class AssertionFailureIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERTION = MethodMatchers.staticMethod().onClassAny(new String[]{"org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase"}).withNameMatching(Pattern.compile("fail|assert.*"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ASSERTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        JCTree.JCTry tryStatement = AssertionFailureIgnored.enclosingTry(state);
        if (tryStatement == null) {
            return Description.NO_MATCH;
        }
        if (!AssertionFailureIgnored.catchesType(tryStatement, state.getSymtab().assertionErrorType, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        AssertionFailureIgnored.buildFix(tryStatement, tree, state).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    private static Optional<Fix> buildFix(JCTree.JCTry tryStatement, MethodInvocationTree tree, VisitorState state) {
        int endPosition;
        int startPosition;
        boolean expression;
        if (!((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).contentEquals("fail")) {
            return Optional.empty();
        }
        JCTree.JCBlock block = tryStatement.getBlock();
        if (!Matchers.expressionStatement((Matcher & Serializable)(t, s) -> t.equals(tree)).matches((Tree)Iterables.getLast((Iterable)block.getStatements()), state)) {
            return Optional.empty();
        }
        if (((List)tryStatement.getCatches()).size() != 1) {
            return Optional.empty();
        }
        JCTree.JCCatch catchTree = (JCTree.JCCatch)Iterables.getOnlyElement((Iterable)tryStatement.getCatches());
        if (catchTree.getParameter().getType().getKind() == Tree.Kind.UNION_TYPE) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        boolean bl = expression = ((List)block.getStatements()).size() == 2 && ((JCTree.JCStatement)((List)block.getStatements()).get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        if (expression) {
            JCTree.JCExpressionStatement expressionTree = (JCTree.JCExpressionStatement)((List)block.getStatements()).get(0);
            startPosition = expressionTree.getStartPosition();
            endPosition = state.getEndPosition((Tree)expressionTree.getExpression());
        } else {
            startPosition = block.getStartPosition();
            endPosition = ((JCTree.JCStatement)Iterables.getLast((Iterable)tryStatement.getBlock().getStatements())).getStartPosition();
        }
        if (((List)catchTree.getBlock().getStatements()).isEmpty()) {
            fix.addStaticImport("org.junit.Assert.assertThrows");
            fix.replace(tryStatement.getStartPosition(), startPosition, String.format("assertThrows(%s.class, () -> ", state.getSourceForNode((Tree)catchTree.getParameter().getType()))).replace(endPosition, state.getEndPosition((Tree)catchTree), (expression ? "" : "}") + ");\n");
        } else {
            fix.addStaticImport("org.junit.Assert.expectThrows").prefixWith((Tree)tryStatement, state.getSourceForNode((Tree)catchTree.getParameter())).replace(tryStatement.getStartPosition(), startPosition, String.format(" = expectThrows(%s.class, () -> ", state.getSourceForNode((Tree)catchTree.getParameter().getType()))).replace(endPosition, ((JCTree.JCStatement)((List)catchTree.getBlock().getStatements()).get(0)).getStartPosition(), (expression ? "" : "}") + ");\n").replace(state.getEndPosition((Tree)Iterables.getLast((Iterable)catchTree.getBlock().getStatements())), state.getEndPosition((Tree)catchTree), "");
        }
        return Optional.of(fix.build());
    }

    private static boolean catchesType(JCTree.JCTry tryStatement, Type assertionErrorType, VisitorState state) {
        return tryStatement.getCatches().stream().map(catchTree -> ASTHelpers.getType((Tree)catchTree.getParameter())).flatMap(type -> type.isUnion() ? Streams.stream(((Type.UnionClassType)type).getAlternativeTypes()) : Stream.of(type)).anyMatch(caught -> ASTHelpers.isSubtype((Type)assertionErrorType, (Type)caught, (VisitorState)state));
    }

    private static JCTree.JCTry enclosingTry(VisitorState state) {
        Tree prev = null;
        for (Tree parent : state.getPath()) {
            switch (parent.getKind()) {
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    return null;
                }
                case TRY: {
                    JCTree.JCTry tryStatement = (JCTree.JCTry)parent;
                    return tryStatement.getBlock().equals(prev) ? tryStatement : null;
                }
            }
            prev = parent;
        }
        return null;
    }
}

