/*
 * Decompiled with CFR 0.152.
 */
package oe.maven.plugins.revision;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oe.maven.plugins.revision.Entry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionMojo
extends AbstractMojo {
    private MavenProject project;
    private Entry[] entries;
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.entries == null) {
            this.logDebug("entries configuration is not specified, creating default entry");
            this.entries = new Entry[]{new Entry(this.project.getBasedir(), this.project.getArtifactId())};
        } else if (this.entries.length == 0) {
            throw new MojoExecutionException("entries list is empty");
        }
        SVNStatusClient statusClient = SVNClientManager.newInstance().getStatusClient();
        for (Entry entry : this.entries) {
            if (entry.getPath() == null) {
                this.logDebug("entry path is not specified, using project.basedir: " + this.project.getBasedir());
                entry.setPath(this.project.getBasedir());
            }
            if (entry.getPrefix() == null) {
                this.logDebug("entry properties prefix is not specified, using project.artifactId: " + this.project.getArtifactId());
                entry.setPrefix(this.project.getArtifactId());
            }
            entry.validate();
            Map<String, Object> entryProperties = this.getEntryProperties(entry, statusClient);
            this.setProjectProperties(entry.getPrefix(), entryProperties);
        }
    }

    private Map<String, Object> getEntryProperties(Entry entry, SVNStatusClient statusClient) throws MojoExecutionException {
        SVNStatus svnStatus;
        this.logInfo("inspecting " + entry.getPath());
        this.logDebugInfo("  properties prefix = " + entry.getPrefix());
        this.logDebugInfo("  recursive = " + entry.isRecursive());
        this.logDebugInfo("  report unversioned = " + entry.reportUnversioned());
        this.logDebugInfo("  report ignored = " + entry.reportIgnored());
        this.logDebugInfo("  report out-of-date = " + entry.reportOutOfDate());
        try {
            svnStatus = statusClient.doStatus(entry.getPath(), false);
        }
        catch (SVNException ignored) {
            svnStatus = null;
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (svnStatus == null) {
            this.logDebugInfo(" the path is not under version control");
            properties.put("repository", "");
            properties.put("path", "");
            properties.put("revision", -1L);
            properties.put("mixedRevisions", "false");
            properties.put("committedRevision", -1L);
            properties.put("status", Character.valueOf(EntryStatusSymbols.DEFAULT.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED)));
            properties.put("specialStatus", Character.valueOf(EntryStatusSymbols.SPECIAL.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED)));
        } else {
            SVNEntry svnEntry = svnStatus.getEntry();
            String repositoryRoot = svnEntry.getRepositoryRoot();
            String repositoryPath = svnEntry.getURL().substring(repositoryRoot.length());
            if (repositoryPath.startsWith("/")) {
                repositoryPath = repositoryPath.substring(1);
            }
            EntryStatusHandler entryStatusHandler = new EntryStatusHandler();
            try {
                this.logDebugInfo(" collecting status information");
                statusClient.doStatus(entry.getPath(), SVNRevision.UNDEFINED, entry.isRecursive() ? SVNDepth.INFINITY : SVNDepth.EMPTY, entry.reportOutOfDate(), true, entry.reportIgnored(), false, (ISVNStatusHandler)entryStatusHandler, null);
            }
            catch (SVNException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            properties.put("repository", repositoryRoot);
            properties.put("path", repositoryPath);
            properties.put("revision", entryStatusHandler.getMaximumRevisionNumber());
            properties.put("mixedRevisions", entryStatusHandler.isMixedRevisions());
            properties.put("committedRevision", entryStatusHandler.getMaximumCommittedRevisionNumber());
            properties.put("status", this.constructStatus(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.DEFAULT));
            properties.put("specialStatus", this.constructStatus(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.SPECIAL));
        }
        return properties;
    }

    private String constructStatus(Entry entry, Set<SVNStatusType> localStatusTypes, Set<SVNStatusType> remoteStatusTypes, EntryStatusSymbols symbols) {
        StringBuilder status = new StringBuilder();
        localStatusTypes.remove(SVNStatusType.STATUS_NONE);
        localStatusTypes.remove(SVNStatusType.STATUS_NORMAL);
        if (localStatusTypes.remove(SVNStatusType.STATUS_ADDED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_ADDED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_CONFLICTED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_CONFLICTED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_DELETED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_DELETED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_IGNORED) && entry.reportIgnored()) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_IGNORED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_MODIFIED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MODIFIED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_REPLACED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_REPLACED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_EXTERNAL)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_EXTERNAL));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_UNVERSIONED) && entry.reportUnversioned()) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_MISSING)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MISSING));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_INCOMPLETE)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_INCOMPLETE));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_OBSTRUCTED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_OBSTRUCTED));
        }
        if (!localStatusTypes.isEmpty()) {
            this.logWarning("the following svn statuses are not taken into account: " + localStatusTypes);
        }
        remoteStatusTypes.remove(SVNStatusType.STATUS_NONE);
        if (!remoteStatusTypes.isEmpty() && entry.reportOutOfDate()) {
            status.append(symbols.getOutOfDateSymbol());
        }
        return status.toString();
    }

    private void setProjectProperties(String prefix, Map<String, Object> entryProperties) {
        this.logDebugInfo(" setting properties");
        for (Map.Entry<String, Object> entryProperty : entryProperties.entrySet()) {
            this.setProjectProperty(prefix + '.' + entryProperty.getKey(), String.valueOf(entryProperty.getValue()));
        }
    }

    private void setProjectProperty(String name, String value) {
        Properties projectProperties = this.project.getProperties();
        if (projectProperties.getProperty(name) != null) {
            this.logWarning("the \"" + name + "\" property is already defined, its value will be overwritten. Consider another value for the entry properties prefix.");
        }
        projectProperties.setProperty(name, value);
        this.logDebugInfo("  " + name + " = " + value);
    }

    private void logInfo(CharSequence message) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(message);
        }
    }

    private void logWarning(CharSequence message) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn(message);
        }
    }

    private void logDebugInfo(CharSequence message) {
        if (this.verbose) {
            this.getLog().info(message);
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(message);
        }
    }

    private void logDebug(CharSequence message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(message);
        }
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private static class EntryStatusSymbols {
        public static final EntryStatusSymbols DEFAULT = new EntryStatusSymbols();
        public static final EntryStatusSymbols SPECIAL = new EntryStatusSymbols(){

            public char getStatusSymbol(SVNStatusType svnStatusType) {
                if (SVNStatusType.STATUS_UNVERSIONED.equals(svnStatusType)) {
                    return 'u';
                }
                if (SVNStatusType.STATUS_MISSING.equals(svnStatusType)) {
                    return 'm';
                }
                if (SVNStatusType.STATUS_INCOMPLETE.equals(svnStatusType)) {
                    return 'i';
                }
                if (SVNStatusType.STATUS_OBSTRUCTED.equals(svnStatusType)) {
                    return 'o';
                }
                return super.getStatusSymbol(svnStatusType);
            }

            public char getOutOfDateSymbol() {
                return 'd';
            }
        };

        private EntryStatusSymbols() {
        }

        public char getStatusSymbol(SVNStatusType svnStatusType) {
            return svnStatusType.getCode();
        }

        public char getOutOfDateSymbol() {
            return '*';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryStatusHandler
    implements ISVNStatusHandler {
        private long maximumRevisionNumber = Long.MIN_VALUE;
        private long minimumRevisionNumber = Long.MAX_VALUE;
        private long maximumCommittedRevisionNumber = Long.MIN_VALUE;
        private final Set<SVNStatusType> localStatusTypes = new HashSet<SVNStatusType>();
        private final Set<SVNStatusType> remoteStatusTypes = new HashSet<SVNStatusType>();

        private EntryStatusHandler() {
        }

        public void handleStatus(SVNStatus status) {
            long committedRevisionNumber;
            long revisionNumber = status.getRevision().getNumber();
            if (SVNRevision.isValidRevisionNumber((long)revisionNumber)) {
                this.maximumRevisionNumber = Math.max(this.maximumRevisionNumber, revisionNumber);
                if (revisionNumber != 0L) {
                    this.minimumRevisionNumber = Math.min(this.minimumRevisionNumber, revisionNumber);
                }
            }
            if (SVNRevision.isValidRevisionNumber((long)(committedRevisionNumber = status.getCommittedRevision().getNumber()))) {
                this.maximumCommittedRevisionNumber = Math.max(this.maximumCommittedRevisionNumber, committedRevisionNumber);
            }
            SVNStatusType contentsStatusType = status.getContentsStatus();
            this.localStatusTypes.add(contentsStatusType);
            SVNStatusType propertiesStatusType = status.getPropertiesStatus();
            this.localStatusTypes.add(propertiesStatusType);
            SVNStatusType remoteContentsStatusType = status.getRemoteContentsStatus();
            this.remoteStatusTypes.add(remoteContentsStatusType);
            SVNStatusType remotePropertiesStatusType = status.getRemotePropertiesStatus();
            this.remoteStatusTypes.add(remotePropertiesStatusType);
            boolean entryOutOfDate = !SVNStatusType.STATUS_NONE.equals(remoteContentsStatusType) || !SVNStatusType.STATUS_NONE.equals(remotePropertiesStatusType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("  ");
            buffer.append(contentsStatusType.getCode()).append(propertiesStatusType.getCode());
            buffer.append(entryOutOfDate ? (char)'*' : ' ');
            buffer.append(' ').append(String.format("%6d", revisionNumber));
            buffer.append(' ').append(String.format("%6d", committedRevisionNumber));
            buffer.append(' ').append(status.getFile());
            RevisionMojo.this.logDebugInfo(buffer.toString());
        }

        public long getMaximumRevisionNumber() {
            return this.maximumRevisionNumber == Long.MIN_VALUE ? -1L : this.maximumRevisionNumber;
        }

        public long getMinimumRevisionNumber() {
            return this.minimumRevisionNumber == Long.MAX_VALUE ? -1L : this.minimumRevisionNumber;
        }

        public boolean isMixedRevisions() {
            return this.getMaximumRevisionNumber() > 0L && this.getMinimumRevisionNumber() > 0L && this.getMaximumRevisionNumber() != this.getMinimumRevisionNumber();
        }

        public long getMaximumCommittedRevisionNumber() {
            return this.maximumCommittedRevisionNumber == Long.MIN_VALUE ? -1L : this.maximumCommittedRevisionNumber;
        }

        public Set<SVNStatusType> getLocalStatusTypes() {
            return new HashSet<SVNStatusType>(this.localStatusTypes);
        }

        public Set<SVNStatusType> getRemoteStatusTypes() {
            return new HashSet<SVNStatusType>(this.remoteStatusTypes);
        }
    }
}

