/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

public class ScmFileEventHandler
implements ISVNEventHandler {
    private final Logger logger;
    private final List<ScmFile> files = new ArrayList<ScmFile>();
    private final File baseDirectory;

    public ScmFileEventHandler(Logger logger, File baseDirectory) {
        this.logger = logger;
        this.baseDirectory = baseDirectory;
    }

    public void handleEvent(SVNEvent event, double progress) {
        String currentFile;
        ScmFileStatus status = SvnJavaUtil.getScmFileStatus(event.getExpectedAction());
        if (event.getFile() == null || event.getExpectedAction() == SVNEventAction.COMMIT_DELTA_SENT || event.getExpectedAction() == SVNEventAction.COMMIT_COMPLETED || event.getNodeKind() != SVNNodeKind.FILE) {
            return;
        }
        if (status == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown SVN file status: '" + event.getExpectedAction() + "' for file: " + event.getFile().getAbsolutePath());
            }
            status = ScmFileStatus.UNKNOWN;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(StringUtils.defaultString((Object)status, (String)event.getContentsStatus().toString()) + " - " + event.getFile().getAbsolutePath());
        }
        if ((currentFile = event.getFile().getAbsolutePath()).startsWith(this.baseDirectory.getAbsolutePath())) {
            currentFile = currentFile.substring(this.baseDirectory.getAbsolutePath().length() + 1);
        }
        this.files.add(new ScmFile(currentFile, status));
    }

    public void checkCancelled() throws SVNCancelException {
    }

    public List<ScmFile> getFiles() {
        return this.files;
    }
}

