/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.remoteinfo;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remoteinfo.AbstractRemoteInfoCommand;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaRemoteInfoCommand
extends AbstractRemoteInfoCommand
implements SvnCommand {
    public RemoteInfoScmResult executeRemoteInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        DirEntryHandler dirEntryHandler;
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        String url = ((SvnScmProviderRepository)repository).getUrl();
        String baseUrl = StringUtils.endsWith((String)url, (String)"/") ? StringUtils.substringAfter((String)StringUtils.removeEnd((String)url, (String)"/"), (String)"/") : StringUtils.substringBeforeLast((String)url, (String)"/");
        RemoteInfoScmResult remoteInfoScmResult = new RemoteInfoScmResult(null, null, null, true);
        try {
            dirEntryHandler = new DirEntryHandler(baseUrl);
            javaRepo.getClientManager().getLogClient().doList(SVNURL.parseURIEncoded((String)(baseUrl + "/tags")), SVNRevision.HEAD, SVNRevision.HEAD, false, false, (ISVNDirEntryHandler)dirEntryHandler);
            remoteInfoScmResult.setTags(dirEntryHandler.infos);
        }
        catch (SVNException e) {
            return new RemoteInfoScmResult(null, e.getMessage(), null, false);
        }
        try {
            dirEntryHandler = new DirEntryHandler(baseUrl);
            javaRepo.getClientManager().getLogClient().doList(SVNURL.parseURIEncoded((String)(baseUrl + "/branches")), SVNRevision.HEAD, SVNRevision.HEAD, false, false, (ISVNDirEntryHandler)dirEntryHandler);
            remoteInfoScmResult.setBranches(dirEntryHandler.infos);
        }
        catch (SVNException e) {
            return new RemoteInfoScmResult(null, e.getMessage(), null, false);
        }
        return remoteInfoScmResult;
    }

    public boolean remoteUrlExist(ScmProviderRepository repository, CommandParameters parameters) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        String url = ((SvnScmProviderRepository)repository).getUrl();
        try {
            javaRepo.getClientManager().getWCClient().doInfo(SVNURL.parseURIEncoded((String)url), SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.EMPTY, SVNInfo::getAuthor);
        }
        catch (SVNException e) {
            if (e.getMessage().contains("E170000")) {
                return false;
            }
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static class DirEntryHandler
    implements ISVNDirEntryHandler {
        String url;
        Map<String, String> infos = new HashMap<String, String>();

        DirEntryHandler(String url) {
            this.url = url;
        }

        public void handleDirEntry(SVNDirEntry svnDirEntry) throws SVNException {
            this.infos.put(svnDirEntry.getName(), svnDirEntry.getURL().toString());
        }
    }
}

