/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.checkout;

import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnJavaCheckOutCommand
extends AbstractCheckOutCommand
implements SvnCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository scmProviderRepository, ScmFileSet scmFileSet, ScmVersion scmVersion, boolean recursive, boolean shallow) throws ScmException {
        return this.executeCheckOutCommand(scmProviderRepository, scmFileSet, scmVersion, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SVN checkout directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        SVNRevision revision = SVNRevision.HEAD;
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            if (version instanceof ScmTag) {
                url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)((ScmTag)version));
            } else if (version instanceof ScmBranch) {
                url = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)((ScmBranch)version));
            } else if (version instanceof ScmRevision) {
                try {
                    revision = SVNRevision.create((long)Long.parseLong(version.getName()));
                }
                catch (NumberFormatException exc) {
                    return new CheckOutScmResult("JavaSVN Library", "SVN checkout failed. Wrong format of revision number.", null, false);
                }
            }
        }
        url = SvnCommandUtils.fixUrl((String)url, (String)repository.getUser());
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.logger, fileSet.getBasedir());
        SVNUpdateClient updateClient = javaRepo.getClientManager().getUpdateClient();
        updateClient.setEventHandler((ISVNEventHandler)handler);
        try {
            SvnJavaUtil.checkout(updateClient, SVNURL.parseURIEncoded((String)url), revision, fileSet.getBasedir(), recursive);
            CheckOutScmResult checkOutScmResult = new CheckOutScmResult("JavaSVN Library", handler.getFiles());
            return checkOutScmResult;
        }
        catch (SVNException e) {
            CheckOutScmResult checkOutScmResult = new CheckOutScmResult("JavaSVN Library", "SVN checkout failed.", e.getMessage(), false);
            return checkOutScmResult;
        }
        finally {
            javaRepo.getClientManager().getUpdateClient().setEventHandler(null);
        }
    }
}

