/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnChangeSet;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaChangeLogCommand
extends AbstractChangeLogCommand
implements SvnCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        throw new UnsupportedOperationException("executeChangeLogCommand( ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern ) is not implemented");
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        SVNRevision startRevision = startDate != null ? SVNRevision.create((Date)startDate) : SVNRevision.UNDEFINED;
        SVNRevision endRevision = endDate != null ? SVNRevision.create((Date)endDate) : SVNRevision.HEAD;
        try {
            SVNURL url = javaRepo.getSvnUrl();
            if (branch != null) {
                url = SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)javaRepo, (ScmBranch)branch));
            }
            ChangeLogHandler handler = new ChangeLogHandler(startDate, endDate);
            SvnJavaUtil.changelog(javaRepo.getClientManager(), url, startRevision, endRevision, true, true, handler);
            return new ChangeLogScmResult("JavaSVN Library", handler.getChangeSets());
        }
        catch (SVNException e) {
            return new ChangeLogScmResult("JavaSVN Library", "SVN Changelog failed.", e.getMessage(), false);
        }
    }

    protected static class ChangeLogHandler
    implements ISVNLogEntryHandler {
        private ChangeLogSet changeLogSet;
        private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();

        public ChangeLogHandler(Date startDate, Date endDate) {
            this.changeLogSet = new ChangeLogSet(startDate, endDate);
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            List changedFiles = logEntry.getChangedPaths().keySet().stream().map(changedPath -> new ChangeFile(changedPath, Long.toString(logEntry.getRevision()))).collect(Collectors.toList());
            SvnChangeSet changeSet = new SvnChangeSet(logEntry.getDate(), logEntry.getMessage(), logEntry.getAuthor(), changedFiles);
            changeSet.setRevision(Long.toString(logEntry.getRevision()));
            this.changeSets.add((ChangeSet)changeSet);
        }

        public ChangeLogSet getChangeSets() {
            this.changeLogSet.setChangeSets(this.changeSets);
            return this.changeLogSet;
        }
    }
}

