/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nz.net.ultraq.thymeleaf.internal.ConcurrentWeakIdentityHashMap;
import nz.net.ultraq.thymeleaf.internal.Extensions$$Lambda$1;
import nz.net.ultraq.thymeleaf.internal.Extensions$$Lambda$2;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventConsumer;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventIntPredicate;
import nz.net.ultraq.thymeleaf.internal.ITemplateEventPredicate;
import nz.net.ultraq.thymeleaf.models.extensions.ChildModelIterator;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.util.StringUtils;

public class Extensions {
    public static boolean asBoolean(@Nullable IModel iModel) {
        return iModel != null && iModel.size() > 0;
    }

    @Nonnull
    public static Iterator<IModel> childModelIterator(@Nonnull IModel iModel) {
        return Extensions.isElement(iModel) ? new ChildModelIterator(iModel) : Collections.emptyIterator();
    }

    public static void clearChildren(@Nonnull IModel iModel) {
        if (Extensions.isElement(iModel)) {
            while (iModel.size() > 2) {
                iModel.remove(1);
            }
        }
    }

    public static void each(@Nullable IModel iModel, @Nonnull ITemplateEventConsumer iTemplateEventConsumer) {
        if (iModel != null) {
            int n = iModel.size();
            for (int i = 0; i < n; ++i) {
                iTemplateEventConsumer.accept(iModel.get(i));
            }
        }
    }

    public static boolean equals(IModel iModel, @Nullable Object object) {
        if (object instanceof IModel) {
            IModel iModel2 = (IModel)object;
            if (iModel.size() == iModel2.size()) {
                return Extensions.everyWithIndex(iModel, Extensions$$Lambda$1.lambdaFactory$(iModel2));
            }
        }
        return false;
    }

    public static boolean equals(@Nullable ITemplateEvent iTemplateEvent, @Nullable Object object) {
        if (iTemplateEvent instanceof IProcessableElementTag) {
            return Extensions.equals((IProcessableElementTag)iTemplateEvent, object);
        }
        if (iTemplateEvent instanceof ICloseElementTag) {
            return Extensions.equals((ICloseElementTag)iTemplateEvent, object);
        }
        if (iTemplateEvent instanceof IStandaloneElementTag) {
            return Extensions.equals((IStandaloneElementTag)iTemplateEvent, object);
        }
        if (iTemplateEvent instanceof IText) {
            return Extensions.equals((IText)iTemplateEvent, object);
        }
        return Objects.equals(iTemplateEvent, object);
    }

    public static boolean equalsIgnoreWhitespace(@Nonnull IModel iModel, @Nonnull IModel iModel2) {
        int n = 0;
        int n2 = 0;
        int n3 = iModel.size();
        int n4 = iModel2.size();
        while (n < n3 || n2 < n4) {
            ITemplateEvent iTemplateEvent = iModel.get(n);
            ITemplateEvent iTemplateEvent2 = iModel2.get(n2);
            if (Extensions.isWhitespace(iTemplateEvent)) {
                ++n;
                continue;
            }
            if (Extensions.isWhitespace(iTemplateEvent2)) {
                ++n2;
                continue;
            }
            if (!Extensions.equals(iTemplateEvent, (Object)iTemplateEvent2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        return n == n3 && n2 == n4;
    }

    public static boolean everyWithIndex(@Nonnull IModel iModel, @Nonnull ITemplateEventIntPredicate iTemplateEventIntPredicate) {
        int n = iModel.size();
        for (int i = 0; i < n; ++i) {
            if (iTemplateEventIntPredicate.test(iModel.get(i), i)) continue;
            return false;
        }
        return true;
    }

    public static ITemplateEvent find(@Nonnull IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        for (int i = 0; i < iModel.size(); ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            boolean bl = iTemplateEventPredicate.test(iTemplateEvent);
            if (!bl) continue;
            return iTemplateEvent;
        }
        return null;
    }

    public static int findIndexOf(@Nonnull IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        int n = iModel.size();
        for (int i = 0; i < n; ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            boolean bl = iTemplateEventPredicate.test(iTemplateEvent);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static IModel findModel(@Nonnull IModel iModel, @Nonnull ITemplateEventPredicate iTemplateEventPredicate) {
        int n = Extensions.findIndexOf(iModel, iTemplateEventPredicate);
        if (n != -1) {
            return Extensions.getModel(iModel, n);
        }
        return null;
    }

    public static ITemplateEvent first(@Nonnull IModel iModel) {
        return iModel.get(0);
    }

    @Nonnull
    public static IModel getModel(@Nonnull IModel iModel, int n) {
        int n2 = Extensions.calculateModelSize(iModel, n);
        IModel iModel2 = iModel.cloneModel();
        int n3 = iModel instanceof TemplateModel ? n - 1 : n;
        int n4 = iModel2.size() - (n3 + n2);
        while (n3-- > 0) {
            Extensions.removeFirst(iModel2);
        }
        while (n4-- > 0) {
            Extensions.removeLast(iModel2);
        }
        return iModel2;
    }

    public static int indexOf(@Nonnull IModel iModel, @Nonnull IModel iModel2) {
        ITemplateEvent iTemplateEvent = Extensions.first(iModel2);
        return Extensions.findIndexOf(iModel, Extensions$$Lambda$2.lambdaFactory$(iTemplateEvent));
    }

    public static void insertModelWithWhitespace(@Nonnull IModel iModel, int n, @Nonnull IModel iModel2, @Nonnull IModelFactory iModelFactory) {
        IModel iModel3 = Extensions.getModel(iModel, n);
        if (Extensions.isWhitespace(iModel3)) {
            iModel.insertModel(n, iModel2);
            iModel.insertModel(n, iModel3);
        } else {
            iModel3 = iModelFactory.createModel((ITemplateEvent)iModelFactory.createText((CharSequence)"\n\t"));
            iModel.insertModel(n, iModel3);
            iModel.insertModel(n, iModel2);
            iModel.insertModel(n, iModel3);
        }
    }

    public static void insertWithWhitespace(@Nonnull IModel iModel, int n, @Nonnull ITemplateEvent iTemplateEvent, @Nonnull IModelFactory iModelFactory) {
        IModel iModel2 = Extensions.getModel(iModel, n);
        if (Extensions.isWhitespace(iModel2)) {
            iModel.insert(n, iTemplateEvent);
            iModel.insertModel(n, iModel2);
        } else {
            IText iText = iModelFactory.createText((CharSequence)"\n");
            if (n == 0) {
                iModel.insert(n, (ITemplateEvent)iText);
                iModel.insert(n, iTemplateEvent);
            } else if (n == iModel.size()) {
                iModel.insert(n, (ITemplateEvent)iText);
                iModel.insert(n, iTemplateEvent);
                iModel.insert(n, (ITemplateEvent)iText);
            }
        }
    }

    public static boolean isElement(@Nonnull IModel iModel) {
        return Extensions.first(iModel) instanceof IOpenElementTag && Extensions.last(iModel) instanceof ICloseElementTag;
    }

    public static boolean isWhitespace(@Nonnull IModel iModel) {
        return iModel.size() == 1 && Extensions.isWhitespace(Extensions.first(iModel));
    }

    public static ITemplateEvent last(@Nonnull IModel iModel) {
        return iModel.get(iModel.size() - 1);
    }

    public static void removeFirst(@Nonnull IModel iModel) {
        iModel.remove(0);
    }

    public static void removeLast(@Nonnull IModel iModel) {
        iModel.remove(iModel.size() - 1);
    }

    public static void removeModel(@Nonnull IModel iModel, int n) {
        for (int i = Extensions.calculateModelSize(iModel, n); i > 0; --i) {
            iModel.remove(n);
        }
    }

    public static void removeModelWithWhitespace(@Nonnull IModel iModel, int n) {
        Extensions.removeModel(iModel, n);
        ITemplateEvent iTemplateEvent = iModel.get(n - 1);
        if (Extensions.isWhitespace(iTemplateEvent)) {
            iModel.remove(n - 1);
        }
    }

    public static void replaceModel(@Nonnull IModel iModel, int n, @Nonnull IModel iModel2) {
        Extensions.removeModel(iModel, n);
        iModel.insertModel(n, iModel2);
    }

    public static void trim(@Nonnull IModel iModel) {
        while (Extensions.isWhitespace(Extensions.first(iModel))) {
            Extensions.removeFirst(iModel);
        }
        while (Extensions.isWhitespace(Extensions.last(iModel))) {
            Extensions.removeLast(iModel);
        }
    }

    public static String getTemplate(@Nonnull TemplateModel templateModel) {
        return templateModel.getTemplateData().getTemplate();
    }

    public static boolean isWhitespace(@Nonnull ITemplateEvent iTemplateEvent) {
        return iTemplateEvent instanceof IText && Extensions.isWhitespace((IText)iTemplateEvent);
    }

    public static boolean equals(IProcessableElementTag iProcessableElementTag, @Nullable Object object) {
        return object instanceof IProcessableElementTag && Objects.equals(iProcessableElementTag.getElementCompleteName(), ((IElementTag)object).getElementCompleteName()) && Objects.equals(iProcessableElementTag.getAttributeMap(), ((IProcessableElementTag)object).getAttributeMap());
    }

    public static boolean equalsIgnoreXmlnsAndThWith(IProcessableElementTag iProcessableElementTag, ITemplateContext iTemplateContext, @Nullable Object object) {
        if (object instanceof IProcessableElementTag) {
            IProcessableElementTag iProcessableElementTag2 = (IProcessableElementTag)object;
            if (Objects.equals(iProcessableElementTag.getElementDefinition(), iProcessableElementTag2.getElementDefinition())) {
                LinkedHashMap linkedHashMap = new LinkedHashMap(iProcessableElementTag.getAttributeMap());
                linkedHashMap.keySet().removeAll(iProcessableElementTag2.getAttributeMap().keySet());
                if (linkedHashMap.isEmpty()) {
                    return true;
                }
                String string = Extensions.getPrefixForDialect((IExpressionContext)iTemplateContext, StandardDialect.class) + ":with";
                for (String string2 : linkedHashMap.keySet()) {
                    if (string2.startsWith("xmlns:") || string2.startsWith(string)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean equals(ICloseElementTag iCloseElementTag, @Nullable Object object) {
        return object instanceof ICloseElementTag && Objects.equals(iCloseElementTag.getElementCompleteName(), ((IElementTag)object).getElementCompleteName());
    }

    public static boolean equals(IStandaloneElementTag iStandaloneElementTag, @Nullable Object object) {
        return object instanceof IStandaloneElementTag && Objects.equals(iStandaloneElementTag.getElementCompleteName(), ((IElementTag)object).getElementCompleteName()) && Objects.equals(iStandaloneElementTag.getAttributeMap(), ((IProcessableElementTag)object).getAttributeMap());
    }

    public static boolean equalsName(@Nonnull IAttribute iAttribute, @Nonnull String string, @Nonnull String string2) {
        String string3 = iAttribute.getAttributeCompleteName();
        return (string + ":" + string2).equals(string3) || ("data-" + string + "-" + string2).equals(string3);
    }

    public static AttributeName getAttributeName(@Nonnull IAttribute iAttribute) {
        return iAttribute.getAttributeDefinition().getAttributeName();
    }

    public static boolean equals(IText iText, @Nullable Object object) {
        return object instanceof IText && Objects.equals(iText.getText(), ((IText)object).getText());
    }

    public static boolean isWhitespace(@Nonnull IText iText) {
        return iText.getText().trim().isEmpty();
    }

    public static String getPrefixForDialect(@Nonnull IExpressionContext iExpressionContext, Class<? extends IProcessorDialect> clazz) {
        ConcurrentMap<Class<?>, String> concurrentMap = DialectPrefixCacheHolder.getDialectPrefixCache(iExpressionContext);
        String string = (String)concurrentMap.get(clazz);
        if (StringUtils.isEmpty((String)string)) {
            DialectConfiguration dialectConfiguration = null;
            for (DialectConfiguration dialectConfiguration2 : iExpressionContext.getConfiguration().getDialectConfigurations()) {
                if (!clazz.isInstance(dialectConfiguration2.getDialect())) continue;
                dialectConfiguration = dialectConfiguration2;
                break;
            }
            String string2 = dialectConfiguration != null ? (dialectConfiguration.isPrefixSpecified() ? dialectConfiguration.getPrefix() : ((IProcessorDialect)dialectConfiguration.getDialect()).getPrefix()) : (string = null);
            if (string != null) {
                concurrentMap.putIfAbsent(clazz, string);
            }
        }
        return string;
    }

    private static int calculateModelSize(@Nonnull IModel iModel, int n) {
        ITemplateEvent iTemplateEvent;
        int n2 = n;
        if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
            int n3 = 0;
            while (true) {
                ICloseElementTag iCloseElementTag;
                if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
                    ++n3;
                    continue;
                }
                if (!(iTemplateEvent instanceof ICloseElementTag) || (iCloseElementTag = (ICloseElementTag)iTemplateEvent).isUnmatched()) continue;
                if (n3 == 0) break;
                --n3;
            }
            return n2 - n;
        }
        return 1;
    }

    private Extensions() {
        throw new AssertionError();
    }

    static /* synthetic */ boolean lambda$indexOf$1(ITemplateEvent iTemplateEvent, ITemplateEvent iTemplateEvent2) {
        return iTemplateEvent2 == iTemplateEvent;
    }

    static /* synthetic */ boolean lambda$equals$0(IModel iModel, ITemplateEvent iTemplateEvent, int n) {
        return Extensions.equals(iTemplateEvent, (Object)iModel.get(n));
    }

    private static class DialectPrefixCacheHolder {
        private static final ConcurrentWeakIdentityHashMap<IExpressionContext, ConcurrentMap<Class<?>, String>> CACHE = new ConcurrentWeakIdentityHashMap(20);

        private DialectPrefixCacheHolder() {
        }

        static ConcurrentMap<Class<?>, String> getDialectPrefixCache(IExpressionContext iExpressionContext) {
            ConcurrentHashMap concurrentHashMap;
            ConcurrentHashMap concurrentHashMap2 = CACHE.get(iExpressionContext);
            return concurrentHashMap2 == null && (concurrentHashMap2 = (ConcurrentHashMap)CACHE.putIfAbsent(iExpressionContext, concurrentHashMap = new ConcurrentHashMap(4))) == null ? concurrentHashMap : concurrentHashMap2;
        }
    }
}

