/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ConcurrentWeakIdentityHashMap<K, V> {
    private final ConcurrentMap<Object, V> map;
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    ConcurrentWeakIdentityHashMap(int n) {
        this.map = new ConcurrentHashMap<Object, V>(n);
    }

    public V get(Object object) {
        this.purgeKeys();
        return this.map.get(new Key<Object>(object, (ReferenceQueue<Object>)null));
    }

    private void purgeKeys() {
        Reference<K> reference;
        ReferenceQueue<K> referenceQueue = this.queue;
        ConcurrentMap<Object, V> concurrentMap = this.map;
        while ((reference = referenceQueue.poll()) != null) {
            concurrentMap.remove(reference);
        }
    }

    public V putIfAbsent(K k, V v) {
        this.purgeKeys();
        return this.map.putIfAbsent(new Key<K>(k, this.queue), v);
    }

    public int size() {
        this.purgeKeys();
        return this.map.size();
    }

    private static class Key<T>
    extends WeakReference<T> {
        private final int hash;

        Key(T t, ReferenceQueue<T> referenceQueue) {
            super(Objects.requireNonNull(t), referenceQueue);
            this.hash = System.identityHashCode(t);
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Key && ((Key)object).get() == this.get();
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

