/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorators.strategies;

import java.util.ArrayList;
import java.util.Iterator;
import nz.net.ultraq.thymeleaf.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.internal.Extensions;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;

public class GroupingStrategy
implements SortingStrategy {
    private static int findMatchingType(IModel iModel) {
        ITemplateEvent iTemplateEvent = Extensions.first(iModel);
        if (iTemplateEvent instanceof IComment) {
            return 1;
        }
        if (iTemplateEvent instanceof IElementTag) {
            String string = ((IElementTag)iTemplateEvent).getElementCompleteName();
            if (iTemplateEvent instanceof IProcessableElementTag && "meta".equals(string)) {
                return 2;
            }
            if (iTemplateEvent instanceof IOpenElementTag && "script".equals(string)) {
                return 3;
            }
            if (iTemplateEvent instanceof IOpenElementTag && "style".equals(string)) {
                return 4;
            }
            if (iTemplateEvent instanceof IProcessableElementTag && "link".equals(string) && "stylesheet".equals(((IProcessableElementTag)iTemplateEvent).getAttributeValue("rel"))) {
                return 5;
            }
            return 6;
        }
        return 0;
    }

    @Override
    public int findPositionForModel(IModel iModel, IModel iModel2) {
        if (Extensions.isWhitespace(iModel2)) {
            return -1;
        }
        int n = GroupingStrategy.findMatchingType(iModel2);
        ArrayList<IModel> arrayList = new ArrayList<IModel>(20);
        Iterator<IModel> iterator = Extensions.childModelIterator(iModel);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = arrayList.listIterator(arrayList.size());
        while (iterator.hasPrevious()) {
            IModel iModel3 = (IModel)iterator.previous();
            if (n != GroupingStrategy.findMatchingType(iModel3)) continue;
            if (!Extensions.asBoolean(iModel)) break;
            return Extensions.indexOf(iModel, iModel3) + iModel3.size();
        }
        return 1;
    }
}

