/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.calendar;

import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.calendar.CalendarWrapper;
import com.xkzhangsan.time.calendar.DayWrapper;
import com.xkzhangsan.time.calendar.MonthWrapper;
import com.xkzhangsan.time.calendar.YearWrapper;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CalendarUtil {
    private CalendarUtil() {
    }

    public static CalendarWrapper generateCalendar(int year, int month) {
        return CalendarUtil.generateCalendar(year, month, false, false, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithLunar(int year, int month) {
        return CalendarUtil.generateCalendar(year, month, true, false, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithLocalHoliday(int year, int month, Map<String, String> localHolidayMap, Map<String, Integer> dateTypeMap) {
        return CalendarUtil.generateCalendar(year, month, false, true, localHolidayMap, null, dateTypeMap);
    }

    public static CalendarWrapper generateCalendarWithHoliday(int year, int month) {
        return CalendarUtil.generateCalendar(year, month, true, true, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithHoliday(int year, int month, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap, Map<String, Integer> dateTypeMap) {
        return CalendarUtil.generateCalendar(year, month, true, true, localHolidayMap, chineseHolidayMap, dateTypeMap);
    }

    private static CalendarWrapper generateCalendar(int year, int month, boolean includeLunarDate, boolean includeHoliday, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap, Map<String, Integer> dateTypeMap) {
        YearMonth yearMonth = YearMonth.of(year, month);
        CalendarWrapper calendarWrapper = new CalendarWrapper();
        ConcurrentHashMap<String, DayWrapper> dayMap = new ConcurrentHashMap<String, DayWrapper>(64);
        ArrayList<DayWrapper> dayList = new ArrayList<DayWrapper>();
        List<LocalDateTime> localDateTimeList = DateTimeCalculatorUtil.getLocalDateTimeList(YearMonth.of(year, month));
        if (CollectionUtil.isEmpty(localDateTimeList)) {
            return calendarWrapper;
        }
        ArrayList<DayWrapper> dayWrapperList = new ArrayList<DayWrapper>();
        localDateTimeList.stream().forEach(localDateTime -> {
            DayWrapper dayWrapper = new DayWrapper((LocalDateTime)localDateTime, includeLunarDate, includeHoliday, localHolidayMap, chineseHolidayMap);
            dayWrapperList.add(dayWrapper);
            dayMap.put(DateTimeFormatterUtil.formatToDateStr(localDateTime), dayWrapper);
            dayList.add(dayWrapper);
        });
        if (CollectionUtil.isNotEmpty(dateTypeMap) && CollectionUtil.isNotEmpty(dayMap)) {
            dateTypeMap.forEach((k, v) -> {
                if (dayMap.containsKey(k)) {
                    ((DayWrapper)dayMap.get(k)).setDateType((int)v);
                }
            });
        }
        MonthWrapper monthWrapper = new MonthWrapper(month, dayWrapperList, yearMonth.lengthOfMonth());
        ArrayList<MonthWrapper> monthWrapperList = new ArrayList<MonthWrapper>();
        monthWrapperList.add(monthWrapper);
        YearWrapper yearWrapper = new YearWrapper(year, monthWrapperList);
        ArrayList<YearWrapper> yearWrapperList = new ArrayList<YearWrapper>();
        yearWrapperList.add(yearWrapper);
        calendarWrapper = new CalendarWrapper(yearWrapperList, dayMap, dayList);
        return calendarWrapper;
    }

    public static CalendarWrapper generateCalendar(int year) {
        return CalendarUtil.generateCalendar(year, false, false, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithLunar(int year) {
        return CalendarUtil.generateCalendar(year, true, false, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithLocalHoliday(int year, Map<String, String> localHolidayMap, Map<String, Integer> dateTypeMap) {
        return CalendarUtil.generateCalendar(year, false, true, localHolidayMap, null, dateTypeMap);
    }

    public static CalendarWrapper generateCalendarWithHoliday(int year) {
        return CalendarUtil.generateCalendar(year, true, true, null, null, null);
    }

    public static CalendarWrapper generateCalendarWithHoliday(int year, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap, Map<String, Integer> dateTypeMap) {
        return CalendarUtil.generateCalendar(year, true, true, localHolidayMap, chineseHolidayMap, dateTypeMap);
    }

    private static CalendarWrapper generateCalendar(int year, boolean includeLunarDate, boolean includeHoliday, Map<String, String> localHolidayMap, Map<String, String> chineseHolidayMap, Map<String, Integer> dateTypeMap) {
        CalendarWrapper calendarWrapper = new CalendarWrapper();
        ConcurrentHashMap<String, DayWrapper> dayMap = new ConcurrentHashMap<String, DayWrapper>(512);
        ArrayList<DayWrapper> dayList = new ArrayList<DayWrapper>();
        ArrayList<MonthWrapper> monthWrapperList = new ArrayList<MonthWrapper>();
        for (int i = 1; i <= 12; ++i) {
            YearMonth yearMonth = YearMonth.of(year, i);
            List<LocalDateTime> localDateTimeList = DateTimeCalculatorUtil.getLocalDateTimeList(YearMonth.of(year, i));
            if (CollectionUtil.isEmpty(localDateTimeList)) continue;
            ArrayList<DayWrapper> dayWrapperList = new ArrayList<DayWrapper>();
            localDateTimeList.stream().forEach(localDateTime -> {
                DayWrapper dayWrapper = new DayWrapper((LocalDateTime)localDateTime, includeLunarDate, includeHoliday, localHolidayMap, chineseHolidayMap);
                dayWrapperList.add(dayWrapper);
                dayMap.put(DateTimeFormatterUtil.formatToDateStr(localDateTime), dayWrapper);
                dayList.add(dayWrapper);
            });
            MonthWrapper monthWrapper = new MonthWrapper(i, dayWrapperList, yearMonth.lengthOfMonth());
            monthWrapperList.add(monthWrapper);
        }
        if (CollectionUtil.isNotEmpty(dateTypeMap) && CollectionUtil.isNotEmpty(dayMap)) {
            dateTypeMap.forEach((k, v) -> {
                if (dayMap.containsKey(k)) {
                    ((DayWrapper)dayMap.get(k)).setDateType((int)v);
                }
            });
        }
        ArrayList<YearWrapper> yearWrapperList = new ArrayList<YearWrapper>();
        YearWrapper yearWrapper = new YearWrapper(year, monthWrapperList);
        yearWrapperList.add(yearWrapper);
        calendarWrapper = new CalendarWrapper(yearWrapperList, dayMap, dayList);
        return calendarWrapper;
    }
}

