/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.spring.plugin.AbstractOperationBuilderPlugin;
import java.lang.annotation.Annotation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@ConditionalOnClass(name={"org.springframework.security.access.prepost.PostAuthorize"})
@Order(value=-2147483448)
public class SecurityAnnotationPlugin
extends AbstractOperationBuilderPlugin {
    private static final String PACKAGE_PREFIX = "org.springframework.security.access.prepost.";

    public void apply(OperationContext context) {
        String notes = context.operationBuilder().build().getNotes();
        StringBuffer notesBuffer = new StringBuffer(notes == null ? "" : notes);
        this.appendClassAnnotationNote(notesBuffer, context);
        this.appendMethodAnnotationNote(notesBuffer, context);
        context.operationBuilder().notes(notesBuffer.toString());
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void appendClassAnnotationNote(StringBuffer notesBuffer, OperationContext context) {
        StringBuffer securityNotes = new StringBuffer();
        context.findControllerAnnotation(PostAuthorize.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findControllerAnnotation(PostFilter.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findControllerAnnotation(PreAuthorize.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findControllerAnnotation(PreFilter.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        if (securityNotes.length() > 0) {
            notesBuffer.append("<p />");
            notesBuffer.append("class: ");
            notesBuffer.append(securityNotes);
        }
    }

    private void appendMethodAnnotationNote(StringBuffer notesBuffer, OperationContext context) {
        StringBuffer securityNotes = new StringBuffer();
        context.findAnnotation(PostAuthorize.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findAnnotation(PostFilter.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findAnnotation(PreAuthorize.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        context.findAnnotation(PreFilter.class).ifPresent(ann -> this.append(securityNotes, (Annotation)ann));
        if (securityNotes.length() > 0) {
            notesBuffer.append("<p />");
            notesBuffer.append("method: ");
            notesBuffer.append(securityNotes);
        }
    }

    private void append(StringBuffer securityNotes, Annotation ann) {
        String txt = ann.toString().replace(PACKAGE_PREFIX, "").replace("\\'", "'");
        securityNotes.append(txt).append(" ");
    }
}

