// Copyright 2021 Tencent Inc. All rights reserved.
//
// 营销商家券对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.0.11

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.merchantexclusivecoupon.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** SubsidyPayRequest */
public class SubsidyPayRequest {
  /** 商家券批次号 说明：由微信支付生成，调用创建商家券API成功时返回的唯一批次ID 仅支持“满减券”和“折扣券”的批次，“换购券”批次不支持 */
  @SerializedName("stock_id")
  private String stockId;
  /**
   * 商家券code 说明：券的唯一标识。 在WECHATPAY\\_MODE的券code模式下，商家券code是由微信支付生成的唯一ID；
   * 在MERCHANT\\_UPLOAD、MERCHANT\\_API的券code模式下，商家券code是由商户上传或指定，在批次下保证唯一；
   */
  @SerializedName("coupon_code")
  private String couponCode;
  /** 微信支付订单号 说明：微信支付下单支付成功返回的订单号 */
  @SerializedName("transaction_id")
  private String transactionId;
  /** 营销补差扣款商户号 说明：营销补差扣款商户号 注：补差扣款商户号 = 制券商户号 或 补差扣款商户号 = 归属商户号 */
  @SerializedName("payer_merchant")
  private String payerMerchant;
  /** 营销补差入账商户号 说明：营销补差入账商户号 注：补差入账商户号 = 券归属商户号 或者和 券归属商户号有连锁品牌关系 */
  @SerializedName("payee_merchant")
  private String payeeMerchant;
  /**
   * 补差付款金额 说明：单位为分，单笔订单补差金额不得超过券的优惠金额，最高补差金额为5000元 > 券的优惠金额定义： 满减券：满减金额即为优惠金额 折扣券：优惠金额 = 微信支付订单金额 ÷
   * 折扣比例 × (1 - 折扣比例) 换购券：不支持
   */
  @SerializedName("amount")
  private Long amount;
  /** 补差付款描述 说明：付款备注描述，查询的时候原样带回 */
  @SerializedName("description")
  private String description;
  /** 业务请求唯一单号 说明：商户侧需保证唯一性，可包含英文字母，数字，｜，_，*，-等内容，不允许出现其他不合法符号 */
  @SerializedName("out_subsidy_no")
  private String outSubsidyNo;

  public String getStockId() {
    return stockId;
  }

  public void setStockId(String stockId) {
    this.stockId = stockId;
  }

  public String getCouponCode() {
    return couponCode;
  }

  public void setCouponCode(String couponCode) {
    this.couponCode = couponCode;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getPayerMerchant() {
    return payerMerchant;
  }

  public void setPayerMerchant(String payerMerchant) {
    this.payerMerchant = payerMerchant;
  }

  public String getPayeeMerchant() {
    return payeeMerchant;
  }

  public void setPayeeMerchant(String payeeMerchant) {
    this.payeeMerchant = payeeMerchant;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getOutSubsidyNo() {
    return outSubsidyNo;
  }

  public void setOutSubsidyNo(String outSubsidyNo) {
    this.outSubsidyNo = outSubsidyNo;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubsidyPayRequest {\n");
    sb.append("    stockId: ").append(toIndentedString(stockId)).append("\n");
    sb.append("    couponCode: ").append(toIndentedString(couponCode)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    payerMerchant: ").append(toIndentedString(payerMerchant)).append("\n");
    sb.append("    payeeMerchant: ").append(toIndentedString(payeeMerchant)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    outSubsidyNo: ").append(toIndentedString(outSubsidyNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
