/*
 * Decompiled with CFR 0.152.
 */
package com.zyh.ce4j.executor;

import com.zyh.ce4j.domain.ExecutedResult;
import com.zyh.ce4j.domain.Result;
import com.zyh.ce4j.strategy.CheckStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public interface Executor {
    public ExecutedResult execute(String var1);

    public ExecutedResult execute(String[] var1);

    public ExecutedResult executeMutilShell(List<String> var1);

    default public boolean isWin() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static class StreamGobbler
    extends Thread {
        private List<String> outLines;
        private InputStream is;
        private StreamGobblerType type;
        private MutilComandsStream mcs;
        private String lastPrint;
        private boolean collectAllOutput;

        public StreamGobbler(InputStream is, StreamGobblerType type, boolean collectAllOutput) {
            this(is, type, null, collectAllOutput);
        }

        public StreamGobbler(InputStream is, StreamGobblerType type, MutilComandsStream mcs, boolean collectAllOutput) {
            this.is = is;
            this.type = type;
            this.mcs = mcs;
            this.collectAllOutput = collectAllOutput;
            if (this.collectAllOutput) {
                this.outLines = new ArrayList<String>();
            }
        }

        public String getLastPrint() {
            return this.lastPrint;
        }

        public List<String> getOutputLines() {
            return this.outLines == null ? new ArrayList() : this.outLines;
        }

        public Result exeResult(CheckStrategy ces) {
            Result er = ces.endCheck(this.lastPrint);
            if (this.collectAllOutput) {
                er.setData(this.outLines);
            }
            return er;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader isr = null;
            BufferedReader br = null;
            PrintWriter pw = null;
            if (this.mcs != null && this.mcs.getPw() != null) {
                pw = this.mcs.getPw();
                for (String line : this.mcs.getCommands()) {
                    pw.println(line);
                }
                pw.println("exit");
            }
            try {
                isr = new InputStreamReader(this.is);
                br = new BufferedReader(isr);
                String line = null;
                block16: while ((line = br.readLine()) != null) {
                    if (this.collectAllOutput) {
                        this.outLines.add(line);
                    }
                    switch (this.type) {
                        case ERROR: {
                            this.lastPrint = line;
                            System.out.println("ERROR->" + line);
                            continue block16;
                        }
                        case STDOUT: {
                            this.lastPrint = line;
                            System.out.println("STDOUT->" + line);
                            continue block16;
                        }
                    }
                    this.lastPrint = line;
                    System.out.println("OTHER->" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                try {
                    br.close();
                    isr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class MutilComandsStream {
        private PrintWriter pw;
        private List<String> commands;

        public MutilComandsStream(OutputStream os, List<String> commands) {
            this.pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(os)), true);
            this.commands = commands;
        }

        public PrintWriter getPw() {
            return this.pw;
        }

        public void setPw(PrintWriter pw) {
            this.pw = pw;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public void setCommands(List<String> commands) {
            this.commands = commands;
        }
    }

    public static enum StreamGobblerType {
        STDOUT,
        ERROR;

    }
}

