/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.volumedescriptors;

import com.github.stephenc.javaisotools.iso9660.BootConfig;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.ISO9660VolumeDescriptor;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;

public class BootRecord
extends ISO9660VolumeDescriptor {
    private String bootSystemId = "";
    private String bootId = "";

    public BootRecord(StreamHandler streamHandler, LayoutHelper helper) {
        super(streamHandler, 0, helper);
    }

    public void setBootId(String bootId) {
        this.bootId = bootId;
    }

    public void setBootSystemId(String bootSystemId) {
        this.bootSystemId = bootSystemId;
    }

    public void setMetadata(BootConfig config) {
        this.setBootSystemId(config.getBootSystemId());
        this.setBootId(config.getBootId());
    }

    public void doBR() throws HandlerException {
        this.streamHandler.data((DataReference)this.getType());
        this.streamHandler.data((DataReference)this.getStandardId());
        this.streamHandler.data((DataReference)this.getVDVersion());
        this.streamHandler.data((DataReference)this.getBootSystemId());
        this.streamHandler.data((DataReference)this.getBootId());
    }

    private ByteArrayDataReference getBootSystemId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.bootSystemId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private ByteArrayDataReference getBootId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.bootId, 32);
        return new ByteArrayDataReference(bytes);
    }
}

