/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.StandardConfig;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660NamingConventions;

public class ISO9660Config
extends StandardConfig {
    private boolean restrictDirDepthTo8 = true;
    private boolean allowASCII;
    private boolean padEnd;

    public ISO9660Config() {
        this.allowASCII(false);
    }

    public void setInterchangeLevel(int level) throws ConfigException {
        if (level < 1 || level > 3) {
            throw new ConfigException(this, "Invalid ISO9660 Interchange Level: " + level);
        }
        if (level == 3) {
            throw new ConfigException(this, "Interchange Level 3 (multiple File Sections per file) is not (yet) supported by this implementation.");
        }
        ISO9660NamingConventions.INTERCHANGE_LEVEL = level;
    }

    public void forceDotDelimiter(boolean force) {
        ISO9660NamingConventions.FORCE_DOT_DELIMITER = force;
        if (!force) {
            System.out.println("Warning: Not forcing to include the dot in filenames breaks ISO 9660 conformance.");
        }
    }

    public void allowASCII(boolean allow) {
        this.allowASCII = allow;
        boolean bl = ISO9660NamingConventions.FORCE_ISO9660_CHARSET = !allow;
        if (allow) {
            System.out.println("Warning: Allowing the full ASCII character set breaks ISO 9660 conformance.");
        }
    }

    public boolean allowsASCII() {
        return this.allowASCII;
    }

    public boolean dirDepthRestrictedTo8() {
        return this.restrictDirDepthTo8;
    }

    public void restrictDirDepthTo8(boolean restrictDirDepthTo8) {
        this.restrictDirDepthTo8 = restrictDirDepthTo8;
        if (!restrictDirDepthTo8) {
            System.out.println("Warning: Allowing more than 8 directory levels breaks ISO 9660 conformance.");
        }
    }

    @Override
    public void setDataPreparer(String dataPreparer) throws ConfigException {
        super.setDataPreparer(this.checkAString(dataPreparer));
    }

    @Override
    public void setPublisher(String publisher) throws ConfigException {
        super.setPublisher(this.checkAString(publisher));
    }

    @Override
    public void setSystemID(String systemID) throws ConfigException {
        super.setSystemID(this.checkAString(systemID));
    }

    @Override
    public void setApp(String app) throws ConfigException {
        super.setApp(this.checkAString(app));
    }

    @Override
    public void setVolumeID(String volumeID) throws ConfigException {
        super.setVolumeID(this.checkDString(volumeID));
    }

    @Override
    public void setVolumeSetID(String volumeSetID) throws ConfigException {
        super.setVolumeSetID(this.checkDString(volumeSetID));
    }

    public void setPadEnd(boolean padEnd) {
        this.padEnd = padEnd;
    }

    public boolean getPadEnd() {
        return this.padEnd;
    }

    private String checkAString(String string) {
        if (this.allowsASCII()) {
            return this.checkASCIIString(string);
        }
        return string.toUpperCase().replaceAll("[^- !\"%&'()*+,./:;<=>?0-9A-Z_]", "_");
    }

    private String checkDString(String string) {
        if (this.allowsASCII()) {
            return this.checkASCIIString(string);
        }
        return string.toUpperCase().replaceAll("[^0-9A-Z_]", "_");
    }

    private String checkASCIIString(String string) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            Character.UnicodeBlock characterBlock = Character.UnicodeBlock.of(string.charAt(i));
            if (characterBlock == Character.UnicodeBlock.BASIC_LATIN) {
                buf.append(string.charAt(i));
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }
}

